/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.changeset;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.gwc.GWC;
import org.geoserver.ogcapi.APIException;
import org.geoserver.ogcapi.APIService;
import org.geoserver.ogcapi.InvalidParameterValueException;
import org.geoserver.ogcapi.ResourceNotFoundException;
import org.geoserver.ogcapi.v1.changeset.ChangesetIndexProvider;
import org.geoserver.ogcapi.v1.tiles.TilesServiceInfo;
import org.geotools.api.referencing.FactoryException;
import org.geotools.coverage.grid.io.StructuredGridCoverage2DReader;
import org.geotools.util.NumberRange;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.layer.TileLayer;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@APIService(service="Tiles", version="1.0.1", landingPage="ogc/tiles/v1", core=false, serviceClass=TilesServiceInfo.class)
@RequestMapping(path={"ogc/tiles/v1"})
public class ChangesetTilesService {
    public static final String CHANGESET_MIME = "application/changeset+json";
    public static final String ZIP_MIME = "application/x-zip-compressed";
    public static final String GET_RENDERED_COLLECTION_TILES = "getRenderedCollectionTiles";
    private final ChangesetIndexProvider indexProvider;
    private final Catalog catalog;
    private final GWC gwc;

    public ChangesetTilesService(GWC gwc, ChangesetIndexProvider indexProvider, Catalog catalog) {
        this.gwc = gwc;
        this.indexProvider = indexProvider;
        this.catalog = catalog;
    }

    /*
     * Exception decompiling
     */
    @GetMapping(path={"/collections/{collectionId}/map/{styleId}/tiles/{tileMatrixSetId}"}, name="getRenderedCollectionTiles", produces={"application/changeset+json", "application/x-zip-compressed"})
    @ResponseBody
    public Object getMultiTiles(@PathVariable(name="collectionId") String collectionId, @PathVariable(name="styleId") String styleId, @PathVariable(name="tileMatrixSetId") String tileMatrixSetId, @RequestParam(name="scaleDenominator", required=false) String scaleDenominatorSpec, @RequestParam(name="bbox", required=false) String bboxSpec, @RequestParam(name="f-tile", required=false) String tileFormatSpec, @RequestParam(name="checkPoint", required=false, defaultValue="Initial") String checkpoint, @RequestParam(name="changeSetType", required=false) String changeSetTypeName) throws GeoWebCacheException, IOException, NoSuchAlgorithmException, FactoryException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean rangeHitsGridset(GridSubset gridSubset, NumberRange<Double> scaleRange) {
        GridSet gridSet = gridSubset.getGridSet();
        for (int z = gridSubset.getZoomStart(); z <= gridSubset.getZoomStop(); ++z) {
            if (!scaleRange.contains((Number)gridSet.getGrid(z).getScaleDenominator())) continue;
            return true;
        }
        return false;
    }

    private NumberRange<Double> parseScaleDenominator(String scaleDenominatorSpec) {
        String[] split = scaleDenominatorSpec.split("/");
        if (split.length != 2) {
            throw new InvalidParameterValueException("Unexpected format for 'scaleDenominator', should be minScale/maxScale");
        }
        try {
            double min = Double.parseDouble(split[0]);
            double max = Double.parseDouble(split[1]);
            if (max < min) {
                throw new InvalidParameterValueException("Unexpected values in 'scaleDenominator', minScale/maxScale, but minScale is greater than maxScale");
            }
            return new NumberRange(Double.class, (Number)min, (Number)max);
        }
        catch (NumberFormatException e) {
            throw new InvalidParameterValueException("Unexpected values in 'scaleDenominator', could not parse numbers out of them");
        }
    }

    public StyleInfo getStyle(@PathVariable(name="styleId") String styleId) {
        StyleInfo styleInfo = this.catalog.getStyleByName(styleId);
        if (styleInfo == null) {
            throw new APIException("NotFound", "Could not locate style " + styleId, HttpStatus.NOT_FOUND);
        }
        return styleInfo;
    }

    CoverageInfo getStructuredCoverageInfo(String collectionId, boolean failIfNotFound) throws IOException {
        CoverageInfo coverageInfo = this.catalog.getCoverageByName(collectionId);
        if (coverageInfo != null && coverageInfo.getGridCoverageReader(null, null) instanceof StructuredGridCoverage2DReader) {
            return coverageInfo;
        }
        if (failIfNotFound) {
            throw new ResourceNotFoundException("Could not locate collection " + collectionId);
        }
        return null;
    }

    private TileLayer getTileLayer(String collectionId) {
        try {
            return this.gwc.getTileLayerByName(collectionId);
        }
        catch (IllegalArgumentException e) {
            throw new ResourceNotFoundException("Tiled collection " + collectionId + " not found", (Throwable)e);
        }
    }

    public static enum ChangeSetType {
        summary("summary"),
        pack("package");

        String name;

        private ChangeSetType(String name) {
            this.name = name;
        }

        public static ChangeSetType fromName(String changeSetType) {
            if (changeSetType == null) {
                return null;
            }
            for (ChangeSetType value : ChangeSetType.values()) {
                if (!changeSetType.equals(value.name)) continue;
                return value;
            }
            throw new APIException("IllegalParameterValue", "Could not find a changeset type named " + changeSetType, HttpStatus.BAD_REQUEST);
        }
    }
}

