/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.changeset;

import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.io.IOException;
import java.io.InputStream;
import org.geoserver.ogcapi.GeoServerOpenAPI;
import org.geoserver.ogcapi.OpenAPICallback;
import org.geoserver.ogcapi.v1.tiles.TilesService;
import org.geoserver.ows.Request;
import org.geoserver.util.IOUtils;
import org.springframework.stereotype.Component;

@Component
public class ChangesetAPICallback
implements OpenAPICallback {
    private final GeoServerOpenAPI fragment;

    public ChangesetAPICallback() throws IOException {
        String location = "changeset.yml";
        try (InputStream is = ChangesetAPICallback.class.getResourceAsStream(location);){
            if (is == null) {
                throw new RuntimeException("Could not find API definition at " + location + " from class " + ChangesetAPICallback.class);
            }
            String specFragment = IOUtils.toString((InputStream)is);
            this.fragment = (GeoServerOpenAPI)Yaml.mapper().readValue(specFragment, GeoServerOpenAPI.class);
        }
    }

    public void apply(Request dr, OpenAPI api) {
        if (dr.getServiceDescriptor().getService() instanceof TilesService) {
            String name = "/collections/{collectionId}/map/{styleId}/tiles/{tileMatrixSetId}";
            PathItem multiTileRenderedPath = (PathItem)this.fragment.getPaths().get((Object)"/collections/{collectionId}/map/{styleId}/tiles/{tileMatrixSetId}");
            api.getPaths().addPathItem(name, multiTileRenderedPath);
            Parameter fTileParameter = (Parameter)this.fragment.getComponents().getParameters().get("f-tile");
            api.getComponents().getParameters().put("f-tile", fTileParameter);
            Parameter fParameter = (Parameter)this.fragment.getComponents().getParameters().get("f-json-zip");
            api.getComponents().getParameters().put("f-json-zip", fParameter);
        }
    }
}

