/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.changeset;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.geoserver.ogcapi.v1.changeset.BoundsAndCRS;
import org.geoserver.ogcapi.v1.changeset.ModifiedTiles;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.NumberRange;
import org.geowebcache.mime.MimeType;

public class ChangeSet {
    private String checkpoint;
    private final MimeType tilesMime;
    private final Map<String, String> filterParameters;
    private List<ChangedItem> summaryOfChangedItems = new ArrayList<ChangedItem>();
    private final List<BoundsAndCRS> extentOfChangedItems;
    private ScaleOfChangedItems scaleOfChangedItems;
    private final ModifiedTiles modifiedTiles;

    public ChangeSet(String checkpoint, List<ReferencedEnvelope> extentOfChangedItems, ModifiedTiles modifiedTiles, MimeType tilesMime, Map<String, String> filterParameters) {
        this.checkpoint = checkpoint;
        this.tilesMime = tilesMime;
        this.filterParameters = filterParameters;
        this.summaryOfChangedItems.add(new ChangedItem(Priority.medium, modifiedTiles.getModifiedTiles()));
        this.extentOfChangedItems = extentOfChangedItems.stream().map(re -> new BoundsAndCRS((ReferencedEnvelope)re)).collect(Collectors.toList());
        this.modifiedTiles = modifiedTiles;
    }

    public String getCheckpoint() {
        return this.checkpoint;
    }

    public void setCheckpoint(String checkpoint) {
        this.checkpoint = checkpoint;
    }

    public List<ChangedItem> getSummaryOfChangedItems() {
        return this.summaryOfChangedItems;
    }

    public void setSummaryOfChangedItems(List<ChangedItem> summaryOfChangedItems) {
        this.summaryOfChangedItems = summaryOfChangedItems;
    }

    public List<BoundsAndCRS> getExtentOfChangedItems() {
        return this.extentOfChangedItems;
    }

    public ScaleOfChangedItems getScaleOfChangedItems() {
        return this.scaleOfChangedItems;
    }

    public void setScaleOfChangedItems(NumberRange<Double> scales) {
        this.scaleOfChangedItems = new ScaleOfChangedItems(scales.getMinimum(), scales.getMaximum());
    }

    public void setScaleOfChangedItems(ScaleOfChangedItems scaleOfChangedItems) {
        this.scaleOfChangedItems = scaleOfChangedItems;
    }

    @JsonIgnore
    public ModifiedTiles getModifiedTiles() {
        return this.modifiedTiles;
    }

    @JsonIgnore
    public MimeType getTilesMime() {
        return this.tilesMime;
    }

    @JsonIgnore
    public Map<String, String> getFilterParameters() {
        return this.filterParameters;
    }

    public static class ScaleOfChangedItems {
        Double minScaleDenominator;
        Double maxScaleDenominator;

        public ScaleOfChangedItems(Double minScaleDenominator, Double maxScaleDenominator) {
            if (!Double.isNaN(minScaleDenominator) && !Double.isNaN(maxScaleDenominator)) {
                this.minScaleDenominator = minScaleDenominator;
            }
            if (!Double.isNaN(maxScaleDenominator) && !Double.isInfinite(maxScaleDenominator)) {
                this.maxScaleDenominator = maxScaleDenominator;
            }
        }

        public Double getMinScaleDenominator() {
            return this.minScaleDenominator;
        }

        public Double getMaxScaleDenominator() {
            return this.maxScaleDenominator;
        }

        public String toString() {
            return "ScaleOfChangedItems{minScaleDenominator=" + this.minScaleDenominator + ", maxScaleDenominator=" + this.maxScaleDenominator + "}";
        }
    }

    public static class ChangedItem {
        Priority priority;
        long count;

        public ChangedItem(Priority priority, long count) {
            this.priority = priority;
            this.count = count;
        }

        public Priority getPriority() {
            return this.priority;
        }

        public long getCount() {
            return this.count;
        }

        public String toString() {
            return "ChangedItem{priority=" + this.priority + ", count=" + this.count + "}";
        }
    }

    static enum Priority {
        high,
        medium,
        low;

    }
}

