/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.changeset;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.ogcapi.APIException;
import org.geoserver.ogcapi.v1.changeset.TileIterator;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.FeatureVisitor;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.NumberRange;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.Grid;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.GridSubsetFactory;
import org.geowebcache.layer.TileLayer;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.springframework.http.HttpStatus;

public class ModifiedTiles {
    private final TileLayer tileLayer;
    private final int zoomStart;
    private final int zoomEnd;
    private final GridSubset gridSubset;
    private final List<GridSubset> subsets = new ArrayList<GridSubset>();

    public ModifiedTiles(CoverageInfo coverageInfo, TileLayer tileLayer, GridSubset gridSet, SimpleFeatureCollection changes, ReferencedEnvelope[] boundingBoxes, NumberRange<Double> scaleDenominatorRange) throws FactoryException, IOException {
        this.tileLayer = tileLayer;
        this.gridSubset = gridSet;
        CoordinateReferenceSystem gridsetCrs = CRS.decode((String)("EPSG:" + gridSet.getSRS().getNumber()), (boolean)true);
        List<ReferencedEnvelope> bboxesInGridsetCrs = this.transformBounds(boundingBoxes, gridsetCrs);
        this.zoomStart = scaleDenominatorRange == null ? 0 : this.getMinZoom(gridSet, scaleDenominatorRange.getMaximum());
        this.zoomEnd = scaleDenominatorRange == null ? gridSet.getZoomStop() : this.getMaxZoom(gridSet, scaleDenominatorRange.getMinimum());
        this.fillGridSubsets(gridSet, changes, gridsetCrs, bboxesInGridsetCrs);
    }

    private void fillGridSubsets(final GridSubset gridSubset, SimpleFeatureCollection changes, CoordinateReferenceSystem gridsetCrs, final List<ReferencedEnvelope> bboxesInGridsetCrs) throws FactoryException, IOException {
        CoordinateReferenceSystem geometryCRS = ((SimpleFeatureType)changes.getSchema()).getCoordinateReferenceSystem();
        final MathTransform changesToGridset = CRS.findMathTransform((CoordinateReferenceSystem)geometryCRS, (CoordinateReferenceSystem)gridsetCrs);
        changes.accepts(new FeatureVisitor(){

            public void visit(Feature feature) {
                Geometry geometry = (Geometry)((SimpleFeature)feature).getDefaultGeometry();
                try {
                    Geometry transformed = JTS.transform((Geometry)geometry, (MathTransform)changesToGridset);
                    if (bboxesInGridsetCrs == null || bboxesInGridsetCrs.isEmpty()) {
                        ModifiedTiles.this.subsets.add(ModifiedTiles.this.toGridSubset(gridSubset.getGridSet(), transformed.getEnvelopeInternal(), ModifiedTiles.this.zoomStart, ModifiedTiles.this.zoomEnd));
                    } else {
                        for (ReferencedEnvelope bbox : bboxesInGridsetCrs) {
                            ReferencedEnvelope intersection = bbox.intersection(transformed.getEnvelopeInternal());
                            if (intersection.isEmpty()) continue;
                            ModifiedTiles.this.subsets.add(ModifiedTiles.this.toGridSubset(gridSubset.getGridSet(), (Envelope)intersection, ModifiedTiles.this.zoomStart, ModifiedTiles.this.zoomEnd));
                        }
                    }
                }
                catch (TransformException e) {
                    throw new APIException("InternalError", "Failed to compute modified tiles sets", HttpStatus.INTERNAL_SERVER_ERROR, (Throwable)e);
                }
            }
        }, null);
    }

    private int getMinZoom(GridSubset subset, double scaleRangeMinimum) {
        Grid grid;
        int z;
        if (scaleRangeMinimum <= 0.0) {
            return 0;
        }
        for (z = subset.getZoomStop(); z >= subset.getZoomStart() && !((grid = subset.getGridSet().getGrid(z)).getScaleDenominator() > scaleRangeMinimum); --z) {
        }
        return z > 0 ? z + 1 : 0;
    }

    private int getMaxZoom(GridSubset subset, double scaleRangeMaximum) {
        Grid grid;
        int z;
        for (z = subset.getZoomStart(); z <= subset.getZoomStop() && !((grid = subset.getGridSet().getGrid(z)).getScaleDenominator() < scaleRangeMaximum); ++z) {
        }
        return z < subset.getZoomStop() ? z - 1 : subset.getZoomStop();
    }

    private List<ReferencedEnvelope> transformBounds(ReferencedEnvelope[] boundingBoxes, CoordinateReferenceSystem crs) {
        if (boundingBoxes == null || boundingBoxes.length == 0) {
            return null;
        }
        return Stream.of(boundingBoxes).map(b -> {
            try {
                return b.transform(crs, true);
            }
            catch (Exception e) {
                throw new APIException("InternalError", "Failed to transform requested bbox in native CRS: " + crs, HttpStatus.INTERNAL_SERVER_ERROR, (Throwable)e);
            }
        }).collect(Collectors.toList());
    }

    private GridSubset toGridSubset(GridSet gridSet, Envelope envelope, int zoomStart, int zoomEnd) {
        BoundingBox bbox = new BoundingBox(envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY());
        return GridSubsetFactory.createGridSubSet((GridSet)gridSet, (BoundingBox)bbox, (Integer)zoomStart, (Integer)zoomEnd);
    }

    public Iterator<long[]> getTiles() {
        return new TileIterator(this.subsets, this.zoomStart, this.zoomEnd);
    }

    public long getModifiedTiles() {
        Iterator<long[]> tiles = this.getTiles();
        long count = 0L;
        while (tiles.hasNext()) {
            tiles.next();
            ++count;
        }
        return count;
    }

    public TileLayer getTileLayer() {
        return this.tileLayer;
    }

    public GridSubset getGridSubset() {
        return this.gridSubset;
    }
}

