/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.changeset;

import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.ogcapi.APIRequestInfo;
import org.geoserver.ogcapi.AbstractDocument;
import org.geoserver.ogcapi.DocumentCallback;
import org.geoserver.ogcapi.v1.changeset.ChangeSet;
import org.geoserver.ogcapi.v1.changeset.ChangesetTilesService;
import org.geoserver.ogcapi.v1.tiles.TilesDocument;
import org.geoserver.ows.Request;
import org.geotools.util.logging.Logging;
import org.springframework.stereotype.Component;

@Component
public class ChangeSetLinkCallback
implements DocumentCallback {
    static final Logger LOGGER = Logging.getLogger(ChangeSetLinkCallback.class);
    ChangesetTilesService changesetService;

    public ChangeSetLinkCallback(ChangesetTilesService changesetService) {
        this.changesetService = changesetService;
    }

    public void apply(Request dr, AbstractDocument document) {
        if (document instanceof TilesDocument) {
            TilesDocument tiles = (TilesDocument)document;
            try {
                CoverageInfo coverage = this.changesetService.getStructuredCoverageInfo(tiles.getId(), false);
                if (coverage != null) {
                    List links = APIRequestInfo.get().getLinksFor("ogc/tiles/collections/" + tiles.getId() + "/map/{styleId}/{tileMatrixSetId}", ChangeSet.class, "Changeset as ", "multitile", false, null, null);
                    tiles.getLinks().addAll(links);
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "", e);
            }
        }
    }
}

