/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.changeset;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.internal.JsonContext;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import javax.xml.namespace.QName;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.geoserver.catalog.CascadeDeleteVisitor;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.MockTestData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geoserver.ogcapi.OGCApiTestSupport;
import org.geoserver.ogcapi.v1.changeset.ChangesetIndexProvider;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.image.test.ImageAssert;
import org.geotools.util.URLs;
import org.geowebcache.config.XMLGridSubset;
import org.geowebcache.layer.TileLayer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;

public class ChangesetTest
extends OGCApiTestSupport {
    static final double EPS = 0.001;
    public static final String S2_STORE = "s2";
    static final QName S2 = new QName(MockTestData.SF_URI, "s2", MockTestData.SF_PREFIX);
    static final QName S2_SCALES = new QName(MockTestData.SF_URI, "s2Scales", MockTestData.SF_PREFIX);
    public static final String RASTER_SCALES_STYLE = "raster_scales";
    public static final String S2_LAYER = "sf:s2";
    public static final String S2_SCALES_LAYER = "sf:s2Scales";
    public static final String RASTER_STYLE = "raster";
    private File s2TestData;

    protected void setUpTestData(SystemTestData testData) throws Exception {
    }

    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        testData.addStyle(RASTER_SCALES_STYLE, "raster_scales.sld", ChangesetTest.class, this.getCatalog());
    }

    @Before
    public void setupBaseMosaic() throws Exception {
        File s2Directory = this.getDataDirectory().get(new String[]{S2_STORE}).dir();
        Catalog catalog = this.getCatalog();
        CoverageStoreInfo store = (CoverageStoreInfo)catalog.getStoreByName(S2_STORE, CoverageStoreInfo.class);
        if (store != null) {
            new CascadeDeleteVisitor(catalog).visit(store);
            FileUtils.deleteDirectory((File)s2Directory);
        }
        s2Directory.mkdir();
        this.s2TestData = new File("src/test/resources/org/geoserver/ogcapi/v1/changeset/hetero_s2");
        FileUtils.copyFileToDirectory((File)new File(this.s2TestData, "g1.tif"), (File)s2Directory);
        FileUtils.copyFileToDirectory((File)new File(this.s2TestData, "indexer.properties"), (File)s2Directory);
        CatalogBuilder cb = new CatalogBuilder(catalog);
        cb.setWorkspace(catalog.getWorkspaceByName(MockData.SF_PREFIX));
        CoverageStoreInfo newStore = cb.buildCoverageStore(S2_STORE);
        newStore.setURL(URLs.fileToUrl((File)s2Directory).toExternalForm());
        newStore.setType(new ImageMosaicFormat().getName());
        catalog.add((StoreInfo)newStore);
        cb.setStore((StoreInfo)newStore);
        CoverageInfo ci = cb.buildCoverage();
        catalog.add((ResourceInfo)ci);
        LayerInfo layer = cb.buildLayer(ci);
        catalog.add(layer);
        GWC gwc = (GWC)GeoServerExtensions.bean(GWC.class);
        GeoServerTileLayer tileLayer = gwc.getTileLayer((CatalogInfo)catalog.getLayerByName(this.getLayerId(S2)));
        XMLGridSubset editableWgs84 = new XMLGridSubset(tileLayer.removeGridSubset("EPSG:4326"));
        editableWgs84.setZoomStart(Integer.valueOf(0));
        editableWgs84.setZoomStop(Integer.valueOf(11));
        tileLayer.addGridSubset(editableWgs84.getGridSubSet(gwc.getGridSetBroker()));
        XMLGridSubset editableWebMercator = new XMLGridSubset(tileLayer.removeGridSubset("EPSG:900913"));
        editableWebMercator.setZoomStart(Integer.valueOf(0));
        editableWebMercator.setZoomStop(Integer.valueOf(11));
        tileLayer.addGridSubset(editableWebMercator.getGridSubSet(gwc.getGridSetBroker()));
        gwc.save((TileLayer)tileLayer);
        CoverageInfo ciScales = cb.buildCoverage();
        ciScales.setName("s2Scales");
        catalog.add((ResourceInfo)ciScales);
        LayerInfo layerScales = cb.buildLayer(ciScales);
        layerScales.setDefaultStyle(catalog.getStyleByName(RASTER_SCALES_STYLE));
        catalog.add(layerScales);
    }

    @Test
    public void testGetSummarySingle4326() throws Exception {
        this.uploadImage("g2.tif", S2);
        DocumentContext doc = this.getChangesAsJSONPath(S2_LAYER, RASTER_STYLE, "EPSG:4326", null);
        MatcherAssert.assertThat((Object)((String)doc.read("checkpoint", new Predicate[0])), (Matcher)Matchers.equalTo((Object)"Initial"));
        MatcherAssert.assertThat((Object)((String)doc.read("summaryOfChangedItems[0].priority", new Predicate[0])), (Matcher)Matchers.equalTo((Object)"medium"));
        MatcherAssert.assertThat((Object)((Integer)doc.read("summaryOfChangedItems[0].count", new Predicate[0])), (Matcher)Matchers.equalTo((Object)18));
        MatcherAssert.assertThat((Object)((Integer)doc.read("extentOfChangedItems.size()", new Predicate[0])), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)((String)doc.read("extentOfChangedItems[0].crs", new Predicate[0])), (Matcher)Matchers.equalTo((Object)"http://www.opengis.net/def/crs/OGC/1.3/CRS84"));
        MatcherAssert.assertThat((Object)((Double)doc.read("extentOfChangedItems[0].bbox[0]", new Predicate[0])), (Matcher)Matchers.closeTo((double)11.683611, (double)0.001));
        MatcherAssert.assertThat((Object)((Double)doc.read("extentOfChangedItems[0].bbox[1]", new Predicate[0])), (Matcher)Matchers.closeTo((double)47.63776, (double)0.001));
        MatcherAssert.assertThat((Object)((Double)doc.read("extentOfChangedItems[0].bbox[2]", new Predicate[0])), (Matcher)Matchers.closeTo((double)11.861294, (double)0.001));
        MatcherAssert.assertThat((Object)((Double)doc.read("extentOfChangedItems[0].bbox[3]", new Predicate[0])), (Matcher)Matchers.closeTo((double)47.754253, (double)0.001));
    }

    @Test
    public void testGetSummarySingle4326Scales() throws Exception {
        this.uploadImage("g2.tif", S2_SCALES);
        DocumentContext doc = this.getChangesAsJSONPath(S2_SCALES_LAYER, RASTER_SCALES_STYLE, "EPSG:4326", null);
        MatcherAssert.assertThat((Object)((String)doc.read("checkpoint", new Predicate[0])), (Matcher)Matchers.equalTo((Object)"Initial"));
        MatcherAssert.assertThat((Object)((String)doc.read("summaryOfChangedItems[0].priority", new Predicate[0])), (Matcher)Matchers.equalTo((Object)"medium"));
        MatcherAssert.assertThat((Object)((Integer)doc.read("summaryOfChangedItems[0].count", new Predicate[0])), (Matcher)Matchers.equalTo((Object)8));
        MatcherAssert.assertThat((Object)((Integer)doc.read("extentOfChangedItems.size()", new Predicate[0])), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)((String)doc.read("extentOfChangedItems[0].crs", new Predicate[0])), (Matcher)Matchers.equalTo((Object)"http://www.opengis.net/def/crs/OGC/1.3/CRS84"));
        MatcherAssert.assertThat((Object)((Double)doc.read("extentOfChangedItems[0].bbox[0]", new Predicate[0])), (Matcher)Matchers.closeTo((double)11.683611, (double)0.001));
        MatcherAssert.assertThat((Object)((Double)doc.read("extentOfChangedItems[0].bbox[1]", new Predicate[0])), (Matcher)Matchers.closeTo((double)47.63776, (double)0.001));
        MatcherAssert.assertThat((Object)((Double)doc.read("extentOfChangedItems[0].bbox[2]", new Predicate[0])), (Matcher)Matchers.closeTo((double)11.861294, (double)0.001));
        MatcherAssert.assertThat((Object)((Double)doc.read("extentOfChangedItems[0].bbox[3]", new Predicate[0])), (Matcher)Matchers.closeTo((double)47.754253, (double)0.001));
    }

    @Test
    public void testGetSummarySingle3857() throws Exception {
        this.uploadImage("g2.tif", S2);
        DocumentContext doc = this.getChangesAsJSONPath(S2_LAYER, RASTER_STYLE, "EPSG:900913", null);
        this.checkSummarySingle3857(doc, 16);
    }

    public void checkSummarySingle3857(DocumentContext doc, int expectedChanges) {
        MatcherAssert.assertThat((Object)((String)doc.read("checkpoint", new Predicate[0])), (Matcher)Matchers.equalTo((Object)"Initial"));
        MatcherAssert.assertThat((Object)((String)doc.read("summaryOfChangedItems[0].priority", new Predicate[0])), (Matcher)Matchers.equalTo((Object)"medium"));
        MatcherAssert.assertThat((Object)((Integer)doc.read("summaryOfChangedItems[0].count", new Predicate[0])), (Matcher)Matchers.equalTo((Object)expectedChanges));
        MatcherAssert.assertThat((Object)((Integer)doc.read("extentOfChangedItems.size()", new Predicate[0])), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)((String)doc.read("extentOfChangedItems[0].crs", new Predicate[0])), (Matcher)Matchers.equalTo((Object)"urn:ogc:def:crs:EPSG::900913"));
        MatcherAssert.assertThat((Object)((Double)doc.read("extentOfChangedItems[0].bbox[0]", new Predicate[0])), (Matcher)Matchers.closeTo((double)1300613.0, (double)1.0));
        MatcherAssert.assertThat((Object)((Double)doc.read("extentOfChangedItems[0].bbox[1]", new Predicate[0])), (Matcher)Matchers.closeTo((double)6046801.0, (double)1.0));
        MatcherAssert.assertThat((Object)((Double)doc.read("extentOfChangedItems[0].bbox[2]", new Predicate[0])), (Matcher)Matchers.closeTo((double)1320393.0, (double)1.0));
        MatcherAssert.assertThat((Object)((Double)doc.read("extentOfChangedItems[0].bbox[3]", new Predicate[0])), (Matcher)Matchers.closeTo((double)6066068.0, (double)1.0));
    }

    @Test
    @Ignore
    public void testGetPackageSingle3857() throws Exception {
        this.uploadImage("g2.tif", S2);
        Map<String, byte[]> contents = this.getChangesAsZip(S2_LAYER, "EPSG:900913", null, RASTER_STYLE);
        Assert.assertEquals((long)17L, (long)contents.size());
        MatcherAssert.assertThat(contents.keySet(), (Matcher)Matchers.hasItem((Object)"changeset.json"));
        MatcherAssert.assertThat(contents.keySet(), (Matcher)Matchers.hasItem((Object)"EPSG:900913/EPSG:900913:0/0/0.png"));
        JsonContext json = (JsonContext)JsonPath.parse((InputStream)new ByteArrayInputStream(contents.get("changeset.json")));
        this.checkSummarySingle3857((DocumentContext)json, 16);
        MatcherAssert.assertThat(contents, (Matcher)Matchers.hasKey((Object)"EPSG:900913/EPSG:900913:11/713/1090.png"));
        MatcherAssert.assertThat(contents, (Matcher)Matchers.hasKey((Object)"EPSG:900913/EPSG:900913:11/714/1090.png"));
        MatcherAssert.assertThat(contents, (Matcher)Matchers.hasKey((Object)"EPSG:900913/EPSG:900913:11/713/1091.png"));
        MatcherAssert.assertThat(contents, (Matcher)Matchers.hasKey((Object)"EPSG:900913/EPSG:900913:11/714/1091.png"));
        MatcherAssert.assertThat(contents, (Matcher)Matchers.hasKey((Object)"EPSG:900913/EPSG:900913:10/357/545.png"));
        for (Map.Entry<String, byte[]> file : contents.entrySet()) {
            if (!file.getKey().endsWith(".png")) continue;
            BufferedImage image = ImageIO.read(new ByteArrayInputStream(file.getValue()));
            Assert.assertNotNull((Object)image);
        }
        BufferedImage image = ImageIO.read(new ByteArrayInputStream(contents.get("EPSG:900913/EPSG:900913:10/357/545.png")));
        ImageAssert.assertEquals((File)new File("src/test/resources/org/geoserver/ogcapi/v1/changeset/10_357_545.png"), (RenderedImage)image, (int)100);
    }

    @Test
    public void testGetPackageSingle3857Scales() throws Exception {
        this.uploadImage("g2.tif", S2_SCALES);
        Map<String, byte[]> contents = this.getChangesAsZip(S2_SCALES_LAYER, "EPSG:900913", null, RASTER_SCALES_STYLE);
        Assert.assertEquals((long)14L, (long)contents.size());
        MatcherAssert.assertThat(contents.keySet(), (Matcher)Matchers.hasItem((Object)"changeset.json"));
        MatcherAssert.assertThat(contents.keySet(), (Matcher)CoreMatchers.not((Matcher)Matchers.hasItem((Object)"EPSG:900913/EPSG:900913:0/0/0.png")));
        JsonContext json = (JsonContext)JsonPath.parse((InputStream)new ByteArrayInputStream(contents.get("changeset.json")));
        this.checkSummarySingle3857((DocumentContext)json, 13);
        MatcherAssert.assertThat(contents, (Matcher)Matchers.hasKey((Object)"EPSG:900913/EPSG:900913:11/713/1090.png"));
        MatcherAssert.assertThat(contents, (Matcher)Matchers.hasKey((Object)"EPSG:900913/EPSG:900913:11/714/1090.png"));
        MatcherAssert.assertThat(contents, (Matcher)Matchers.hasKey((Object)"EPSG:900913/EPSG:900913:11/713/1091.png"));
        MatcherAssert.assertThat(contents, (Matcher)Matchers.hasKey((Object)"EPSG:900913/EPSG:900913:11/714/1091.png"));
        for (Map.Entry<String, byte[]> file : contents.entrySet()) {
            if (!file.getKey().endsWith(".png")) continue;
            BufferedImage image = ImageIO.read(new ByteArrayInputStream(file.getValue()));
            Assert.assertNotNull((Object)image);
        }
    }

    @Test
    public void testGetSummaryTwo4326() throws Exception {
        this.uploadImage("g3.tif", S2);
        this.uploadImage("g4.tif", S2);
        DocumentContext doc = this.getChangesAsJSONPath(S2_LAYER, RASTER_STYLE, "EPSG:4326", null);
        MatcherAssert.assertThat((Object)((String)doc.read("checkpoint", new Predicate[0])), (Matcher)Matchers.equalTo((Object)"Initial"));
        MatcherAssert.assertThat((Object)((String)doc.read("summaryOfChangedItems[0].priority", new Predicate[0])), (Matcher)Matchers.equalTo((Object)"medium"));
        MatcherAssert.assertThat((Object)((Integer)doc.read("summaryOfChangedItems[0].count", new Predicate[0])), (Matcher)Matchers.equalTo((Object)18));
        MatcherAssert.assertThat((Object)((Integer)doc.read("extentOfChangedItems.size()", new Predicate[0])), (Matcher)Matchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)((String)doc.read("extentOfChangedItems[0].crs", new Predicate[0])), (Matcher)Matchers.equalTo((Object)"http://www.opengis.net/def/crs/OGC/1.3/CRS84"));
        MatcherAssert.assertThat((Object)((Double)doc.read("extentOfChangedItems[0].bbox[0]", new Predicate[0])), (Matcher)Matchers.closeTo((double)11.683482, (double)0.001));
        MatcherAssert.assertThat((Object)((Double)doc.read("extentOfChangedItems[0].bbox[1]", new Predicate[0])), (Matcher)Matchers.closeTo((double)47.637856, (double)0.001));
        MatcherAssert.assertThat((Object)((Double)doc.read("extentOfChangedItems[0].bbox[2]", new Predicate[0])), (Matcher)Matchers.closeTo((double)11.861166, (double)0.001));
        MatcherAssert.assertThat((Object)((Double)doc.read("extentOfChangedItems[0].bbox[3]", new Predicate[0])), (Matcher)Matchers.closeTo((double)47.754345, (double)0.001));
        MatcherAssert.assertThat((Object)((String)doc.read("extentOfChangedItems[1].crs", new Predicate[0])), (Matcher)Matchers.equalTo((Object)"http://www.opengis.net/def/crs/OGC/1.3/CRS84"));
        MatcherAssert.assertThat((Object)((Double)doc.read("extentOfChangedItems[1].bbox[0]", new Predicate[0])), (Matcher)Matchers.closeTo((double)11.683616, (double)0.001));
        MatcherAssert.assertThat((Object)((Double)doc.read("extentOfChangedItems[1].bbox[1]", new Predicate[0])), (Matcher)Matchers.closeTo((double)47.63785, (double)0.001));
        MatcherAssert.assertThat((Object)((Double)doc.read("extentOfChangedItems[1].bbox[2]", new Predicate[0])), (Matcher)Matchers.closeTo((double)11.8612995, (double)0.001));
        MatcherAssert.assertThat((Object)((Double)doc.read("extentOfChangedItems[1].bbox[3]", new Predicate[0])), (Matcher)Matchers.closeTo((double)47.75434, (double)0.001));
    }

    private void uploadImage(String fileName, QName layerName) throws Exception {
        String layerId = this.getLayerId(layerName);
        byte[] payload = this.getBytes(fileName);
        MockHttpServletResponse response = this.postAsServletResponse("ogc/images/v1/collections/" + layerId + "/images?filename=" + fileName, payload, "image/tiff");
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)201));
        MatcherAssert.assertThat((Object)response.getHeader("Location"), (Matcher)Matchers.startsWith((String)("http://localhost:8080/geoserver/ogc/images/v1/collections/" + ResponseUtils.urlEncode((String)layerId, (char[])new char[0]) + "/images/s2.")));
        DocumentContext json = this.getAsJSONPath(response.getHeader("Location").substring("http://localhost:8080/geoserver/".length()), 200);
        MatcherAssert.assertThat((Object)((String)json.read("type", new Predicate[0])), (Matcher)Matchers.equalTo((Object)"Feature"));
        MatcherAssert.assertThat((Object)((String)json.read("id", new Predicate[0])), (Matcher)Matchers.startsWith((String)"s2."));
        MatcherAssert.assertThat((Object)((String)json.read("properties.datetime", new Predicate[0])), (Matcher)Matchers.equalTo((Object)"1970-01-01T00:00:00Z"));
        MatcherAssert.assertThat((Object)((String)json.read("assets[0].href", new Predicate[0])), (Matcher)Matchers.endsWith((String)fileName));
    }

    public byte[] getBytes(String file) throws IOException {
        byte[] payload = null;
        try (FileInputStream is = new FileInputStream(new File(this.s2TestData, file));){
            payload = IOUtils.toByteArray((InputStream)is);
        }
        return payload;
    }

    protected DocumentContext getChangesAsJSONPath(String collectionId, String styleName, String tileMatrixId, String extraParameters) throws Exception {
        String url = "ogc/tiles/v1/collections/" + collectionId + "/map/" + styleName + "/tiles/" + tileMatrixId + "?f=" + ResponseUtils.urlEncode((String)"application/changeset+json", (char[])new char[0]);
        if (extraParameters != null) {
            url = url + "&" + extraParameters;
        }
        MockHttpServletResponse response = this.getAsMockHttpServletResponse(url, 200);
        Assert.assertEquals((Object)"application/changeset+json", (Object)response.getContentType());
        String lastCheckpoint = this.getLatestCheckpoint(collectionId);
        MatcherAssert.assertThat((Object)response.getHeader("x-checkpoint"), (Matcher)Matchers.equalTo((Object)lastCheckpoint));
        return this.getAsJSONPath(response);
    }

    protected Map<String, byte[]> getChangesAsZip(String collectionId, String tileMatrixId, String extraParameters, String styleName) throws Exception {
        String url = "ogc/tiles/v1/collections/" + collectionId + "/map/" + styleName + "/tiles/" + tileMatrixId + "?f=" + ResponseUtils.urlEncode((String)"application/x-zip-compressed", (char[])new char[0]);
        if (extraParameters != null) {
            url = url + "&" + extraParameters;
        }
        MockHttpServletResponse response = this.getAsMockHttpServletResponse(url, 200);
        Assert.assertEquals((Object)"application/x-zip-compressed", (Object)response.getContentType());
        String lastCheckpoint = this.getLatestCheckpoint(collectionId);
        MatcherAssert.assertThat((Object)response.getHeader("x-checkpoint"), (Matcher)Matchers.equalTo((Object)lastCheckpoint));
        LinkedHashMap<String, byte[]> contents = new LinkedHashMap<String, byte[]>();
        try (ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(response.getContentAsByteArray()));){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                byte[] bytes = IOUtils.toByteArray((InputStream)zis);
                contents.put(entry.getName(), bytes);
            }
        }
        return contents;
    }

    private String getLatestCheckpoint(String collectionId) throws IOException {
        ChangesetIndexProvider provider = (ChangesetIndexProvider)GeoServerExtensions.bean(ChangesetIndexProvider.class);
        return provider.getLatestCheckpoint(this.getCatalog().getCoverageByName(collectionId));
    }
}

