/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.changeset;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geoserver.ogcapi.v1.changeset.ChangesetIndexProvider;
import org.geoserver.ogcapi.v1.images.ImageListener;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.geometry.Bounds;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheException;
import org.springframework.stereotype.Component;

@Component
public class ChangesetImageListener
implements ImageListener {
    static final Logger LOGGER = Logging.getLogger(ChangesetImageListener.class);
    private final GWC gwc;
    private final ChangesetIndexProvider indexProvider;
    private final Catalog catalog;

    public ChangesetImageListener(Catalog catalog, ChangesetIndexProvider indexProvider, GWC gwc) throws IOException {
        this.indexProvider = indexProvider;
        this.gwc = gwc;
        this.catalog = catalog;
    }

    public void imageAdded(CoverageInfo ci, SimpleFeature feature) {
        try {
            this.indexProvider.addCheckpoint(ci, feature);
            this.truncateTilesForCoverage(ci, feature);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Failure while trying to record a image added checkpoint", e);
        }
    }

    public void imageRemoved(CoverageInfo ci, SimpleFeature feature) {
        try {
            this.indexProvider.addCheckpoint(ci, feature);
            this.truncateTilesForCoverage(ci, feature);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Failure while trying to record a image removed checkpoint", e);
        }
    }

    private void truncateTilesForCoverage(CoverageInfo ci, SimpleFeature feature) {
        this.catalog.getLayers((ResourceInfo)ci).stream().map(l -> this.gwc.getTileLayer((CatalogInfo)l)).filter(tl -> tl != null).forEach(tl -> this.truncateTilesForTileLayer((GeoServerTileLayer)tl, feature));
    }

    private void truncateTilesForTileLayer(GeoServerTileLayer tl, SimpleFeature feature) {
        try {
            this.gwc.truncate(tl.getName(), ReferencedEnvelope.reference((Bounds)feature.getBounds()));
        }
        catch (GeoWebCacheException e) {
            LOGGER.log(Level.SEVERE, "Failed to truncate tiles for " + tl, e);
        }
    }
}

