/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.schemalessfeatures.mongodb.filter;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bson.conversions.Bson;
import org.geoserver.schemalessfeatures.mongodb.MongoSchemalessUtils;
import org.geotools.api.feature.type.Name;
import org.geotools.util.logging.Logging;

public class MongoTypeFinder {
    private static final Logger LOG = Logging.getLogger(MongoTypeFinder.class);
    private MongoCollection<DBObject> collection;
    private Name name;

    public MongoTypeFinder(Name name, MongoCollection<DBObject> collection) {
        this.name = name;
        this.collection = collection;
    }

    public Class<?> getAttributeType(String attribute) {
        String mongoPath = MongoSchemalessUtils.toMongoPath(attribute);
        Bson projection = Projections.fields((Bson[])new Bson[]{Projections.include((String[])new String[]{mongoPath}), Projections.excludeId()});
        Bson query = Filters.ne((String)mongoPath, null);
        try (MongoCursor cursor = this.collection.find(query).projection(projection).limit(1).cursor();){
            Class<?> result = null;
            if (cursor.hasNext()) {
                DBObject dbRes = (DBObject)cursor.next();
                result = this.getFieldType(dbRes);
            }
            Class<?> clazz = result;
            return clazz;
        }
    }

    private Class<?> getFieldType(Object document) {
        if (document instanceof BasicDBList) {
            BasicDBList list = (BasicDBList)document;
            for (int i = 0; i < list.size(); ++i) {
                Class<?> result;
                Object element = list.get(i);
                if (element == null || (result = this.getFieldType(element)) == null) continue;
                return result;
            }
        } else if (document instanceof BasicDBObject) {
            DBObject object = (DBObject)document;
            Set keys = object.keySet();
            for (String k : keys) {
                Object value = object.get(k);
                if (value == null) continue;
                return this.getFieldType(value);
            }
        } else {
            return document.getClass();
        }
        return null;
    }

    public String getGeometryPath() {
        String geometryPath = this.findGeometryPathByIndex();
        if (geometryPath == null) {
            geometryPath = this.findGeometryPathFromData();
        }
        if (geometryPath == null) {
            LOG.log(Level.WARNING, "No geometry path found for type {0}, in collection {1}", new Object[]{this.name.toString(), this.collection.getNamespace().getFullName()});
        }
        return geometryPath;
    }

    private String findGeometryPathByIndex() {
        String geometryPath = null;
        Set<String> geometries = MongoSchemalessUtils.findIndexedGeometries(this.collection);
        if (geometries != null && !geometries.isEmpty()) {
            geometryPath = geometries.iterator().next();
            if (geometries.size() > 1) {
                LOG.log(Level.WARNING, "More than one indexed geometry field found for type {0}, selecting {1} (first one encountered with index search of collection {2})", new Object[]{this.name.toString(), geometryPath, this.collection.getNamespace().getFullName()});
            }
        }
        return geometryPath;
    }

    private String findGeometryPathFromData() {
        String geomPath = null;
        try (MongoCursor cursor = this.collection.find().cursor();){
            while (cursor.hasNext()) {
                DBObject dbObject = (DBObject)cursor.next();
                geomPath = this.findGeometryPathFromData(dbObject, "");
                if (geomPath == null) continue;
                break;
            }
        }
        return geomPath;
    }

    private String findGeometryPathFromData(Object object, String path) {
        block4: {
            block3: {
                if (!(object instanceof BasicDBList)) break block3;
                BasicDBList list = (BasicDBList)object;
                for (int i = 0; i < list.size(); ++i) {
                    String geometryPath = this.findGeometryPathFromData(list.get(i), this.addPathPart(path, String.valueOf(i)));
                    if (geometryPath == null) continue;
                    return geometryPath;
                }
                break block4;
            }
            if (!(object instanceof BasicDBObject)) break block4;
            BasicDBObject dbObject = (BasicDBObject)object;
            if (MongoSchemalessUtils.isGeometry((DBObject)dbObject)) {
                return path;
            }
            Set keys = dbObject.keySet();
            for (String k : keys) {
                String geometryPath = this.findGeometryPathFromData(dbObject.get(k), this.addPathPart(path, k));
                if (geometryPath == null) continue;
                return geometryPath;
            }
        }
        return null;
    }

    private String addPathPart(String path, String toAdd) {
        if (path.trim().equals("")) {
            return toAdd;
        }
        return path + "." + toAdd;
    }
}

