/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.schemalessfeatures.mongodb.data;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.geoserver.schemalessfeatures.data.ComplexContentDataAccess;
import org.geoserver.schemalessfeatures.data.ComplexFeatureSource;
import org.geoserver.schemalessfeatures.data.SchemalessFeatureSource;
import org.geoserver.schemalessfeatures.mongodb.MongoSchemalessUtils;
import org.geoserver.schemalessfeatures.mongodb.data.MongoComplexReader;
import org.geoserver.schemalessfeatures.mongodb.filter.MongoTypeFinder;
import org.geoserver.schemalessfeatures.mongodb.filter.SchemalessFilterToMongo;
import org.geotools.api.data.FeatureReader;
import org.geotools.api.data.Query;
import org.geotools.api.data.QueryCapabilities;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.feature.type.GeometryType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.BinaryComparisonOperator;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.api.filter.sort.SortOrder;
import org.geotools.api.geometry.MismatchedDimensionException;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.data.DataUtilities;
import org.geotools.data.FilteringFeatureReader;
import org.geotools.data.mongodb.MongoCollectionMeta;
import org.geotools.data.mongodb.MongoFilterSplitter;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;

public class MongoSchemalessFeatureSource
extends SchemalessFeatureSource {
    private MongoCollection<DBObject> collection;
    private MongoTypeFinder dataTypeFinder;

    public MongoSchemalessFeatureSource(Name name, MongoCollection<DBObject> collection, ComplexContentDataAccess store) {
        super(name, store);
        this.collection = collection;
        this.dataTypeFinder = new MongoTypeFinder(name, collection);
    }

    protected GeometryDescriptor getGeometryDescriptor() {
        String geometryAttributeName;
        String geometryPath = this.dataTypeFinder.getGeometryPath();
        if (geometryPath == null) {
            return null;
        }
        AttributeTypeBuilder attributeBuilder = new AttributeTypeBuilder();
        attributeBuilder.setBinding(Geometry.class);
        if (geometryPath.indexOf(".") != -1) {
            String[] splitted = geometryPath.split("\\.");
            geometryAttributeName = splitted[splitted.length - 1];
        } else {
            geometryAttributeName = geometryPath;
        }
        attributeBuilder.setName(geometryAttributeName);
        attributeBuilder.setNamespaceURI(this.name.getNamespaceURI());
        attributeBuilder.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        GeometryType type = attributeBuilder.buildGeometryType();
        type.getUserData().put("geometry_path", geometryPath);
        return attributeBuilder.buildDescriptor(this.name(this.name.getNamespaceURI(), geometryPath), type);
    }

    protected FeatureReader<FeatureType, Feature> getReaderInteranl(Query query) {
        ArrayList<Filter> postFilterList = new ArrayList<Filter>();
        MongoComplexReader reader = new MongoComplexReader(this.toCursor(query, postFilterList), (ComplexFeatureSource)this, query);
        if (!postFilterList.isEmpty()) {
            return new FilteringFeatureReader((FeatureReader)reader, (Filter)postFilterList.get(0));
        }
        return reader;
    }

    protected int getCountInteral(Query query) {
        BasicDBObject queryDBO = new BasicDBObject();
        Filter f = query.getFilter();
        if (!this.isAll(f)) {
            Filter[] split = this.splitFilter(f);
            queryDBO = this.toQuery(split[0]);
            if (!this.isAll(split[1])) {
                return -1;
            }
        }
        return Long.valueOf(this.collection.countDocuments((Bson)queryDBO)).intValue();
    }

    MongoCursor<DBObject> toCursor(Query q, List<Filter> postFilter) {
        FindIterable it;
        String[] propertyNames;
        BasicDBObject query = new BasicDBObject();
        Filter f = q.getFilter();
        if (!this.isAll(f)) {
            Filter[] split = this.splitFilter(f);
            query = this.toQuery(split[0]);
            if (!this.isAll(split[1])) {
                postFilter.add(split[1]);
            }
        }
        if ((propertyNames = q.getPropertyNames()) != Query.ALL_NAMES) {
            BasicDBObject keys = new BasicDBObject();
            for (String string : propertyNames) {
                keys.put(MongoSchemalessUtils.toMongoPath(string), (Object)1);
            }
            for (Filter postF : postFilter) {
                String[] attributeNames;
                for (String attrName : attributeNames = DataUtilities.attributeNames((Filter)postF)) {
                    if (attrName == null || attrName.isEmpty() || keys.containsField(attrName)) continue;
                    keys.put(MongoSchemalessUtils.toMongoPath(attrName), (Object)1);
                }
            }
            String geometryPath = this.getGeometryPath();
            if (geometryPath != null && !keys.containsField(geometryPath)) {
                keys.put(geometryPath, (Object)1);
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(String.format("find(%s, %s)", query, keys));
            }
            it = this.collection.find((Bson)query).projection((Bson)keys);
        } else {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(String.format("find(%s)", query));
            }
            it = this.collection.find((Bson)query);
        }
        if (q.getStartIndex() != null && q.getStartIndex() != 0) {
            it = it.skip(q.getStartIndex().intValue());
        }
        if (q.getMaxFeatures() != Integer.MAX_VALUE) {
            it = it.limit(q.getMaxFeatures());
        }
        if (q.getSortBy() != null) {
            BasicDBObject orderBy = new BasicDBObject();
            for (SortBy sortBy : q.getSortBy()) {
                if (sortBy.getPropertyName() == null) continue;
                String propName = sortBy.getPropertyName().getPropertyName();
                String property = MongoSchemalessUtils.toMongoPath(propName);
                orderBy.append(property, (Object)(sortBy.getSortOrder() == SortOrder.ASCENDING ? 1 : -1));
            }
            it = it.sort((Bson)orderBy);
        }
        return it.cursor();
    }

    DBObject toQuery(Filter f) {
        if (this.isAll(f)) {
            return new BasicDBObject();
        }
        SimpleReprojectingVisitor reprojectingFilterVisitor = new SimpleReprojectingVisitor();
        f = (Filter)f.accept((FilterVisitor)reprojectingFilterVisitor, null);
        SchemalessFilterToMongo v = new SchemalessFilterToMongo(this.getSchema(), this.collection);
        return (DBObject)f.accept((FilterVisitor)v, null);
    }

    Filter[] splitFilter(Filter f) {
        MongoFilterSplitter splitter = new MongoFilterSplitter(this.getDataStore().getFilterCapabilities(), null, null, new MongoCollectionMeta(this.getIndexesInfoMap())){

            protected void visitBinaryComparisonOperator(BinaryComparisonOperator filter) {
                Expression expression1 = filter.getExpression1();
                Expression expression2 = filter.getExpression2();
                if (expression1 instanceof PropertyName && expression2 instanceof Literal) {
                    this.preStack.push(filter);
                } else if (expression2 instanceof PropertyName && expression1 instanceof Literal) {
                    this.preStack.push(filter);
                } else {
                    super.visitBinaryComparisonOperator(filter);
                }
            }
        };
        f.accept((FilterVisitor)splitter, null);
        return new Filter[]{splitter.getFilterPre(), splitter.getFilterPost()};
    }

    private Map<String, String> getIndexesInfoMap() {
        HashMap<String, String> indexes = new HashMap<String, String>();
        for (Document doc : this.collection.listIndexes()) {
            Document key = (Document)doc.get((Object)"key");
            if (key == null) continue;
            for (Map.Entry indexData : key.entrySet()) {
                indexes.put(indexData.getKey().toString(), indexData.getValue().toString());
            }
        }
        return indexes;
    }

    public QueryCapabilities getQueryCapabilities() {
        QueryCapabilities capabilities = new QueryCapabilities(){

            public boolean isOffsetSupported() {
                return true;
            }

            public boolean supportsSorting(SortBy ... sortAttributes) {
                return true;
            }
        };
        return capabilities;
    }

    private String getGeometryPath() {
        GeometryDescriptor descriptor = this.getGeometryDescriptor();
        if (descriptor == null) {
            return null;
        }
        return descriptor.getType().getUserData().get("geometry_path").toString();
    }

    protected ReferencedEnvelope getBoundsInternal(Query q) throws IOException {
        String geometryPath = this.getGeometryPath();
        if (geometryPath != null) {
            q = new Query(q);
            q.setPropertyNames(new String[]{MongoSchemalessUtils.toPropertyName(geometryPath)});
        }
        return super.getBoundsInternal(q);
    }

    private class SimpleReprojectingVisitor
    extends DuplicatingFilterVisitor {
        private SimpleReprojectingVisitor() {
        }

        public Object visit(Literal expression, Object extraData) {
            if (expression.getValue() instanceof Geometry) {
                Geometry geom = (Geometry)expression.getValue();
                CoordinateReferenceSystem crs = JTS.getCRS((Geometry)geom);
                if (crs != null && !CRS.equalsIgnoreMetadata((Object)crs, (Object)DefaultGeographicCRS.WGS84)) {
                    try {
                        geom = JTS.transform((Geometry)geom, (MathTransform)CRS.findMathTransform((CoordinateReferenceSystem)crs, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
                    }
                    catch (MismatchedDimensionException | FactoryException | TransformException e) {
                        throw new RuntimeException(e);
                    }
                }
                return this.ff.literal((Object)geom);
            }
            if (expression.getValue() instanceof ReferencedEnvelope) {
                ReferencedEnvelope env = (ReferencedEnvelope)expression.getValue();
                CoordinateReferenceSystem crs = env.getCoordinateReferenceSystem();
                if (crs != null && !CRS.equalsIgnoreMetadata((Object)crs, (Object)DefaultGeographicCRS.WGS84)) {
                    try {
                        Envelope transformedEnv = JTS.transform((Envelope)env, (MathTransform)CRS.findMathTransform((CoordinateReferenceSystem)crs, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
                        env = new ReferencedEnvelope(transformedEnv, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
                    }
                    catch (TransformException e) {
                        throw new RuntimeException(e);
                    }
                    catch (FactoryException e) {
                        throw new RuntimeException(e);
                    }
                }
                return this.ff.literal((Object)env);
            }
            return super.visit(expression, extraData);
        }
    }
}

