/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.schemalessfeatures.mongodb;

import com.mongodb.DBObject;
import com.mongodb.client.MongoCollection;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.geotools.data.mongodb.MongoUtil;

public class MongoSchemalessUtils {
    public static final String GEOMETRY_PATH = "geometry_path";

    public static Set<String> findIndexedGeometries(MongoCollection collection) {
        List indexes = (List)collection.listIndexes(DBObject.class).into(new ArrayList());
        return MongoUtil.findIndexedFields((List)indexes, (String)"2dsphere");
    }

    public static String toMongoPath(String pn) {
        String[] splittedPn = pn.split("/");
        StringBuilder sb = new StringBuilder("");
        String prev = null;
        for (int i = 0; i < splittedPn.length; ++i) {
            String nameCapitalized;
            String xpathStep = splittedPn[i];
            if (xpathStep.indexOf(":") != -1) {
                xpathStep = xpathStep.split(":")[1];
            }
            String string = nameCapitalized = prev != null ? prev.substring(0, 1).toUpperCase() + prev.substring(1) + "Feature" : null;
            if (!xpathStep.equals(nameCapitalized)) {
                sb.append(xpathStep);
                if (i != splittedPn.length - 1) {
                    sb.append(".");
                }
            }
            prev = xpathStep;
        }
        return sb.toString();
    }

    public static String toPropertyName(String mongoPath) {
        return mongoPath.replaceAll("\\.", "/");
    }

    public static boolean isGeometry(DBObject object) {
        Set keys = object.keySet();
        if (!keys.contains("type") || keys.size() != 2) {
            return false;
        }
        String type = (String)object.get("type");
        boolean isColl = "GeometryCollection".equals(type);
        return isColl && keys.contains("geometries") || !isColl && keys.contains("coordinates");
    }
}

