/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.schemalessfeatures.mongodb.filter;

import com.mongodb.DBObject;
import com.mongodb.client.MongoCollection;
import org.geoserver.schemalessfeatures.mongodb.MongoSchemalessUtils;
import org.geoserver.schemalessfeatures.mongodb.filter.MongoTypeFinder;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.data.mongodb.AbstractFilterToMongo;

public class SchemalessFilterToMongo
extends AbstractFilterToMongo {
    private MongoTypeFinder typeFinder;

    public SchemalessFilterToMongo(FeatureType featureType, MongoCollection<DBObject> collection) {
        this.setFeatureType(featureType);
        this.typeFinder = new MongoTypeFinder(featureType.getName(), collection);
    }

    protected String getGeometryPath() {
        Object path = this.featureType.getGeometryDescriptor().getType().getUserData().get("geometry_path");
        if (path == null) {
            path = this.typeFinder.getGeometryPath();
        }
        if (path != null) {
            return path.toString();
        }
        return null;
    }

    protected String getPropertyPath(String prop) {
        return MongoSchemalessUtils.toMongoPath(prop);
    }

    protected Class<?> getValueTypeInternal(Expression e) {
        Class<?> clazz = null;
        if (e instanceof PropertyName) {
            clazz = this.typeFinder.getAttributeType(((PropertyName)e).getPropertyName());
        }
        return clazz;
    }
}

