/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.schemalessfeatures.mongodb;

import com.mongodb.ConnectionString;
import com.mongodb.client.MongoClients;
import java.io.File;
import java.nio.file.Files;
import org.geoserver.schemalessfeatures.mongodb.MongoTestSetup;

public class StationsTestSetup
extends MongoTestSetup {
    public static final String COLLECTION_NAME = "geoJSONStations";
    private static final String TEST_DATA_DIR = "test-data/stations";
    private String dataBaseName;

    public StationsTestSetup(String dataBaseName) {
        this.dataBaseName = dataBaseName;
    }

    @Override
    protected void setUpData() throws Exception {
        String connectionString = this.fixture.getProperty("mongo.connectionString");
        ConnectionString connectionStringBO = new ConnectionString(connectionString);
        this.client = MongoClients.create((ConnectionString)connectionStringBO);
        this.database = this.client.getDatabase(this.dataBaseName);
        if (this.database.getCollection(COLLECTION_NAME).countDocuments() == 0L) {
            File[] stations;
            this.collection = this.database.getCollection(COLLECTION_NAME);
            this.addGeometryIndex();
            File resource = new File(this.getClass().getResource("test-data/stations/json").toURI());
            for (File f : stations = resource.listFiles()) {
                String stationsContent = new String(Files.readAllBytes(f.toPath()));
                this.insertJson(stationsContent);
            }
        }
    }

    @Override
    public void tearDown() {
        this.database.drop();
        this.client.close();
    }
}

