/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.schemalessfeatures.mongodb;

import java.util.Arrays;
import java.util.List;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.schemalessfeatures.mongodb.AbstractMongoDBOnlineTestSupport;
import org.geoserver.schemalessfeatures.mongodb.MongoTestSetup;
import org.geoserver.schemalessfeatures.mongodb.StationsTestSetup;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.Query;
import org.geotools.api.feature.Feature;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SchemalessCollectionTest
extends AbstractMongoDBOnlineTestSupport {
    private static final String DATA_STORE_NAME = "stationsMongoWfs";
    private static MongoTestSetup testSetup;
    private static FilterFactory FF;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        Catalog cat = this.getCatalog();
        DataStoreInfo storeInfo = cat.getDataStoreByName(DATA_STORE_NAME);
        if (storeInfo == null) {
            WorkspaceInfo wi = cat.getDefaultWorkspace();
            storeInfo = this.addMongoSchemalessStore(wi, DATA_STORE_NAME);
            this.addMongoSchemalessLayer(wi, storeInfo, "geoJSONStations");
        }
    }

    @Override
    protected MongoTestSetup createTestSetups() {
        StationsTestSetup setup = new StationsTestSetup(this.databaseName);
        testSetup = setup;
        return setup;
    }

    @AfterClass
    public static void tearDown() {
        if (testSetup != null) {
            testSetup.tearDown();
        }
    }

    @Test
    public void testPropertyNameWithDotSeparator() throws Exception {
        FeatureTypeInfo fti = this.getCatalog().getFeatureTypeByName("gs:geoJSONStations");
        FeatureSource source = fti.getFeatureSource(null, null);
        PropertyIsEqualTo eq1 = FF.equals((Expression)FF.property("name"), (Expression)FF.literal((Object)"station 2"));
        FeatureIterator it = source.getFeatures((Filter)eq1).features();
        PropertyName pn = FF.property("measurements.values.value");
        while (it.hasNext()) {
            Feature f = it.next();
            Object result = pn.evaluate((Object)f);
            if (!(result instanceof List)) continue;
            List listRes = (List)result;
            Assert.assertEquals((long)5L, (long)listRes.size());
            Assert.assertTrue((boolean)listRes.containsAll(Arrays.asList(35, 25, 80, 1019, 1015)));
        }
    }

    @Test
    public void testPropertyNameReturningNestedFeaturesList() throws Exception {
        Feature f;
        FeatureTypeInfo fti = this.getCatalog().getFeatureTypeByName("gs:geoJSONStations");
        FeatureSource source = fti.getFeatureSource(null, null);
        PropertyIsEqualTo eq1 = FF.equals((Expression)FF.property("name"), (Expression)FF.literal((Object)"station 2"));
        FeatureIterator it = source.getFeatures((Filter)eq1).features();
        PropertyName pn = FF.property("measurements.values");
        Object result = pn.evaluate((Object)(f = it.next()));
        if (result instanceof List) {
            List listRes = (List)result;
            Assert.assertEquals((long)5L, (long)listRes.size());
            ((List)result).forEach(e -> Assert.assertTrue((boolean)(e instanceof Feature)));
        }
    }

    @Test
    public void testPostFilterEvaluation() throws Exception {
        FeatureTypeInfo fti = this.getCatalog().getFeatureTypeByName("gs:geoJSONStations");
        FeatureSource source = fti.getFeatureSource(null, null);
        Function filter = FF.function("filter", new Expression[]{FF.literal((Object)"value < 40")});
        Function stream = FF.function("stream", new Expression[]{FF.property("measurements.values"), filter, FF.property("value")});
        Function aggregate = FF.function("aggregate", new Expression[]{stream, FF.literal((Object)"AVG")});
        PropertyIsEqualTo eq = FF.equals((Expression)aggregate, (Expression)FF.literal(30));
        FeatureCollection collection = source.getFeatures((Filter)eq);
        collection.size();
        FeatureIterator it = collection.features();
        PropertyName pn = FF.property("measurements.values.value");
        while (it.hasNext()) {
            Feature f = it.next();
            Object result = pn.evaluate((Object)f);
            List values = (List)result;
            this.assertAvg(values);
        }
    }

    @Test
    public void testWrongPropertyName() throws Exception {
        FeatureTypeInfo fti = this.getCatalog().getFeatureTypeByName("gs:geoJSONStations");
        FeatureSource source = fti.getFeatureSource(null, null);
        FeatureCollection collection = source.getFeatures(Query.ALL);
        FeatureIterator it = collection.features();
        PropertyName pn = FF.property("some_wrong_heading.measurements.values.value");
        while (it.hasNext()) {
            Feature f = it.next();
            Object result = pn.evaluate((Object)f);
            Assert.assertNull((Object)result);
        }
    }

    private void assertAvg(List<Number> result) {
        int sum = 0;
        int denom = 0;
        for (Number n : result) {
            int integer = n.intValue();
            if (integer >= 40) continue;
            sum += integer;
            ++denom;
        }
        Assert.assertEquals((long)30L, (long)(sum / denom));
    }

    @Test
    public void testNotExistingPropUnderUnboundedFeatures() throws Exception {
        FeatureTypeInfo fti = this.getCatalog().getFeatureTypeByName("gs:geoJSONStations");
        FeatureSource source = fti.getFeatureSource(null, null);
        FeatureCollection collection = source.getFeatures((Filter)FF.equals((Expression)FF.property("name"), (Expression)FF.literal((Object)"station 1")));
        FeatureIterator it = collection.features();
        PropertyName pn = FF.property("measurements.notExisting");
        Feature f = it.next();
        Assert.assertNull((Object)pn.evaluate((Object)f));
    }

    static {
        FF = CommonFactoryFinder.getFilterFactory();
    }
}

