/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.web;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.NumberTextField;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.featurestemplating.configuration.SupportedFormat;
import org.geoserver.featurestemplating.configuration.TemplateInfo;
import org.geoserver.featurestemplating.configuration.TemplateInfoDAO;
import org.geoserver.featurestemplating.configuration.TemplateRule;
import org.geoserver.featurestemplating.configuration.TemplateRuleService;
import org.geoserver.featurestemplating.web.OutputFormatsDropDown;
import org.geoserver.featurestemplating.web.TemplateConfigurationException;
import org.geoserver.featurestemplating.web.TemplateModelsValidator;
import org.geoserver.featurestemplating.web.TemplateRulesTablePanel;
import org.geoserver.util.XCQL;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geotools.filter.text.cql2.CQLException;

public class TemplateRuleConfigurationPanel
extends Panel {
    CompoundPropertyModel<TemplateRule> templateRuleModel;
    TemplateRulesTablePanel tablePanel;
    Form<TemplateRule> theForm;
    NumberTextField<Integer> priorityField;
    DropDownChoice<TemplateInfo> templateInfoDropDownChoice;
    OutputFormatsDropDown mimeTypeDropDown;
    TextArea<String> cqlFilterArea;
    TextArea<String> profileField;
    FeedbackPanel ruleFeedbackPanel;
    LayerInfo layer;
    Label submitLabel;
    Model<String> submitLabelModel;
    Label panelLabel;
    Model<String> panelLabelModel;

    public TemplateRuleConfigurationPanel(String id, CompoundPropertyModel<TemplateRule> model, boolean isUpdate, LayerInfo layer) {
        super(id, model);
        this.layer = layer;
        this.templateRuleModel = model;
        this.initUI(this.templateRuleModel, isUpdate);
    }

    private void initUI(CompoundPropertyModel<TemplateRule> model, boolean isUpdate) {
        this.panelLabelModel = Model.of((Serializable)((Object)this.getPanelLabelValue("add")));
        this.panelLabel = new Label("ruleConfigurationLabel", (IModel)this.panelLabelModel);
        this.panelLabel.setOutputMarkupId(true);
        this.add(new Component[]{this.panelLabel});
        this.theForm = new Form("theForm", model);
        this.theForm.setOutputMarkupId(true);
        Component[] componentArray = new Component[1];
        this.ruleFeedbackPanel = new FeedbackPanel("ruleFeedback");
        componentArray[0] = this.ruleFeedbackPanel;
        this.theForm.add(componentArray);
        this.ruleFeedbackPanel.setOutputMarkupId(true);
        this.add(new Component[]{this.theForm});
        this.priorityField = new NumberTextField("priority", model.bind("priority"));
        this.theForm.add(new Component[]{this.priorityField});
        ChoiceRenderer templateInfoChoicheRenderer = new ChoiceRenderer("fullName", "identifier");
        this.templateInfoDropDownChoice = new DropDownChoice("templateIdentifier", model.bind("templateInfo"), this.getTemplateInfoList(), (IChoiceRenderer)templateInfoChoicheRenderer);
        this.templateInfoDropDownChoice.setOutputMarkupId(true);
        this.theForm.add(new Component[]{this.templateInfoDropDownChoice});
        this.mimeTypeDropDown = new OutputFormatsDropDown("outputFormats", (IModel<SupportedFormat>)model.bind("outputFormat"));
        this.mimeTypeDropDown.setOutputMarkupId(true);
        this.theForm.add(new Component[]{this.mimeTypeDropDown});
        this.profileField = new TextArea("profileFilter", model.bind("profileFilter"));
        this.profileField.setOutputMarkupId(true);
        this.profileField.add(this.getCqlValidator());
        this.theForm.add(new Component[]{this.profileField});
        this.cqlFilterArea = new TextArea("cqlFilter", model.bind("cqlFilter"));
        this.cqlFilterArea.setOutputMarkupId(true);
        this.cqlFilterArea.add(this.getCqlValidator());
        this.theForm.add(new Component[]{this.cqlFilterArea});
        AjaxSubmitLink submitLink = new AjaxSubmitLink("save"){

            protected void onSubmit(AjaxRequestTarget target) {
                super.onSubmit(target);
                TemplateRuleConfigurationPanel.this.cleanFeedbackPanel();
                TemplateRule rule = (TemplateRule)TemplateRuleConfigurationPanel.this.theForm.getModelObject();
                if (!TemplateRuleConfigurationPanel.this.validateAndReport(rule)) {
                    return;
                }
                TemplateRuleConfigurationPanel.this.updateModelRules(rule);
                target.add(new Component[]{TemplateRuleConfigurationPanel.this.tablePanel});
                target.add(new Component[]{TemplateRuleConfigurationPanel.this.tablePanel.getTable()});
                TemplateRuleConfigurationPanel.this.clearForm(target);
            }

            protected void onAfterSubmit(AjaxRequestTarget target) {
                if (TemplateRuleConfigurationPanel.this.theForm.hasError()) {
                    target.add(new Component[]{TemplateRuleConfigurationPanel.this.ruleFeedbackPanel});
                }
            }

            protected void onError(AjaxRequestTarget target) {
                super.onError(target);
                if (TemplateRuleConfigurationPanel.this.theForm.hasError()) {
                    target.add(new Component[]{TemplateRuleConfigurationPanel.this.ruleFeedbackPanel});
                }
            }
        };
        this.submitLabelModel = Model.of((Serializable)((Object)this.getSubmitLabelValue("add")));
        this.submitLabel = new Label("submitLabel", (IModel)this.submitLabelModel);
        this.submitLabel.setOutputMarkupId(true);
        submitLink.add(new Component[]{this.submitLabel});
        this.theForm.add(new Component[]{submitLink});
        this.theForm.add(new Component[]{new AjaxSubmitLink("cancel"){

            public void onSubmit(AjaxRequestTarget target) {
                TemplateRuleConfigurationPanel.this.clearForm(target);
            }
        }});
    }

    private boolean validateAndReport(TemplateRule rule) {
        boolean result = true;
        try {
            TemplateModelsValidator validator = new TemplateModelsValidator();
            validator.validate(rule);
        }
        catch (TemplateConfigurationException e) {
            this.theForm.error((Serializable)((Object)e.getMessage()));
            result = false;
        }
        return result;
    }

    protected List<TemplateInfo> getTemplateInfoList() {
        ResourceInfo resourceInfo = this.layer.getResource();
        return TemplateInfoDAO.get().findByFeatureTypeInfo((FeatureTypeInfo)resourceInfo);
    }

    void setTemplateRuleTablePanel(TemplateRulesTablePanel panel) {
        this.tablePanel = panel;
    }

    private void updateModelRules(TemplateRule rule) {
        ArrayList<TemplateRule> rules = new ArrayList<TemplateRule>((Collection)this.tablePanel.getModel().getObject());
        Collections.sort(rules, new TemplateRule.TemplateRuleComparator());
        rules.removeIf(r -> r.getRuleId().equals(rule.getRuleId()));
        this.tablePanel.getModel().setObject((Collection)TemplateRuleService.updatePriorities(rules, (TemplateRule)rule));
        this.tablePanel.modelChanged();
        this.tablePanel.getTable().modelChanged();
    }

    private void clearForm(AjaxRequestTarget target) {
        this.theForm.clearInput();
        this.theForm.setModelObject((Object)new TemplateRule());
        this.theForm.modelChanged();
        this.templateInfoDropDownChoice.modelChanged();
        this.mimeTypeDropDown.modelChanged();
        this.cqlFilterArea.modelChanged();
        this.profileField.modelChanged();
        this.submitLabelModel.setObject((Serializable)((Object)this.getSubmitLabelValue("add")));
        this.panelLabelModel.setObject((Serializable)((Object)this.getPanelLabelValue("add")));
        target.add(new Component[]{this.theForm});
        target.add(new Component[]{this.templateInfoDropDownChoice});
        target.add(new Component[]{this.mimeTypeDropDown});
        target.add(new Component[]{this.cqlFilterArea});
        target.add(new Component[]{this.profileField});
        target.add(new Component[]{this.submitLabel});
        target.add(new Component[]{this.panelLabel});
    }

    private void cleanFeedbackPanel() {
        this.ruleFeedbackPanel.getFeedbackMessages().clear();
    }

    String getPanelLabelValue(String labelType) {
        return this.getLabelValue("panel", labelType);
    }

    String getSubmitLabelValue(String labelType) {
        return this.getLabelValue("submit", labelType);
    }

    String getLabelValue(String label1, String label2) {
        return MessageFormat.format(this.getString("TemplateRuleConfigurationPanel." + label1), this.getString("TemplateRuleConfigurationPanel." + label2));
    }

    private IValidator<String> getCqlValidator() {
        return new IValidator<String>(){

            public void validate(IValidatable<String> iValidatable) {
                try {
                    String value = (String)iValidatable.getValue();
                    if (value != null && !"".equals(value)) {
                        XCQL.toFilter((String)((String)iValidatable.getValue()));
                    }
                }
                catch (CQLException e) {
                    ValidationError error = new ValidationError();
                    Object message = (String)new ParamResourceModel("invalidCQL", (Component)TemplateRuleConfigurationPanel.this, new Object[0]).getObject();
                    message = (String)message + " " + e.getMessage();
                    error.setMessage((String)message);
                    iValidatable.error((IValidationError)error);
                }
            }
        };
    }
}

