/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.web;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.Calendar;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.CookieStore;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.OnChangeAjaxBehavior;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.featurestemplating.configuration.SupportedFormat;
import org.geoserver.featurestemplating.configuration.TemplateIdentifier;
import org.geoserver.featurestemplating.configuration.TemplateInfo;
import org.geoserver.featurestemplating.configuration.TemplateLayerConfig;
import org.geoserver.featurestemplating.configuration.TemplateLoader;
import org.geoserver.featurestemplating.configuration.TemplateRule;
import org.geoserver.featurestemplating.web.OutputFormatsDropDown;
import org.geoserver.featurestemplating.web.TemplateConfigurationPage;
import org.geoserver.featurestemplating.web.TemplateModelsValidator;
import org.geoserver.featurestemplating.web.TemplateOutputValidator;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.exception.GeoServerException;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.wicket.CodeMirrorEditor;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

public class TemplatePreviewPanel
extends Panel {
    private CodeMirrorEditor previewEditor;
    private static final String PREVIEW_RULE_FILTER = "requestParam('gsPreviewTemplate') = 'true'";
    private static final String PREVIEW_REQUEST_PARAM = "gsPreviewTemplate";
    private Form<PreviewInfoModel> previewInfoForm;
    private DropDownChoice<FeatureTypeInfo> featureTypesDD;
    private OutputFormatsDropDown outputFormatsDropDown;
    private DropDownChoice<WorkspaceInfo> workspaceInfoDropDownChoice;
    private TextField<String> featureIdField;
    private TextField<String> cqlFilterField;
    private TemplateConfigurationPage page;
    private FeedbackPanel previewFeedback;
    private String previewResult;

    public TemplatePreviewPanel(String id, TemplateConfigurationPage page) {
        super(id);
        this.page = page;
        this.initUI();
    }

    private void initUI() {
        Model previewModel = new Model((Serializable)new PreviewInfoModel());
        this.previewInfoForm = new Form("previewForm", (IModel)previewModel);
        this.outputFormatsDropDown = new OutputFormatsDropDown("outputFormats", (IModel<SupportedFormat>)new PropertyModel((Object)previewModel, "outputFormat"), ((TemplateInfo)this.page.getForm().getModelObject()).getExtension());
        this.outputFormatsDropDown.add(new Behavior[]{new OnChangeAjaxBehavior(){

            protected void onUpdate(AjaxRequestTarget ajaxRequestTarget) {
                SupportedFormat outputFormat = (SupportedFormat)TemplatePreviewPanel.this.outputFormatsDropDown.getModelObject();
                if (SupportedFormat.GML.equals((Object)outputFormat) || SupportedFormat.HTML.equals((Object)outputFormat)) {
                    TemplatePreviewPanel.this.previewEditor.setMode("xml");
                } else {
                    TemplatePreviewPanel.this.previewEditor.setModeAndSubMode("javascript", "json");
                }
                if (TemplatePreviewPanel.this.previewFeedback.hasFeedbackMessage()) {
                    TemplatePreviewPanel.this.clearFeedbackMessages();
                    ajaxRequestTarget.add(new Component[]{TemplatePreviewPanel.this.previewFeedback});
                }
                ajaxRequestTarget.add(new Component[]{TemplatePreviewPanel.this.previewEditor});
            }
        }});
        this.previewInfoForm.add(new Component[]{this.outputFormatsDropDown});
        IModel<TemplateInfo> templateInfo = this.page.getTemplateInfoModel();
        boolean hasFeatureType = ((TemplateInfo)templateInfo.getObject()).getFeatureType() != null;
        boolean hasWorkspace = ((TemplateInfo)templateInfo.getObject()).getWorkspace() != null;
        List<WorkspaceInfo> workspaces = this.getWorkspaces(this.getCatalog());
        ChoiceRenderer wsRenderer = new ChoiceRenderer("name", "name");
        this.workspaceInfoDropDownChoice = new DropDownChoice("workspaces", (IModel)new PropertyModel((Object)previewModel, "ws"), workspaces, (IChoiceRenderer)wsRenderer);
        WorkspaceInfo wi = null;
        if (hasWorkspace) {
            wi = this.setWorkspaceValue(((TemplateInfo)templateInfo.getObject()).getWorkspace(), workspaces);
        }
        this.workspaceInfoDropDownChoice.add(new Behavior[]{new OnChangeAjaxBehavior(){

            protected void onUpdate(AjaxRequestTarget ajaxRequestTarget) {
                WorkspaceInfo wi = (WorkspaceInfo)TemplatePreviewPanel.this.workspaceInfoDropDownChoice.getModelObject();
                TemplatePreviewPanel.this.featureTypesDD.setChoices(TemplatePreviewPanel.this.getFeatureTypes(TemplatePreviewPanel.this.getCatalog(), wi));
                TemplatePreviewPanel.this.featureTypesDD.setEnabled(true);
                ajaxRequestTarget.add(new Component[]{TemplatePreviewPanel.this.featureTypesDD});
                if (TemplatePreviewPanel.this.previewFeedback.hasFeedbackMessage()) {
                    TemplatePreviewPanel.this.clearFeedbackMessages();
                    ajaxRequestTarget.add(new Component[]{TemplatePreviewPanel.this.previewFeedback});
                }
            }
        }});
        this.previewInfoForm.add(new Component[]{this.workspaceInfoDropDownChoice});
        List<Object> featureTypes = hasWorkspace ? this.getFeatureTypes(this.getCatalog(), wi) : Collections.emptyList();
        ChoiceRenderer ftiChoiceRenderer = new ChoiceRenderer("name", "name");
        this.featureTypesDD = new DropDownChoice("featureTypes", (IModel)new PropertyModel((Object)previewModel, "featureType"), featureTypes, (IChoiceRenderer)ftiChoiceRenderer);
        this.featureTypesDD.setOutputMarkupId(true);
        if (!hasWorkspace) {
            this.featureTypesDD.setEnabled(false);
        }
        if (hasFeatureType) {
            this.setFeatureTypeInfoValue(((TemplateInfo)templateInfo.getObject()).getFeatureType());
        }
        this.previewInfoForm.add(new Component[]{this.featureTypesDD});
        Component[] componentArray = new Component[1];
        this.previewEditor = new CodeMirrorEditor("previewArea", "xml", (IModel)new PropertyModel((Object)this, "previewResult"));
        componentArray[0] = this.previewEditor;
        this.previewInfoForm.add(componentArray);
        this.previewEditor.setOutputMarkupId(true);
        this.previewEditor.setTextAreaMarkupId("previewEditor");
        this.previewEditor.setMarkupId("previewArea");
        String extension = ((TemplateInfo)templateInfo.getObject()).getExtension();
        if (extension.equals("json")) {
            this.previewEditor.setModeAndSubMode("javascript", extension);
        }
        this.previewInfoForm.add(new Component[]{this.previewEditor});
        Component[] componentArray2 = new Component[1];
        this.previewFeedback = new FeedbackPanel("validateFeedback");
        componentArray2[0] = this.previewFeedback;
        this.previewInfoForm.add(componentArray2);
        this.previewFeedback.setOutputMarkupId(true);
        this.featureIdField = new TextField("featureId", (IModel)new PropertyModel((Object)previewModel, "featureId"));
        this.previewInfoForm.add(new Component[]{this.featureIdField});
        this.cqlFilterField = new TextField("cqlFilterField", (IModel)new PropertyModel((Object)previewModel, "cqlFilter"));
        this.previewInfoForm.add(new Component[]{this.cqlFilterField});
        this.previewInfoForm.add(new Component[]{this.getSubmit()});
        this.previewInfoForm.add(new Component[]{this.getValidate()});
        this.previewInfoForm.setMultiPart(true);
        this.add(new Component[]{this.previewInfoForm});
    }

    private List<WorkspaceInfo> getWorkspaces(Catalog catalog) {
        return catalog.getWorkspaces();
    }

    private List<FeatureTypeInfo> getFeatureTypes(Catalog catalog, WorkspaceInfo ws) {
        if (ws != null) {
            NamespaceInfo nsi = catalog.getNamespaceByPrefix(ws.getName());
            return catalog.getFeatureTypesByNamespace(nsi);
        }
        return Collections.emptyList();
    }

    private String buildWFSLink(PreviewInfoModel previewInfoModel) {
        boolean canBuildLink;
        SupportedFormat outputFormat = previewInfoModel.getOutputFormat();
        WorkspaceInfo ws = previewInfoModel.getWs();
        FeatureTypeInfo featureType = previewInfoModel.getFeatureType();
        boolean bl = canBuildLink = outputFormat != null && ws != null && featureType != null;
        if (canBuildLink) {
            TemplateLayerConfig layerConfig = (TemplateLayerConfig)featureType.getMetadata().get("FEATURES_TEMPLATING_LAYER_CONF", TemplateLayerConfig.class);
            TemplateRule rule = new TemplateRule();
            IModel<TemplateInfo> templateInfo = this.page.getTemplateInfoModel();
            rule.setTemplateIdentifier(((TemplateInfo)templateInfo.getObject()).getIdentifier());
            rule.setTemplateName(((TemplateInfo)templateInfo.getObject()).getFullName());
            rule.setOutputFormat(outputFormat);
            rule.setForceRule(true);
            rule.setCqlFilter(PREVIEW_RULE_FILTER);
            if (layerConfig == null) {
                layerConfig = new TemplateLayerConfig();
            }
            layerConfig.addTemplateRule(rule);
            featureType.getMetadata().put("FEATURES_TEMPLATING_LAYER_CONF", (Serializable)layerConfig);
            this.getCatalog().save((ResourceInfo)featureType);
            String mime = this.getOutputFormat(outputFormat);
            String typeName = ws.getName() + ":" + featureType.getName();
            return this.buildWfsLink(typeName, mime, previewInfoModel.getFeatureId(), previewInfoModel.getCqlFilter(), ws);
        }
        this.error((Serializable)((Object)"please fill all the field to preview the template response"));
        return null;
    }

    String buildWfsLink(String typeName, String outputFormat, String featureId, String cqlFilter, WorkspaceInfo ws) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("service", "WFS");
        params.put("version", "2.0.0");
        params.put("request", "GetFeature");
        params.put("typeNames", typeName);
        params.put("outputFormat", outputFormat);
        if (featureId != null) {
            params.put("featureID", featureId);
        }
        if (cqlFilter != null) {
            params.put("cql_filter", cqlFilter);
        } else {
            params.put("count", "1");
        }
        params.put(PREVIEW_REQUEST_PARAM, "true");
        return ResponseUtils.buildURL((String)this.getBaseURL(), (String)this.getPath("ows", false, ws), params, (URLMangler.URLType)URLMangler.URLType.SERVICE);
    }

    private String getBaseURL() {
        HttpServletRequest req = this.request();
        return ResponseUtils.baseURL((HttpServletRequest)req);
    }

    private HttpServletRequest request() {
        return GeoServerApplication.get().servletRequest();
    }

    String getPath(String service, boolean useGlobalRef, WorkspaceInfo wi) {
        String ws = wi.getName();
        if (ws == null || useGlobalRef) {
            return service;
        }
        return ws + "/" + service;
    }

    private String getOutputFormat(SupportedFormat outputFormatName) {
        String realOutputFormat = null;
        if (outputFormatName.equals((Object)SupportedFormat.GEOJSON)) {
            realOutputFormat = TemplateIdentifier.JSON.getOutputFormat();
        } else if (outputFormatName.equals((Object)SupportedFormat.JSONLD)) {
            realOutputFormat = TemplateIdentifier.JSONLD.getOutputFormat();
        } else if (outputFormatName.equals((Object)SupportedFormat.GML)) {
            realOutputFormat = "application/gml+xml; version=3.2";
        } else if (outputFormatName.equals((Object)SupportedFormat.HTML)) {
            realOutputFormat = TemplateIdentifier.HTML.getOutputFormat();
        }
        return realOutputFormat;
    }

    private void removeTemplatePreviewRule(FeatureTypeInfo featureType) {
        TemplateLayerConfig config = (TemplateLayerConfig)featureType.getMetadata().get("FEATURES_TEMPLATING_LAYER_CONF", TemplateLayerConfig.class);
        Set rules = config.getTemplateRules();
        rules.removeIf(r -> r.getCqlFilter() != null && r.getCqlFilter().equals(PREVIEW_RULE_FILTER));
        featureType.getMetadata().put("FEATURES_TEMPLATING_LAYER_CONF", (Serializable)config);
        this.getCatalog().save((ResourceInfo)featureType);
    }

    private AjaxSubmitLink getSubmit() {
        AjaxSubmitLink submitLink = new AjaxSubmitLink("preview", this.previewInfoForm){

            protected void onSubmit(AjaxRequestTarget target) {
                super.onSubmit(target);
                TemplatePreviewPanel.this.clearFeedbackMessages();
                target.add(new Component[]{TemplatePreviewPanel.this.previewFeedback});
                TemplatePreviewPanel.this.previewEditor.clearInput();
                IModel<TemplateInfo> templateInfo = TemplatePreviewPanel.this.page.getTemplateInfoModel();
                String rawTemplate = TemplatePreviewPanel.this.page.getStringTemplateFromInput();
                TemplatePreviewPanel.this.page.saveTemplateInfo((TemplateInfo)templateInfo.getObject(), rawTemplate);
                Form previewForm = this.getForm();
                if (!TemplatePreviewPanel.this.validateAndReport((PreviewInfoModel)previewForm.getModelObject())) {
                    return;
                }
                String url = TemplatePreviewPanel.this.buildWFSLink((PreviewInfoModel)previewForm.getModelObject());
                TemplatePreviewPanel.this.previewResult = TemplatePreviewPanel.this.performWfsRequest(url);
                TemplatePreviewPanel.this.previewEditor.setModelObject((Object)TemplatePreviewPanel.this.previewResult);
                TemplatePreviewPanel.this.previewEditor.modelChanged();
                target.add(new Component[]{TemplatePreviewPanel.this.previewEditor});
            }

            protected void onAfterSubmit(AjaxRequestTarget target) {
                FeatureTypeInfo featureTypeInfo = (FeatureTypeInfo)TemplatePreviewPanel.this.featureTypesDD.getModelObject();
                if (featureTypeInfo != null) {
                    TemplateInfo ti = (TemplateInfo)TemplatePreviewPanel.this.page.getTemplateInfoModel().getObject();
                    TemplateLoader.get().cleanCache(featureTypeInfo, ti.getIdentifier());
                    TemplatePreviewPanel.this.removeTemplatePreviewRule(featureTypeInfo);
                }
                if (TemplatePreviewPanel.this.previewEditor.hasFeedbackMessage()) {
                    target.add(new Component[]{TemplatePreviewPanel.this.previewFeedback});
                }
            }
        };
        return submitLink;
    }

    private boolean validateAndReport(PreviewInfoModel info) {
        try {
            TemplateModelsValidator validator = new TemplateModelsValidator();
            validator.validate(info);
        }
        catch (GeoServerException e) {
            this.previewEditor.error((Serializable)((Object)e.getMessage()));
            return false;
        }
        return true;
    }

    private AjaxSubmitLink getValidate() {
        AjaxSubmitLink submitLink = new AjaxSubmitLink("validate", this.previewInfoForm){

            protected void onSubmit(AjaxRequestTarget target) {
                super.onSubmit(target);
                if (TemplatePreviewPanel.this.previewResult != null) {
                    SupportedFormat outputFormat = (SupportedFormat)TemplatePreviewPanel.this.outputFormatsDropDown.getModelObject();
                    TemplateOutputValidator validator = new TemplateOutputValidator(outputFormat);
                    boolean result = validator.validate(TemplatePreviewPanel.this.previewResult);
                    String message = validator.getMessage();
                    if (!result) {
                        TemplatePreviewPanel.this.previewEditor.error((Serializable)((Object)message));
                    } else {
                        TemplatePreviewPanel.this.previewEditor.info((Serializable)((Object)message));
                    }
                }
            }

            protected void onAfterSubmit(AjaxRequestTarget target) {
                super.onAfterSubmit(target);
                if (TemplatePreviewPanel.this.previewEditor.hasFeedbackMessage()) {
                    target.add(new Component[]{TemplatePreviewPanel.this.previewFeedback});
                }
            }
        };
        return submitLink;
    }

    private Catalog getCatalog() {
        return (Catalog)GeoServerExtensions.bean((String)"catalog");
    }

    CloseableHttpClient buildHttpClient() {
        RequestConfig clientConfig = RequestConfig.custom().setConnectTimeout(60000).setSocketTimeout(60000).build();
        BasicCookieStore cookieStore = new BasicCookieStore();
        RequestAttributes attributes = RequestContextHolder.getRequestAttributes();
        if (attributes != null) {
            BasicClientCookie cookie = new BasicClientCookie("JSESSIONID", attributes.getSessionId());
            HttpServletRequest request = this.request();
            cookie.setPath(request.getContextPath());
            Calendar calendar = Calendar.getInstance();
            int maxInactive = request.getSession().getMaxInactiveInterval();
            calendar.add(13, maxInactive > 0 ? maxInactive : 30);
            cookie.setExpiryDate(calendar.getTime());
            cookie.setDomain(request.getServerName());
            cookieStore.addCookie((Cookie)cookie);
        }
        return HttpClientBuilder.create().setDefaultRequestConfig(clientConfig).setDefaultCookieStore((CookieStore)cookieStore).build();
    }

    private String performWfsRequest(String url) {
        String result = "";
        try (CloseableHttpClient client = this.buildHttpClient();){
            HttpGet get = new HttpGet(url);
            try (CloseableHttpResponse httpResponse = client.execute((HttpUriRequest)get);){
                HttpEntity entity = httpResponse.getEntity();
                result = IOUtils.toString((InputStream)entity.getContent(), (Charset)Charset.forName("UTF-8"));
            }
        }
        catch (Exception e) {
            result = e.getMessage();
        }
        SupportedFormat outputFormat = (SupportedFormat)this.outputFormatsDropDown.getModelObject();
        result = this.prettyPrintData(outputFormat, result);
        return result.trim();
    }

    WorkspaceInfo setWorkspaceValue(String workspaceValue) {
        List<WorkspaceInfo> workspaces = this.workspaceInfoDropDownChoice.getChoices();
        if (workspaces.isEmpty()) {
            workspaces = this.getWorkspaces(this.getCatalog());
        }
        return this.setWorkspaceValue(workspaceValue, workspaces);
    }

    WorkspaceInfo setWorkspaceValue(String workspaceValue, List<WorkspaceInfo> workspaces) {
        WorkspaceInfo result = null;
        if (this.workspaceInfoDropDownChoice != null && !workspaces.isEmpty()) {
            Optional<WorkspaceInfo> selectedWs = workspaces.stream().filter(ws -> ws.getName().equals(workspaceValue)).findFirst();
            if (selectedWs.isPresent()) {
                result = selectedWs.get();
                this.workspaceInfoDropDownChoice.setEnabled(false);
                this.workspaceInfoDropDownChoice.setDefaultModelObject((Object)result);
            }
        } else if (workspaces.isEmpty()) {
            this.workspaceInfoDropDownChoice.setDefaultModelObject(result);
        }
        return result;
    }

    void setFeatureTypeInfoValue(String featureTypeInfoValue) {
        List<FeatureTypeInfo> featureTypeInfos = this.featureTypesDD.getChoices();
        if (featureTypeInfos.isEmpty()) {
            featureTypeInfos = this.getFeatureTypes(this.getCatalog(), (WorkspaceInfo)this.workspaceInfoDropDownChoice.getModelObject());
        }
        this.setFeatureTypeInfoValue(featureTypeInfoValue, featureTypeInfos);
    }

    void setOutputFormatsDropDownValues(String extension) {
        if (this.outputFormatsDropDown != null) {
            this.outputFormatsDropDown.setChoices(SupportedFormat.getByExtension((String)extension));
        }
    }

    void setFeatureTypeInfoValue(String featureTypeInfoValue, List<FeatureTypeInfo> featureTypeInfos) {
        if (this.featureTypesDD != null && !featureTypeInfos.isEmpty()) {
            Optional<FeatureTypeInfo> op = featureTypeInfos.stream().filter(fti -> fti.getName().equals(featureTypeInfoValue)).findFirst();
            if (op.isPresent()) {
                this.featureTypesDD.setEnabled(false);
                this.featureTypesDD.setDefaultModelObject((Object)op.get());
            }
        } else if (featureTypeInfos.isEmpty()) {
            this.featureTypesDD.setDefaultModelObject(null);
        }
    }

    private String prettyPrintXML(String input) {
        StreamSource xmlInput = new StreamSource(new StringReader(input));
        StringWriter stringWriter = new StringWriter();
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("doctype-public", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(xmlInput, new StreamResult(stringWriter));
            return stringWriter.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String prettyPrintJson(String input) {
        try {
            ObjectMapper objectMapper = new ObjectMapper(new JsonFactory());
            Object json = objectMapper.readValue(input, Object.class);
            objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
            return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(json);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private String prettyPrintData(SupportedFormat outputFormat, String data) {
        String exceptionPrefix = "<ows:";
        String prettyPrint = outputFormat.equals((Object)SupportedFormat.GML) || data.contains(exceptionPrefix) || outputFormat.equals((Object)SupportedFormat.HTML) ? this.prettyPrintXML(data) : this.prettyPrintJson(data);
        return prettyPrint;
    }

    private void clearFeedbackMessages() {
        this.previewFeedback.getFeedbackMessages().clear();
    }

    public static class PreviewInfoModel
    implements Serializable {
        private WorkspaceInfo ws;
        private FeatureTypeInfo featureType;
        private SupportedFormat outputFormat;
        private String featureId;
        private String cqlFilter;

        public WorkspaceInfo getWs() {
            return this.ws;
        }

        public void setWs(WorkspaceInfo ws) {
            this.ws = ws;
        }

        public FeatureTypeInfo getFeatureType() {
            return this.featureType;
        }

        public void setFeatureType(FeatureTypeInfo fti) {
            this.featureType = fti;
        }

        public SupportedFormat getOutputFormat() {
            return this.outputFormat;
        }

        public void setOutputFormat(SupportedFormat outputFormat) {
            this.outputFormat = outputFormat;
        }

        public String getFeatureId() {
            return this.featureId;
        }

        public void setFeatureId(String featureId) {
            this.featureId = featureId;
        }

        public String getCqlFilter() {
            return this.cqlFilter;
        }

        public void setCqlFilter(String cqlFilter) {
            this.cqlFilter = cqlFilter;
        }
    }
}

