/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.web;

import com.github.jsonldjava.utils.JsonUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.geoserver.featurestemplating.configuration.SupportedFormat;
import org.geoserver.featurestemplating.validation.JSONLDContextValidation;
import org.geotools.wfs.v2_0.WFSConfiguration;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Parser;

public class TemplateOutputValidator {
    private SupportedFormat outputFormat;
    private String message;

    public TemplateOutputValidator(SupportedFormat outputFormat) {
        this.outputFormat = outputFormat;
    }

    public boolean validate(String input) {
        boolean result = true;
        if (this.outputFormat.equals((Object)SupportedFormat.JSONLD)) {
            result = this.validateJSONLD(input);
        } else if (this.outputFormat.equals((Object)SupportedFormat.GML)) {
            result = this.validateGML(input);
        } else if (this.outputFormat.equals((Object)SupportedFormat.GEOJSON) || this.outputFormat.equals((Object)SupportedFormat.HTML)) {
            result = this.validateGeoJSON(input);
        }
        if (result) {
            this.message = "Result is valid";
        }
        return result;
    }

    private boolean validateJSONLD(String input) {
        boolean result = true;
        try {
            Object json = JsonUtils.fromString((String)input);
            JSONLDContextValidation contextValidation = new JSONLDContextValidation();
            contextValidation.validate(json);
        }
        catch (Exception e) {
            this.message = e.getMessage();
            result = false;
        }
        return result;
    }

    private boolean validateGML(String input) {
        boolean result = true;
        WFSConfiguration configuration = new WFSConfiguration();
        ArrayList<String> validationErrors = new ArrayList<String>();
        try (ByteArrayInputStream is = new ByteArrayInputStream(input.getBytes());){
            Parser parser = new Parser((Configuration)configuration);
            parser.setValidating(true);
            parser.parse((InputStream)is);
            validationErrors.addAll(parser.getValidationErrors().stream().map(e -> e.getMessage()).collect(Collectors.toList()));
        }
        catch (Exception e2) {
            validationErrors.add(e2.getMessage());
            result = false;
        }
        if (!validationErrors.isEmpty()) {
            result = false;
            StringBuilder builder = new StringBuilder("The following errors occured while validating the gml output: ");
            for (int i = 0; i < validationErrors.size(); ++i) {
                String error = (String)validationErrors.get(i);
                builder.append(i + 1).append(" ").append(error).append("");
            }
            this.message = builder.toString();
        }
        return result;
    }

    private boolean validateGeoJSON(String input) {
        return true;
    }

    public String getMessage() {
        return this.message;
    }
}

