/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.web;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.extensions.ajax.markup.html.tabs.AjaxTabbedPanel;
import org.apache.wicket.extensions.markup.html.tabs.AbstractTab;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.extensions.markup.html.tabs.PanelCachingTab;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.geoserver.featurestemplating.configuration.TemplateFileManager;
import org.geoserver.featurestemplating.configuration.TemplateInfo;
import org.geoserver.featurestemplating.configuration.TemplateService;
import org.geoserver.featurestemplating.web.TemplateInfoDataPanel;
import org.geoserver.featurestemplating.web.TemplateInfoPage;
import org.geoserver.featurestemplating.web.TemplateModelsValidator;
import org.geoserver.featurestemplating.web.TemplatePreviewPanel;
import org.geoserver.platform.exception.GeoServerException;
import org.geoserver.platform.resource.Resource;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.wicket.CodeMirrorEditor;

public class TemplateConfigurationPage
extends GeoServerSecuredPage {
    protected AjaxTabbedPanel<ITab> tabbedPanel;
    private boolean isNew;
    CodeMirrorEditor editor;
    private Form<TemplateInfo> form;
    private TemplatePreviewPanel previewPanel;
    private TemplateInfoDataPanel dataPanel;
    String rawTemplate;

    public TemplateConfigurationPage(IModel<TemplateInfo> model, boolean isNew) {
        this.isNew = isNew;
        this.initUI(model);
    }

    private void initUI(IModel<TemplateInfo> model) {
        this.form = new Form("theForm", model);
        ArrayList<ITab> tabs = new ArrayList<ITab>();
        PanelCachingTab previewTab = new PanelCachingTab((ITab)new AbstractTab((IModel)new Model((Serializable)((Object)"Preview"))){

            public Panel getPanel(String id) {
                TemplateConfigurationPage.this.previewPanel = new TemplatePreviewPanel(id, TemplateConfigurationPage.this);
                return TemplateConfigurationPage.this.previewPanel;
            }
        });
        PanelCachingTab dataTab = new PanelCachingTab((ITab)new AbstractTab((IModel)new Model((Serializable)((Object)"Data"))){

            public Panel getPanel(String id) {
                TemplateConfigurationPage.this.dataPanel = new TemplateInfoDataPanel(id, TemplateConfigurationPage.this){

                    @Override
                    protected TemplatePreviewPanel getPreviewPanel() {
                        return TemplateConfigurationPage.this.previewPanel;
                    }
                };
                return TemplateConfigurationPage.this.dataPanel;
            }
        });
        tabs.add((ITab)dataTab);
        tabs.add((ITab)previewTab);
        this.tabbedPanel = this.newTabbedPanel(tabs);
        this.tabbedPanel.setMarkupId("template-info-tabbed-panel");
        this.tabbedPanel.setOutputMarkupId(true);
        this.form.add(new Component[]{this.tabbedPanel});
        this.rawTemplate = this.getStringTemplate((TemplateInfo)model.getObject());
        String mode = !this.isNew && ((TemplateInfo)model.getObject()).getExtension().equals("json") ? "javascript" : "xml";
        this.editor = new CodeMirrorEditor("templateEditor", mode, (IModel)new PropertyModel((Object)this, "rawTemplate")){

            public boolean isRequired() {
                boolean result = false;
                IFormSubmittingComponent submitter = TemplateConfigurationPage.this.form.getRootForm().findSubmitter();
                if (submitter != null) {
                    result = !submitter.equals(TemplateConfigurationPage.this.dataPanel.getUploadLink());
                }
                return result;
            }
        };
        this.form.add(new Component[]{this.editor});
        if (mode.equals("javascript")) {
            this.editor.setModeAndSubMode(mode, ((TemplateInfo)model.getObject()).getExtension());
        }
        this.editor.setMarkupId("templateEditor");
        this.editor.setTextAreaMarkupId("editor");
        this.editor.setOutputMarkupId(true);
        this.form.setMultiPart(true);
        this.form.add(new Component[]{this.editor});
        this.form.add(new Component[]{this.getSubmit()});
        this.form.add(new Component[]{new Link<TemplateInfoPage>("cancel"){

            public void onClick() {
                TemplateConfigurationPage.this.doReturn(TemplateInfoPage.class);
            }
        }});
        this.add(new Component[]{this.form});
    }

    private String getStringTemplate(TemplateInfo templateInfo) {
        String rawTemplate = "";
        if (!this.isNew) {
            Resource resource = TemplateFileManager.get().getTemplateResource(templateInfo);
            try {
                rawTemplate = FileUtils.readFileToString((File)resource.file(), (Charset)Charset.forName("UTF-8"));
            }
            catch (IOException io) {
                throw new RuntimeException(io);
            }
        }
        return rawTemplate;
    }

    public String getStringTemplateFromInput() {
        String rawTemplate = this.getEditor().getInput();
        if (rawTemplate == null || rawTemplate.trim().equals("")) {
            rawTemplate = (String)this.getEditor().getModelObject();
        }
        return rawTemplate;
    }

    public void setRawTemplate(Reader in) throws IOException {
        try (BufferedReader bin = in instanceof BufferedReader ? (BufferedReader)in : new BufferedReader(in);){
            StringBuilder builder = new StringBuilder();
            String line = null;
            while ((line = bin.readLine()) != null) {
                builder.append(line).append("\n");
            }
            this.rawTemplate = builder.toString();
            this.editor.setModelObject((Object)this.rawTemplate);
        }
    }

    private AjaxSubmitLink getSubmit() {
        AjaxSubmitLink submitLink = new AjaxSubmitLink("save", this.form){

            protected void onSubmit(AjaxRequestTarget target) {
                super.onSubmit(target);
                TemplateConfigurationPage.this.clearFeedbackMessages();
                TemplateInfo templateInfo = (TemplateInfo)TemplateConfigurationPage.this.form.getModelObject();
                target.add(new Component[]{TemplateConfigurationPage.this.topFeedbackPanel});
                target.add(new Component[]{TemplateConfigurationPage.this.bottomFeedbackPanel});
                target.add(new Component[]{TemplateConfigurationPage.this.editor});
                if (!TemplateConfigurationPage.this.validateAndReport(templateInfo)) {
                    return;
                }
                String rawTemplate = TemplateConfigurationPage.this.rawTemplate;
                TemplateConfigurationPage.this.saveTemplateInfo(templateInfo, rawTemplate);
            }

            protected void onAfterSubmit(AjaxRequestTarget target) {
                super.onAfterSubmit(target);
                TemplateConfigurationPage.this.doReturn(TemplateInfoPage.class);
            }

            protected void onError(AjaxRequestTarget target) {
                super.onError(target);
                TemplateConfigurationPage.this.addFeedbackPanels(target);
            }

            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                super.updateAjaxAttributes(attributes);
                attributes.getAjaxCallListeners().add(TemplateConfigurationPage.this.editor.getSaveDecorator());
            }
        };
        return submitLink;
    }

    public void setRawTemplate(String rawTemplate) {
        this.rawTemplate = rawTemplate;
    }

    public String getRawTemplate() {
        return this.rawTemplate;
    }

    Form<TemplateInfo> getForm() {
        return this.form;
    }

    public IModel<TemplateInfo> getTemplateInfoModel() {
        return this.form.getModel();
    }

    void saveTemplateInfo(TemplateInfo templateInfo, String rawTemplate) {
        new TemplateService().saveOrUpdate(templateInfo, rawTemplate);
    }

    public CodeMirrorEditor getEditor() {
        return this.editor;
    }

    private void clearFeedbackMessages() {
        this.topFeedbackPanel.getFeedbackMessages().clear();
        this.bottomFeedbackPanel.getFeedbackMessages().clear();
    }

    private boolean validateAndReport(TemplateInfo info) {
        try {
            TemplateModelsValidator validator = new TemplateModelsValidator();
            validator.validate(info);
        }
        catch (GeoServerException e) {
            this.getForm().error((Serializable)((Object)e.getMessage()));
            return false;
        }
        return true;
    }

    private AjaxTabbedPanel<ITab> newTabbedPanel(List<ITab> tabs) {
        return new AjaxTabbedPanel<ITab>("tabbedPanel", tabs){

            protected String getTabContainerCssClass() {
                return "tab-row tab-row-compact";
            }

            protected WebMarkupContainer newLink(String linkId, final int index) {
                AjaxSubmitLink link = new AjaxSubmitLink(linkId){
                    private static final long serialVersionUID = 4599409150448651749L;

                    public void onSubmit(AjaxRequestTarget target) {
                        TemplateInfo templateInfo = (TemplateInfo)TemplateConfigurationPage.this.form.getModelObject();
                        if (!TemplateConfigurationPage.this.validateAndReport(templateInfo)) {
                            return;
                        }
                        String rawTemplate = TemplateConfigurationPage.this.getStringTemplateFromInput();
                        TemplateConfigurationPage.this.saveTemplateInfo(templateInfo, rawTemplate);
                        this.setSelectedTab(index);
                        target.add(new Component[]{TemplateConfigurationPage.this.tabbedPanel});
                    }

                    protected void onError(AjaxRequestTarget target) {
                        TemplateConfigurationPage.this.addFeedbackPanels(target);
                    }
                };
                return link;
            }
        };
    }
}

