/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.web;

import java.io.Serializable;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.client.CookieStore;
import org.apache.http.cookie.Cookie;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.protocol.http.mock.MockHttpServletRequest;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.featurestemplating.builders.impl.CompositeBuilder;
import org.geoserver.featurestemplating.builders.impl.IteratingBuilder;
import org.geoserver.featurestemplating.builders.impl.RootBuilder;
import org.geoserver.featurestemplating.configuration.SupportedFormat;
import org.geoserver.featurestemplating.configuration.TemplateFileManager;
import org.geoserver.featurestemplating.configuration.TemplateIdentifier;
import org.geoserver.featurestemplating.configuration.TemplateInfo;
import org.geoserver.featurestemplating.configuration.TemplateInfoDAO;
import org.geoserver.featurestemplating.configuration.TemplateLoader;
import org.geoserver.featurestemplating.configuration.TemplateRule;
import org.geoserver.featurestemplating.configuration.TemplateRuleService;
import org.geoserver.featurestemplating.configuration.TemplateService;
import org.geoserver.featurestemplating.web.OutputFormatsDropDown;
import org.geoserver.featurestemplating.web.TemplateConfigurationPage;
import org.geoserver.featurestemplating.web.TemplateInfoPage;
import org.geoserver.featurestemplating.web.TemplatePreviewPanel;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.wicket.CodeMirrorEditor;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class TemplateConfigurationPageTest
extends GeoServerWicketTestSupport {
    private static final String JSON_TEMPLATE = "{  \"@context\": {    \"gsp\": \"http://www.opengis.net/ont/geosparql#\",    \"sf\": \"http://www.opengis.net/ont/sf#\",    \"schema\": \"https://schema.org/\",    \"dc\": \"http://purl.org/dc/terms/\",    \"Feature\": \"gsp:Feature\",    \"FeatureCollection\": \"schema:Collection\",    \"Point\": \"sf:Point\",    \"wkt\": \"gsp:asWKT\",    \"features\": {      \"@container\": \"@set\",      \"@id\": \"schema:hasPart\"    },    \"geometry\": \"sf:geometry\",    \"description\": \"dc:description\",    \"title\": \"dc:title\",    \"name\": \"schema:name\"  },  \"type\": \"FeatureCollection\",  \"features\": [    {      \"$source\": \"cite:NamedPlaces\"    },    {      \"id\": \"${cite:FID}\",      \"@type\": [        \"Feature\",        \"cite:NamedPlaces\",        \"http://vocabulary.odm2.org/samplingfeaturetype/namedplaces\"      ],      \"name\": \"${cite:NAME}\",      \"geometry\": {        \"@type\": \"MultiPolygon\",        \"wkt\": \"$${toWKT(xpath('cite:the_geom'))}\"      }    }  ]}";
    private static final String GML_TEMPLATE = "<gft:Template>\n<gft:Options>\n  <gft:Namespaces xmlns:topp=\"http://www.openplans.org/topp\"/>\n  <gft:SchemaLocation xsi:schemaLocation=\"http://www.opengis.net/wfs/2.0 http://brgm-dev.geo-solutions.it/geoserver/schemas/wfs/2.0/wfs.xsd http://www.opengis.net/gml/3.2 http://schemas.opengis.net/gml/3.2.1/gml.xsd\"/>\n</gft:Options>\n  <topp:states gml:id=\"${@id}\">\n  \t<topp:name code=\"${STATE_ABBR}\">${STATE_NAME}</topp:name>\n  \t<topp:region>${SUB_REGION}</topp:region>\n    <topp:population>${PERSONS}</topp:population>\n    <topp:males>${MALE}</topp:males>\n  \t<topp:females>${FEMALE}</topp:females>\n  \t<topp:active_population>${WORKERS}</topp:active_population>\n  \t<topp:wkt_geom>$${toWKT(the_geom)}</topp:wkt_geom>\n  </topp:states>\n</gft:Template>";
    private static final String HTML_TEMPLATE = "<gft:Template>\n  <gft:Options>\n    <style>\n      <![CDATA[\nul, #myUL {\n  list-style-type: none;\n}\n\n#myUL {\n  margin: 0;\n  padding: 0;\n}\n\n.caret {\n  cursor: pointer;\n  -webkit-user-select: none; /* Safari 3.1+ */\n  -moz-user-select: none; /* Firefox 2+ */\n  -ms-user-select: none; /* IE 10+ */\n  user-select: none;\n}\n\n.caret::before {\n  content: \"\\25B6\";\n  color: black;\n  display: inline-block;\n  margin-right: 6px;\n}\n\n.caret-down::before {\n  -ms-transform: rotate(90deg); /* IE 9 */\n  -webkit-transform: rotate(90deg); /* Safari */'\n  transform: rotate(90deg);  \n}\n\n.nested {\n  display: none;\n}\n\n.active {\n  display: block;\n}\n]]>\n    </style>\n    <script>\n      <![CDATA[\n  window.onload = function() {\n  var toggler = document.getElementsByClassName(\"caret\");\n  for (let item of toggler){\n    item.addEventListener(\"click\", function() {\n    this.parentElement.querySelector(\".nested\").classList.toggle(\"active\");\n    this.classList.toggle(\"caret-down\");\n  });\n  }\n  }\n]]>\n    </script>\n  </gft:Options>\n  <ul id=\"myUL\">\n    <li><span class=\"caret\">MeteoStations</span>\n      <ul class=\"nested\">\n        <li><span class=\"caret\">Code</span>\n          <ul class=\"nested\">\n            <li>\n              $${strConcat('Station_',st:code)}\n            </li>\n          </ul>\n        </li>\n        <li><span class=\"caret\">Name</span>\n          <ul class=\"nested\">\n            <li>\n              ${st:common_name}\n            </li>\n          </ul>\n        </li>\n        <li><span class=\"caret\">Geometry</span>\n          <ul class=\"nested\">\n            <li>\n              ${st:position}\n            </li>\n          </ul>\n        </li>\n        <li gft:isCollection=\"true\" gft:source=\"st:meteoObservations/st:MeteoObservationsFeature\" gft:filter=\"xpath('st:meteoParameters/st:MeteoParametersFeature/st:param_name') = 'temperature'\">\n          <span class=\"caret\">Temperature</span>\n          <ul class=\"nested\">\n            <li><span class=\"caret\">Time</span>\n              <ul class=\"nested\">\n                <li>\n                  ${st:time}\n                </li>\n              </ul>\n            </li>\n            <li><span class=\"caret\">Value</span>\n              <ul class=\"nested\">\n                <li>\n                  ${st:time}\n                </li>\n              </ul>\n            </li>\n          </ul>\n        </li>\n        <li gft:isCollection=\"true\" gft:source=\"st:meteoObservations/st:MeteoObservationsFeature\" gft:filter=\"xpath('st:meteoParameters/st:MeteoParametersFeature/st:param_name') = 'pressure'\">\n          <span class=\"caret\">Pressure</span>\n          <ul class=\"nested\">\n            <li><span class=\"caret\">Time</span>\n              <ul class=\"nested\">\n                <li>\n                  ${st:time}\n                </li>\n              </ul>\n            </li>\n            <li><span class=\"caret\">Value</span>\n              <ul class=\"nested\">\n                <li>\n                  ${st:time}\n                </li>\n              </ul>\n            </li>\n          </ul>\n        </li>\n        <li gft:isCollection=\"true\" gft:source=\"st:meteoObservations/st:MeteoObservationsFeature\" gft:filter=\"xpath('st:meteoParameters/st:MeteoParametersFeature/st:param_name') = 'wind speed'\">\n          <span class=\"caret\">Wind Speed</span>\n          <ul class=\"nested\">\n            <li><span class=\"caret\">Time</span>\n              <ul class=\"nested\">\n                <li>\n                  ${st:time}\n                </li>\n              </ul>\n            </li>\n            <li><span class=\"caret\">Value</span>\n              <ul class=\"nested\">\n                <li>\n                  ${st:time}\n                </li>\n              </ul>\n            </li>\n          </ul>\n        </li>\n      </ul>\n    </li>\n  </ul>\n</gft:Template>";
    private static final String GML_STATIC_TEMPLATE = "<gft:Template>\n<gft:Options>\n  <gft:Namespaces xmlns:topp=\"http://www.openplans.org/topp\"/>\n  <gft:SchemaLocation xsi:schemaLocation=\"http://www.opengis.net/wfs/2.0 http://brgm-dev.geo-solutions.it/geoserver/schemas/wfs/2.0/wfs.xsd http://www.opengis.net/gml/3.2 http://schemas.opengis.net/gml/3.2.1/gml.xsd\"/>\n</gft:Options>\n  <theFeature gml:id=\"idVal\">\n  \t<name>name</name>\n  </theFeature>\n</gft:Template>";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNew() {
        try {
            this.login();
            tester.startPage((Page)new TemplateConfigurationPage((IModel)new Model((Serializable)new TemplateInfo()), true));
            FormTester form = tester.newFormTester("theForm");
            form.select("tabbedPanel:panel:extension", 2);
            tester.executeAjaxEvent("theForm:tabbedPanel:panel:extension", "change");
            form.select("tabbedPanel:panel:workspace", 2);
            tester.executeAjaxEvent("theForm:tabbedPanel:panel:workspace", "change");
            form.select("tabbedPanel:panel:featureTypeInfo", 8);
            tester.executeAjaxEvent("theForm:tabbedPanel:panel:featureTypeInfo", "change");
            form.setValue("templateEditor:editorContainer:editorParent:editor", JSON_TEMPLATE);
            form.setValue("tabbedPanel:panel:templateName", "testJsonLDTemplate");
            tester.clickLink("theForm:tabbedPanel:tabs-container:tabs:1:link");
            FormTester form2 = tester.newFormTester("theForm:tabbedPanel:panel:previewForm");
            form2.select("outputFormats", 0);
            OutputFormatsDropDown outputFormatsDropDown = (OutputFormatsDropDown)tester.getComponentFromLastRenderedPage("theForm:tabbedPanel:panel:previewForm:outputFormats");
            Assert.assertEquals((long)2L, (long)outputFormatsDropDown.getChoices().size());
            tester.assertComponent("theForm:tabbedPanel:panel:previewForm:workspaces", DropDownChoice.class);
            DropDownChoice ws = (DropDownChoice)tester.getComponentFromLastRenderedPage("theForm:tabbedPanel:panel:previewForm:workspaces");
            Assert.assertFalse((boolean)ws.isEnabled());
            tester.assertComponent("theForm:tabbedPanel:panel:previewForm:featureTypes", DropDownChoice.class);
            DropDownChoice ft = (DropDownChoice)tester.getComponentFromLastRenderedPage("theForm:tabbedPanel:panel:previewForm:featureTypes");
            Assert.assertFalse((boolean)ft.isEnabled());
            tester.assertComponent("theForm:tabbedPanel:panel:previewForm:previewArea", CodeMirrorEditor.class);
            tester.assertComponent("theForm:tabbedPanel:panel:previewForm:preview", AjaxSubmitLink.class);
            tester.assertComponent("theForm:tabbedPanel:panel:previewForm:validate", AjaxSubmitLink.class);
            form.submit("save");
            tester.assertNoErrorMessage();
            tester.assertRenderedPage(TemplateInfoPage.class);
        }
        finally {
            TemplateInfoDAO.get().deleteAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNew2() {
        try {
            this.login();
            tester.startPage((Page)new TemplateConfigurationPage((IModel)new Model((Serializable)new TemplateInfo()), true));
            FormTester form = tester.newFormTester("theForm");
            form.select("tabbedPanel:panel:extension", 0);
            tester.executeAjaxEvent("theForm:tabbedPanel:panel:extension", "change");
            form.setValue("templateEditor:editorContainer:editorParent:editor", GML_TEMPLATE);
            form.setValue("tabbedPanel:panel:templateName", "testGMLTemplate");
            tester.clickLink("theForm:tabbedPanel:tabs-container:tabs:1:link");
            FormTester form2 = tester.newFormTester("theForm:tabbedPanel:panel:previewForm");
            form2.select("outputFormats", 0);
            OutputFormatsDropDown outputFormatsDropDown = (OutputFormatsDropDown)tester.getComponentFromLastRenderedPage("theForm:tabbedPanel:panel:previewForm:outputFormats");
            Assert.assertEquals((long)1L, (long)outputFormatsDropDown.getChoices().size());
            tester.assertComponent("theForm:tabbedPanel:panel:previewForm:workspaces", DropDownChoice.class);
            form2.select("workspaces", 2);
            tester.executeAjaxEvent("theForm:tabbedPanel:panel:previewForm:workspaces", "change");
            tester.assertComponent("theForm:tabbedPanel:panel:previewForm:featureTypes", DropDownChoice.class);
            form2.select("featureTypes", 0);
            tester.assertComponent("theForm:tabbedPanel:panel:previewForm:previewArea", CodeMirrorEditor.class);
            tester.assertComponent("theForm:tabbedPanel:panel:previewForm:preview", AjaxSubmitLink.class);
            tester.assertComponent("theForm:tabbedPanel:panel:previewForm:validate", AjaxSubmitLink.class);
            form.submit("save");
            tester.assertNoErrorMessage();
            tester.assertRenderedPage(TemplateInfoPage.class);
        }
        finally {
            TemplateInfoDAO.get().deleteAll();
        }
    }

    @Test
    public void testEdit() {
        TemplateInfo info = new TemplateInfo();
        info.setWorkspace("cite");
        info.setFeatureType("NamedPlaces");
        info.setTemplateName("testJsonLDTemplate");
        info.setExtension("json");
        info = TemplateInfoDAO.get().saveOrUpdate(info);
        TemplateFileManager.get().saveTemplateFile(info, JSON_TEMPLATE);
        try {
            this.login();
            tester.startPage((Page)new TemplateConfigurationPage((IModel)new Model((Serializable)info), false));
            tester.assertModelValue("theForm:tabbedPanel:panel:templateName", (Object)"testJsonLDTemplate");
            tester.assertModelValue("theForm:tabbedPanel:panel:extension", (Object)"json");
            tester.assertModelValue("theForm:tabbedPanel:panel:workspace", (Object)"cite");
            tester.clickLink("theForm:tabbedPanel:tabs-container:tabs:1:link");
            FormTester form2 = tester.newFormTester("theForm:tabbedPanel:panel:previewForm");
            form2.select("outputFormats", 0);
            tester.assertComponent("theForm:tabbedPanel:panel:previewForm:workspaces", DropDownChoice.class);
            tester.assertComponent("theForm:tabbedPanel:panel:previewForm:featureTypes", DropDownChoice.class);
            tester.assertComponent("theForm:tabbedPanel:panel:previewForm:previewArea", CodeMirrorEditor.class);
            tester.assertComponent("theForm:tabbedPanel:panel:previewForm:preview", AjaxSubmitLink.class);
            tester.assertComponent("theForm:tabbedPanel:panel:previewForm:validate", AjaxSubmitLink.class);
            tester.newFormTester("theForm").submit("save");
            tester.assertNoErrorMessage();
            tester.assertRenderedPage(TemplateInfoPage.class);
        }
        finally {
            TemplateInfoDAO.get().deleteAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEdit2() {
        TemplateInfo info = new TemplateInfo();
        info.setWorkspace("cite");
        info.setTemplateName("testGMLTemplate");
        info.setExtension("xml");
        info = TemplateInfoDAO.get().saveOrUpdate(info);
        TemplateFileManager.get().saveTemplateFile(info, GML_TEMPLATE);
        try {
            this.login();
            tester.startPage((Page)new TemplateConfigurationPage((IModel)new Model((Serializable)info), false));
            tester.assertModelValue("theForm:tabbedPanel:panel:templateName", (Object)"testGMLTemplate");
            tester.assertModelValue("theForm:tabbedPanel:panel:extension", (Object)"xml");
            tester.assertModelValue("theForm:tabbedPanel:panel:workspace", (Object)"cite");
            tester.assertModelValue("theForm:tabbedPanel:panel:featureTypeInfo", null);
            tester.clickLink("theForm:tabbedPanel:tabs-container:tabs:1:link");
            FormTester form2 = tester.newFormTester("theForm:tabbedPanel:panel:previewForm");
            form2.select("outputFormats", 0);
            tester.assertComponent("theForm:tabbedPanel:panel:previewForm:workspaces", DropDownChoice.class);
            tester.assertComponent("theForm:tabbedPanel:panel:previewForm:featureTypes", DropDownChoice.class);
            tester.assertComponent("theForm:tabbedPanel:panel:previewForm:previewArea", CodeMirrorEditor.class);
            tester.assertComponent("theForm:tabbedPanel:panel:previewForm:preview", AjaxSubmitLink.class);
            tester.assertComponent("theForm:tabbedPanel:panel:previewForm:validate", AjaxSubmitLink.class);
            DropDownChoice ws = (DropDownChoice)tester.getComponentFromLastRenderedPage("theForm:tabbedPanel:panel:previewForm:workspaces");
            Assert.assertFalse((boolean)ws.isEnabled());
            DropDownChoice ft = (DropDownChoice)tester.getComponentFromLastRenderedPage("theForm:tabbedPanel:panel:previewForm:featureTypes");
            Assert.assertTrue((boolean)ft.isEnabled());
            form2.select("featureTypes", 0);
            tester.newFormTester("theForm").submit("save");
            tester.assertNoErrorMessage();
            tester.assertRenderedPage(TemplateInfoPage.class);
        }
        finally {
            TemplateInfoDAO.get().deleteAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHTMLTemplate() {
        try {
            this.login();
            tester.startPage((Page)new TemplateConfigurationPage((IModel)new Model((Serializable)new TemplateInfo()), true));
            FormTester form = tester.newFormTester("theForm");
            form.select("tabbedPanel:panel:extension", 1);
            tester.executeAjaxEvent("theForm:tabbedPanel:panel:extension", "change");
            form.select("tabbedPanel:panel:workspace", 2);
            tester.executeAjaxEvent("theForm:tabbedPanel:panel:workspace", "change");
            form.select("tabbedPanel:panel:featureTypeInfo", 8);
            tester.executeAjaxEvent("theForm:tabbedPanel:panel:featureTypeInfo", "change");
            form.setValue("templateEditor:editorContainer:editorParent:editor", HTML_TEMPLATE);
            form.setValue("tabbedPanel:panel:templateName", "testJsonLDTemplate");
            tester.clickLink("theForm:tabbedPanel:tabs-container:tabs:1:link");
            FormTester form2 = tester.newFormTester("theForm:tabbedPanel:panel:previewForm");
            form2.select("outputFormats", 0);
            OutputFormatsDropDown outputFormatsDropDown = (OutputFormatsDropDown)tester.getComponentFromLastRenderedPage("theForm:tabbedPanel:panel:previewForm:outputFormats");
            Assert.assertEquals((long)1L, (long)outputFormatsDropDown.getChoices().size());
            Assert.assertEquals((Object)SupportedFormat.HTML, outputFormatsDropDown.getChoices().get(0));
            tester.assertComponent("theForm:tabbedPanel:panel:previewForm:workspaces", DropDownChoice.class);
            DropDownChoice ws = (DropDownChoice)tester.getComponentFromLastRenderedPage("theForm:tabbedPanel:panel:previewForm:workspaces");
            Assert.assertFalse((boolean)ws.isEnabled());
            tester.assertComponent("theForm:tabbedPanel:panel:previewForm:featureTypes", DropDownChoice.class);
            DropDownChoice ft = (DropDownChoice)tester.getComponentFromLastRenderedPage("theForm:tabbedPanel:panel:previewForm:featureTypes");
            Assert.assertFalse((boolean)ft.isEnabled());
            tester.assertComponent("theForm:tabbedPanel:panel:previewForm:previewArea", CodeMirrorEditor.class);
            tester.assertComponent("theForm:tabbedPanel:panel:previewForm:preview", AjaxSubmitLink.class);
            tester.assertComponent("theForm:tabbedPanel:panel:previewForm:validate", AjaxSubmitLink.class);
            form.submit("save");
            tester.assertNoErrorMessage();
            tester.assertRenderedPage(TemplateInfoPage.class);
        }
        finally {
            TemplateInfoDAO.get().deleteAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPreviewRequestCanSendJsessionId() {
        TemplateInfo info = new TemplateInfo();
        info.setWorkspace("cite");
        info.setTemplateName("testGMLTemplate");
        info.setExtension("xml");
        info = TemplateInfoDAO.get().saveOrUpdate(info);
        TemplateFileManager.get().saveTemplateFile(info, GML_STATIC_TEMPLATE);
        try {
            this.login();
            MockHttpServletRequest request = (MockHttpServletRequest)GeoServerApplication.get().servletRequest();
            ServletRequestAttributes requestAttributes = new ServletRequestAttributes((HttpServletRequest)request);
            RequestContextHolder.setRequestAttributes((RequestAttributes)requestAttributes);
            tester.startPage((Page)new TemplateConfigurationPage((IModel)new Model((Serializable)info), false));
            tester.assertModelValue("theForm:tabbedPanel:panel:templateName", (Object)"testGMLTemplate");
            tester.assertModelValue("theForm:tabbedPanel:panel:extension", (Object)"xml");
            tester.assertModelValue("theForm:tabbedPanel:panel:workspace", (Object)"cite");
            tester.assertModelValue("theForm:tabbedPanel:panel:featureTypeInfo", null);
            tester.clickLink("theForm:tabbedPanel:tabs-container:tabs:1:link");
            FormTester form2 = tester.newFormTester("theForm:tabbedPanel:panel:previewForm");
            form2.select("outputFormats", 0);
            tester.assertComponent("theForm:tabbedPanel:panel:previewForm:workspaces", DropDownChoice.class);
            tester.assertComponent("theForm:tabbedPanel:panel:previewForm:featureTypes", DropDownChoice.class);
            tester.assertComponent("theForm:tabbedPanel:panel:previewForm:previewArea", CodeMirrorEditor.class);
            tester.assertComponent("theForm:tabbedPanel:panel:previewForm:preview", AjaxSubmitLink.class);
            tester.assertComponent("theForm:tabbedPanel:panel:previewForm:validate", AjaxSubmitLink.class);
            DropDownChoice ws = (DropDownChoice)tester.getComponentFromLastRenderedPage("theForm:tabbedPanel:panel:previewForm:workspaces");
            Assert.assertFalse((boolean)ws.isEnabled());
            DropDownChoice ft = (DropDownChoice)tester.getComponentFromLastRenderedPage("theForm:tabbedPanel:panel:previewForm:featureTypes");
            Assert.assertTrue((boolean)ft.isEnabled());
            form2.select("featureTypes", 0);
            TemplatePreviewPanel previewPanel = (TemplatePreviewPanel)tester.getComponentFromLastRenderedPage("theForm:tabbedPanel:panel");
            List<Cookie> httpCookies = this.getCookiesFromPreviewRequest(previewPanel);
            Cookie cookie = httpCookies.stream().filter(c -> c.getName().equals("JSESSIONID")).findFirst().get();
            Assert.assertNotNull((Object)cookie);
            Assert.assertEquals((Object)requestAttributes.getSessionId(), (Object)cookie.getValue());
            tester.newFormTester("theForm").submit("save");
            tester.assertNoErrorMessage();
            tester.assertRenderedPage(TemplateInfoPage.class);
        }
        finally {
            TemplateInfoDAO.get().deleteAll();
        }
    }

    private List<Cookie> getCookiesFromPreviewRequest(TemplatePreviewPanel previewPanel) {
        CookieStore cookieStore = (CookieStore)new PropertyModel((Object)previewPanel.buildHttpClient(), "cookieStore").getObject();
        return cookieStore.getCookies();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCacheCleanedOnTemplateUpdate() throws ExecutionException {
        try {
            TemplateInfo info = new TemplateInfo();
            info.setWorkspace("cite");
            info.setFeatureType("NamedPlaces");
            info.setTemplateName("testJsonLDTemplate");
            info.setExtension("json");
            TemplateService service = new TemplateService();
            service.saveOrUpdate(info, JSON_TEMPLATE);
            TemplateRule rule = new TemplateRule();
            rule.setTemplateIdentifier(info.getIdentifier());
            rule.setTemplateName(info.getFullName());
            rule.setOutputFormat(SupportedFormat.JSONLD);
            FeatureTypeInfo fti = this.getCatalog().getFeatureTypeByName("cite", "NamedPlaces");
            TemplateRuleService ruleService = new TemplateRuleService(fti);
            ruleService.saveRule(rule);
            Request request = new Request();
            request.setOutputFormat(TemplateIdentifier.JSONLD.getOutputFormat());
            Dispatcher.REQUEST.set(request);
            RootBuilder builder = TemplateLoader.get().getTemplate(fti, TemplateIdentifier.JSONLD.getOutputFormat());
            Assert.assertNotNull((Object)builder);
            IteratingBuilder iteratingBuilder = (IteratingBuilder)builder.getChildren().get(0);
            Assert.assertNotNull((Object)iteratingBuilder.getStrSource());
            this.login();
            tester.startPage((Page)new TemplateConfigurationPage((IModel)new Model((Serializable)info), false));
            tester.assertModelValue("theForm:tabbedPanel:panel:templateName", (Object)"testJsonLDTemplate");
            tester.assertModelValue("theForm:tabbedPanel:panel:extension", (Object)"json");
            tester.assertModelValue("theForm:tabbedPanel:panel:workspace", (Object)"cite");
            DropDownChoice dropDownChoice = (DropDownChoice)tester.getComponentFromLastRenderedPage("theForm:tabbedPanel:panel:featureTypeInfo");
            dropDownChoice.setModelObject(null);
            FormTester ft = tester.newFormTester("theForm");
            ft.setValue("templateEditor:editorContainer:editorParent:editor", "{\"static\":\"value\"}");
            ft.submit("save");
            tester.assertNoErrorMessage();
            tester.assertRenderedPage(TemplateInfoPage.class);
            RootBuilder rootBuilder = TemplateLoader.get().getTemplate(fti, TemplateIdentifier.JSONLD.getOutputFormat());
            Assert.assertNotNull((Object)rootBuilder);
            CompositeBuilder compositeBuilder = (CompositeBuilder)rootBuilder.getChildren().get(0);
            Assert.assertNull((Object)compositeBuilder.getStrSource());
        }
        finally {
            TemplateInfoDAO.get().deleteAll();
            Dispatcher.REQUEST.set(null);
        }
    }
}

