/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.rest;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.geoserver.rest.RestException;
import org.geotools.util.Converters;
import org.springframework.http.HttpStatus;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PatchMergeHandler<T> {
    private Class<T> patchType;

    public PatchMergeHandler(Class<T> patchType) {
        this.patchType = patchType;
    }

    public <T> T applyPatch(String patch, T toPatch, String contentType) {
        try {
            if (this.isJSON(contentType)) {
                this.patchJSON((JSONObject)JSONSerializer.toJSON((Object)patch), toPatch);
            } else {
                this.patchXML(this.toXMLDocument(patch), toPatch);
            }
            return toPatch;
        }
        catch (IntrospectionException | IllegalAccessException | InvocationTargetException e) {
            throw new RestException(e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private PropertyDescriptor[] getDescriptors() throws IntrospectionException {
        return Introspector.getBeanInfo(this.patchType).getPropertyDescriptors();
    }

    private Document toXMLDocument(String xmlString) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(xmlString)));
            return doc;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RestException(e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private <T> T patchJSON(JSONObject patch, T toPatch) throws InvocationTargetException, IllegalAccessException, IntrospectionException {
        Set keys = patch.keySet();
        PropertyDescriptor[] descriptors = this.getDescriptors();
        for (Object k : keys) {
            Object o = patch.get(k);
            if (o instanceof JSONObject) {
                this.patchJSON((JSONObject)o, toPatch);
                continue;
            }
            if (o instanceof JSONArray) {
                this.patchJSON((JSONArray)o, toPatch);
                continue;
            }
            Optional<PropertyDescriptor> op = this.beanFieldFromJSON(descriptors, k);
            if (!op.isPresent()) continue;
            PropertyDescriptor pd = op.get();
            Object val = patch.get(pd.getName());
            this.setNewValue(toPatch, val, pd);
        }
        return toPatch;
    }

    private <T> T patchJSON(JSONArray patch, T toPatch) throws InvocationTargetException, IllegalAccessException, IntrospectionException {
        for (int i = 0; i < patch.size(); ++i) {
            this.patchJSON(patch.getJSONObject(i), toPatch);
        }
        return toPatch;
    }

    private Optional<PropertyDescriptor> beanFieldFromJSON(PropertyDescriptor[] descriptors, Object fieldName) {
        return Stream.of(descriptors).filter(d -> d.getName().equals(fieldName)).findFirst();
    }

    private <T> T patchXML(Document patch, T toPatch) throws IntrospectionException, InvocationTargetException, IllegalAccessException {
        for (PropertyDescriptor pd : this.getDescriptors()) {
            String fieldName = pd.getName();
            NodeList list = patch.getElementsByTagName(fieldName);
            if (list.getLength() <= 0) continue;
            Node node = list.item(0);
            Node nil = node.getAttributes().getNamedItem("xs:nil");
            String newValue = nil != null && nil.getTextContent().equals("true") ? null : node.getTextContent();
            this.setNewValue(toPatch, newValue, pd);
        }
        return toPatch;
    }

    private void setNewValue(Object toPatch, Object newValue, PropertyDescriptor pd) throws InvocationTargetException, IllegalAccessException {
        if ((newValue = this.convertNullIfNeeded(newValue)) != null) {
            Class<?> type = pd.getPropertyType();
            newValue = Converters.convert((Object)newValue, type);
        }
        pd.getWriteMethod().invoke(toPatch, newValue);
    }

    private Object convertNullIfNeeded(Object value) {
        if (value == null || value.equals("null") || value.equals("")) {
            value = null;
        }
        return value;
    }

    private boolean isJSON(String contentType) {
        return contentType.equals("application/json") || contentType.equals("text/json");
    }
}

