/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.rest;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.featurestemplating.configuration.SupportedFormat;
import org.geoserver.featurestemplating.configuration.TemplateInfo;
import org.geoserver.featurestemplating.configuration.TemplateInfoDAO;
import org.geoserver.featurestemplating.configuration.TemplateLayerConfig;
import org.geoserver.featurestemplating.configuration.TemplateRule;
import org.geoserver.featurestemplating.configuration.TemplateRuleService;
import org.geoserver.rest.catalog.CatalogRESTTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.http.HttpStatus;
import org.springframework.mock.web.MockHttpServletResponse;

public class TemplateRuleRestControllerTest
extends CatalogRESTTestSupport {
    @Test
    public void testPostGetPutGetDelete() throws Exception {
        TemplateInfo info = new TemplateInfo();
        info.setTemplateName("test-rules");
        info.setExtension("xhtml");
        TemplateInfoDAO.get().saveOrUpdate(info);
        String json = "{\n    \"Rule\": {\n        \"priority\": 1,\n        \"templateName\": \"test-rules\",\n        \"outputFormat\": \"HTML\",\n        \"cqlFilter\": \"requestParam('myRequestParam')='true'\",\n    }\n}";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/cdf/featuretypes/Fifteen/templaterules", json, "application/json");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        FeatureTypeInfo fifteen = catalog.getFeatureTypeByName("cdf", "Fifteen");
        TemplateLayerConfig templateLayerConfig = (TemplateLayerConfig)fifteen.getMetadata().get("FEATURES_TEMPLATING_LAYER_CONF", TemplateLayerConfig.class);
        TemplateRule rule = (TemplateRule)new ArrayList(templateLayerConfig.getTemplateRules()).get(0);
        String id = rule.getRuleId();
        JSONObject result = (JSONObject)this.getAsJSON("/rest/workspaces/cdf/featuretypes/Fifteen/templaterules/" + id + ".json");
        JSONObject ruleJSON = result.getJSONObject("Rule");
        Assert.assertEquals((long)1L, (long)ruleJSON.getInt("priority"));
        Assert.assertEquals((Object)"test-rules", (Object)ruleJSON.getString("templateName"));
        Assert.assertEquals((Object)"HTML", (Object)ruleJSON.getString("outputFormat"));
        Assert.assertEquals((Object)"requestParam('myRequestParam')='true'", (Object)ruleJSON.getString("cqlFilter"));
        String xmlRule = " <Rule>\n        <priority>2</priority>\n        <templateName>test-rules</templateName>\n        <outputFormat>HTML</outputFormat>\n        <cqlFilter>requestParam('otherRequestParam')='true'</cqlFilter>\n    </Rule>";
        response = this.putAsServletResponse("/rest/workspaces/cdf/featuretypes/Fifteen/templaterules/" + rule.getRuleId(), xmlRule, "application/xml");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        result = (JSONObject)this.getAsJSON("/rest/workspaces/cdf/featuretypes/Fifteen/templaterules/" + id + ".json");
        ruleJSON = result.getJSONObject("Rule");
        Assert.assertEquals((long)2L, (long)ruleJSON.getInt("priority"));
        Assert.assertEquals((Object)"test-rules", (Object)ruleJSON.getString("templateName"));
        Assert.assertEquals((Object)"HTML", (Object)ruleJSON.getString("outputFormat"));
        Assert.assertEquals((Object)"requestParam('otherRequestParam')='true'", (Object)ruleJSON.getString("cqlFilter"));
        response = this.deleteAsServletResponse("/rest/workspaces/cdf/featuretypes/Fifteen/templaterules/" + rule.getRuleId());
        Assert.assertEquals((long)HttpStatus.NO_CONTENT.value(), (long)response.getStatus());
        fifteen = catalog.getFeatureTypeByName("cdf", "Fifteen");
        templateLayerConfig = (TemplateLayerConfig)fifteen.getMetadata().get("FEATURES_TEMPLATING_LAYER_CONF", TemplateLayerConfig.class);
        Assert.assertTrue((boolean)templateLayerConfig.getTemplateRules().isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPostGetPatchGet() throws Exception {
        try {
            TemplateInfo info = new TemplateInfo();
            info.setTemplateName("test-rules2");
            info.setExtension("xhtml");
            TemplateInfoDAO.get().saveOrUpdate(info);
            String json = "{\n    \"Rule\": {\n        \"priority\": 1,\n        \"templateName\": \"test-rules2\",\n        \"outputFormat\": \"HTML\",\n        \"cqlFilter\": \"requestParam('myRequestParam')='true'\",\n    }\n}";
            MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/cite/featuretypes/Forests/templaterules", json, "application/json");
            Assert.assertEquals((long)201L, (long)response.getStatus());
            FeatureTypeInfo forests = catalog.getFeatureTypeByName("cite", "Forests");
            TemplateLayerConfig templateLayerConfig = (TemplateLayerConfig)forests.getMetadata().get("FEATURES_TEMPLATING_LAYER_CONF", TemplateLayerConfig.class);
            TemplateRule rule = (TemplateRule)templateLayerConfig.getTemplateRules().iterator().next();
            String id = rule.getRuleId();
            JSONObject result = (JSONObject)this.getAsJSON("/rest/workspaces/cite/featuretypes/Forests/templaterules/" + id + ".json");
            JSONObject ruleJSON = result.getJSONObject("Rule");
            Assert.assertEquals((long)1L, (long)ruleJSON.getInt("priority"));
            Assert.assertEquals((Object)"test-rules2", (Object)ruleJSON.getString("templateName"));
            Assert.assertEquals((Object)"HTML", (Object)ruleJSON.getString("outputFormat"));
            Assert.assertEquals((Object)"requestParam('myRequestParam')='true'", (Object)ruleJSON.getString("cqlFilter"));
            String xmlRule = " <Rule>\n        <priority>2</priority>\n        <cqlFilter>requestParam('otherRequestParam')='true'</cqlFilter>\n    </Rule>";
            response = this.patchAsServletResponse("/rest/workspaces/cite/featuretypes/Forests/templaterules/" + rule.getRuleId(), xmlRule, "application/xml");
            Assert.assertEquals((long)200L, (long)response.getStatus());
            result = (JSONObject)this.getAsJSON("/rest/workspaces/cite/featuretypes/Forests/templaterules/" + id + ".json");
            ruleJSON = result.getJSONObject("Rule");
            Assert.assertEquals((long)2L, (long)ruleJSON.getInt("priority"));
            Assert.assertEquals((Object)"test-rules2", (Object)ruleJSON.getString("templateName"));
            Assert.assertEquals((Object)"HTML", (Object)ruleJSON.getString("outputFormat"));
            Assert.assertEquals((Object)"requestParam('otherRequestParam')='true'", (Object)ruleJSON.getString("cqlFilter"));
        }
        finally {
            this.cleanup(this.getCatalog().getFeatureTypeByName("cite", "Forests"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetAll() throws Exception {
        try {
            TemplateInfo info = new TemplateInfo();
            info.setTemplateName("test-rules");
            info.setExtension("xhtml");
            TemplateInfoDAO.get().saveOrUpdate(info);
            TemplateInfo info2 = new TemplateInfo();
            info2.setTemplateName("test-rules2");
            info2.setExtension("xml");
            TemplateInfoDAO.get().saveOrUpdate(info2);
            TemplateInfo info3 = new TemplateInfo();
            info3.setTemplateName("test-rules3");
            info3.setExtension("json");
            TemplateInfoDAO.get().saveOrUpdate(info3);
            FeatureTypeInfo places = catalog.getFeatureTypeByName("cite", "NamedPlaces");
            TemplateLayerConfig templateLayerConfig = new TemplateLayerConfig();
            TemplateRule rule = new TemplateRule();
            rule.setTemplateName("test-rule");
            rule.setOutputFormat(SupportedFormat.HTML);
            rule.setTemplateIdentifier(info.getIdentifier());
            templateLayerConfig.addTemplateRule(rule);
            rule = new TemplateRule();
            rule.setTemplateName("test-rule2");
            rule.setOutputFormat(SupportedFormat.GML);
            rule.setTemplateIdentifier(info2.getIdentifier());
            templateLayerConfig.addTemplateRule(rule);
            rule = new TemplateRule();
            rule.setTemplateName("test-rule3");
            rule.setOutputFormat(SupportedFormat.GEOJSON);
            rule.setTemplateIdentifier(info3.getIdentifier());
            templateLayerConfig.addTemplateRule(rule);
            places.getMetadata().put("FEATURES_TEMPLATING_LAYER_CONF", (Serializable)templateLayerConfig);
            this.getCatalog().save((ResourceInfo)places);
            JSONObject result = (JSONObject)this.getAsJSON("/rest/workspaces/cite/featuretypes/NamedPlaces/templaterules.json");
            JSONArray array = result.getJSONObject("RulesList").getJSONArray("Rules");
            Assert.assertEquals((long)3L, (long)array.size());
            for (int i = 0; i < array.size(); ++i) {
                JSONObject ruleJSON = array.getJSONObject(i);
                this.assertRule(ruleJSON);
            }
        }
        finally {
            this.cleanup(catalog.getFeatureTypeByName("cite", "NamedPlaces"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPatch() throws Exception {
        try {
            TemplateInfo info = new TemplateInfo();
            info.setTemplateName("test-rules");
            info.setExtension("xhtml");
            TemplateInfoDAO.get().saveOrUpdate(info);
            TemplateInfo info2 = new TemplateInfo();
            info2.setTemplateName("test-rules2");
            info2.setExtension("xml");
            TemplateInfoDAO.get().saveOrUpdate(info2);
            FeatureTypeInfo places = catalog.getFeatureTypeByName("cite", "Lakes");
            TemplateLayerConfig templateLayerConfig = new TemplateLayerConfig();
            TemplateRule rule = new TemplateRule();
            rule.setTemplateName("test-rules");
            rule.setOutputFormat(SupportedFormat.HTML);
            rule.setTemplateIdentifier(info.getIdentifier());
            rule.setCqlFilter("requestParam('myRequestParam')='value'");
            templateLayerConfig.addTemplateRule(rule);
            TemplateRule rule2 = new TemplateRule();
            rule2.setTemplateName("test-rules2");
            rule2.setOutputFormat(SupportedFormat.GML);
            rule2.setTemplateIdentifier(info2.getIdentifier());
            rule2.setCqlFilter("requestParam('myRequestParam')='value'");
            templateLayerConfig.addTemplateRule(rule2);
            places.getMetadata().put("FEATURES_TEMPLATING_LAYER_CONF", (Serializable)templateLayerConfig);
            this.getCatalog().save((ResourceInfo)places);
            String xmlRule = " <Rule>\n        <priority>2</priority>\n        <cqlFilter xs:nil=\"true\"/>\n    </Rule>";
            MockHttpServletResponse response = this.patchAsServletResponse("/rest/workspaces/cite/featuretypes/Lakes/templaterules/" + rule.getRuleId(), xmlRule, "application/xml");
            Assert.assertEquals((long)HttpStatus.OK.value(), (long)response.getStatus());
            String json = "{\"Rule\":{\"outputFormat\":\"HTML\",\"cqlFilter\":null}}";
            response = this.patchAsServletResponse("/rest/workspaces/cite/featuretypes/Lakes/templaterules/" + rule2.getRuleId(), json, "application/json");
            Assert.assertEquals((long)HttpStatus.OK.value(), (long)response.getStatus());
            FeatureTypeInfo fti = catalog.getFeatureTypeByName("cite", "Lakes");
            TemplateRuleService service = new TemplateRuleService(fti);
            TemplateRule nullCQL = service.getRule(rule.getRuleId());
            Assert.assertNull((Object)nullCQL.getCqlFilter());
            Assert.assertEquals((long)2L, (long)nullCQL.getPriority().intValue());
            nullCQL = service.getRule(rule2.getRuleId());
            Assert.assertNull((Object)nullCQL.getCqlFilter());
            Assert.assertEquals((Object)SupportedFormat.HTML, (Object)nullCQL.getOutputFormat());
        }
        finally {
            this.cleanup(catalog.getFeatureTypeByName("cite", "Lakes"));
        }
    }

    private void assertRule(JSONObject rule) {
        Assert.assertNotNull((Object)rule.getString("templateName"));
        Assert.assertNotNull((Object)rule.getString("templateIdentifier"));
        Assert.assertNotNull((Object)rule.getString("outputFormat"));
    }

    private void cleanup(FeatureTypeInfo fti) {
        TemplateLayerConfig layerConfig = (TemplateLayerConfig)fti.getMetadata().get("FEATURES_TEMPLATING_LAYER_CONF", TemplateLayerConfig.class);
        if (layerConfig != null) {
            layerConfig.setTemplateRules(new HashSet());
            fti.getMetadata().put("FEATURES_TEMPLATING_LAYER_CONF", (Serializable)layerConfig);
            this.getCatalog().save((ResourceInfo)fti);
        }
    }
}

