/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.rest;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.featurestemplating.builders.TemplateBuilder;
import org.geoserver.featurestemplating.builders.impl.RootBuilder;
import org.geoserver.featurestemplating.builders.impl.StaticBuilder;
import org.geoserver.featurestemplating.configuration.SupportedFormat;
import org.geoserver.featurestemplating.configuration.TemplateFileManager;
import org.geoserver.featurestemplating.configuration.TemplateIdentifier;
import org.geoserver.featurestemplating.configuration.TemplateInfo;
import org.geoserver.featurestemplating.configuration.TemplateInfoDAO;
import org.geoserver.featurestemplating.configuration.TemplateLoader;
import org.geoserver.featurestemplating.configuration.TemplateRule;
import org.geoserver.featurestemplating.configuration.TemplateRuleService;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.platform.resource.Resource;
import org.geoserver.rest.RestException;
import org.geoserver.rest.catalog.CatalogRESTTestSupport;
import org.geoserver.util.IOUtils;
import org.geotools.util.URLs;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.http.HttpStatus;
import org.springframework.mock.web.MockHttpServletResponse;

public class TemplateRestControllerTest
extends CatalogRESTTestSupport {
    private static final String XHTML_TEMPLATE = "<gft:Template>\n  <ul>\n    <li><span>MeteoStations</span>\n      <ul>\n        <li><span >Code</span>\n          <ul>\n            <li>\n              $${strConcat('Station_',st:code)}\n            </li>\n          </ul>\n        </li>\n        <li><span>Name</span>\n          <ul>\n            <li>\n              ${st:common_name}\n            </li>\n          </ul>\n        </li>\n        <li><span>Geometry</span>\n          <ul>\n            <li>\n              ${st:position}\n            </li>\n          </ul>\n        </li>\n      </ul>\n    </li>\n  </ul>\n</gft:Template>";
    private static final String XHTML_TEMPLATE_2 = "<gft:Template>\n  <ul>\n    <li><span>MeteoStations</span>\n      <ul>\n        <li><span>Name</span>\n          <ul>\n            <li>\n              ${st:common_name}\n            </li>\n          </ul>\n        </li>\n        <li><span>Geometry</span>\n          <ul>\n            <li>\n              ${st:position}\n            </li>\n          </ul>\n        </li>\n      </ul>\n    </li>\n  </ul>\n</gft:Template>";
    private static final String JSON_TEMPLATE = "{  \"@context\": {    \"gsp\": \"http://www.opengis.net/ont/geosparql#\",    \"sf\": \"http://www.opengis.net/ont/sf#\",    \"schema\": \"https://schema.org/\",    \"dc\": \"http://purl.org/dc/terms/\",    \"Feature\": \"gsp:Feature\",    \"FeatureCollection\": \"schema:Collection\",    \"Point\": \"sf:Point\",    \"wkt\": \"gsp:asWKT\",    \"features\": {      \"@container\": \"@set\",      \"@id\": \"schema:hasPart\"    },    \"geometry\": \"sf:geometry\",    \"description\": \"dc:description\",    \"title\": \"dc:title\",    \"name\": \"schema:name\"  },  \"type\": \"FeatureCollection\",  \"features\": [    {      \"$source\": \"cite:NamedPlaces\"    },    {      \"id\": \"${cite:FID}\",      \"@type\": [        \"Feature\",        \"cite:NamedPlaces\",        \"http://vocabulary.odm2.org/samplingfeaturetype/namedplaces\"      ],      \"name\": \"${cite:NAME}\",      \"geometry\": {        \"@type\": \"MultiPolygon\",        \"wkt\": \"$${toWKT(xpath('cite:the_geom'))}\"      }    }  ]}";
    private static final String JSON_TEMPLATE_2 = "{  \"type\": \"FeatureCollection\",  \"features\": [    {      \"$source\": \"cite:NamedPlaces\"    },    {      \"id\": \"${cite:FID}\",      \"@type\": [        \"Feature\",        \"cite:NamedPlaces\",        \"http://vocabulary.odm2.org/samplingfeaturetype/namedplaces\"      ],      \"name\": \"${cite:NAME}\",      \"geometry\": {        \"@type\": \"MultiPolygon\",        \"wkt\": \"$${toWKT(xpath('cite:the_geom'))}\"      }    }  ]}";
    private static final String GML_TEMPLATE = "<gft:Template>\n<gft:Options>\n  <gft:Namespaces xmlns:topp=\"http://www.openplans.org/topp\"/>\n  <gft:SchemaLocation xsi:schemaLocation=\"http://www.opengis.net/wfs/2.0 http://brgm-dev.geo-solutions.it/geoserver/schemas/wfs/2.0/wfs.xsd http://www.opengis.net/gml/3.2 http://schemas.opengis.net/gml/3.2.1/gml.xsd\"/>\n</gft:Options>\n  <topp:states gml:id=\"${@id}\">\n  \t<topp:name code=\"${STATE_ABBR}\">${STATE_NAME}</topp:name>\n  \t<topp:region>${SUB_REGION}</topp:region>\n    <topp:population>${PERSONS}</topp:population>\n    <topp:males>${MALE}</topp:males>\n  \t<topp:females>${FEMALE}</topp:females>\n  \t<topp:active_population>${WORKERS}</topp:active_population>\n  \t<topp:wkt_geom>$${toWKT(the_geom)}</topp:wkt_geom>\n  </topp:states>\n</gft:Template>";
    private static final String GML_TEMPLATE_2 = "<gft:Template>\n<gft:Options>\n  <gft:Namespaces xmlns:topp=\"http://www.openplans.org/topp\"/>\n  <gft:SchemaLocation xsi:schemaLocation=\"http://www.opengis.net/wfs/2.0 http://brgm-dev.geo-solutions.it/geoserver/schemas/wfs/2.0/wfs.xsd http://www.opengis.net/gml/3.2 http://schemas.opengis.net/gml/3.2.1/gml.xsd\"/>\n</gft:Options>\n  <topp:states gml:id=\"${@id}\">\n  \t<topp:name code=\"${STATE_ABBR}\">${STATE_NAME}</topp:name>\n  \t<topp:region>${SUB_REGION}</topp:region>\n  \t<topp:wkt_geom>$${toWKT(the_geom)}</topp:wkt_geom>\n  </topp:states>\n</gft:Template>";
    public static final String XHTMLTEMPLATE_NAME = "xhtmltemplate";

    @Test
    public void testPostGetPutGetDeleteJson() throws Exception {
        try {
            MockHttpServletResponse response = this.postAsServletResponse("/rest/featurestemplates?templateName=foo", JSON_TEMPLATE, "application/json");
            Assert.assertEquals((long)201L, (long)response.getStatus());
            response = this.getAsServletResponse("/rest/featurestemplates/foo");
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertEquals((Object)JSON_TEMPLATE.trim(), (Object)response.getContentAsString());
            response = this.putAsServletResponse("/rest/featurestemplates/foo", JSON_TEMPLATE_2, "application/json");
            Assert.assertEquals((long)201L, (long)response.getStatus());
            response = this.getAsServletResponse("/rest/featurestemplates/foo");
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertEquals((Object)JSON_TEMPLATE_2.trim(), (Object)response.getContentAsString());
            response = this.deleteAsServletResponse("/rest/featurestemplates/foo");
            Assert.assertEquals((long)HttpStatus.NO_CONTENT.value(), (long)response.getStatus());
            Assert.assertNull((Object)TemplateInfoDAO.get().findByFullName("foo"));
        }
        finally {
            TemplateInfoDAO.get().deleteAll();
        }
    }

    @Test
    public void testPostGetPutGetDeleteXML() throws Exception {
        try {
            MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/cdf/featurestemplates?templateName=foo2", GML_TEMPLATE, "application/xml");
            Assert.assertEquals((long)201L, (long)response.getStatus());
            response = this.getAsServletResponse("/rest/workspaces/cdf/featurestemplates/foo2");
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertEquals((Object)GML_TEMPLATE.trim(), (Object)response.getContentAsString());
            response = this.putAsServletResponse("/rest/workspaces/cdf/featurestemplates/foo2", GML_TEMPLATE_2, "application/xml");
            Assert.assertEquals((long)201L, (long)response.getStatus());
            response = this.getAsServletResponse("/rest/workspaces/cdf/featurestemplates/foo2");
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertEquals((Object)GML_TEMPLATE_2.trim(), (Object)response.getContentAsString());
            response = this.deleteAsServletResponse("/rest/workspaces/cdf/featurestemplates/foo2");
            Assert.assertEquals((long)HttpStatus.NO_CONTENT.value(), (long)response.getStatus());
            Assert.assertNull((Object)TemplateInfoDAO.get().findByFullName("cdf:foo2"));
        }
        finally {
            TemplateInfoDAO.get().deleteAll();
        }
    }

    @Test
    public void testPostErrorMessage() throws Exception {
        try {
            MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/cdf/featuretypes/stations/featurestemplates?templateName=foo2", GML_TEMPLATE, "application/xml");
            Assert.assertEquals((long)404L, (long)response.getStatus());
            Assert.assertEquals((Object)"FeatureType stations not found", (Object)response.getContentAsString());
        }
        finally {
            TemplateInfoDAO.get().deleteAll();
        }
    }

    @Test
    public void testPostGetPutGetDeleteXHTML() throws Exception {
        try {
            MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/cdf/featuretypes/Fifteen/featurestemplates?templateName=foo3", XHTML_TEMPLATE, "application/xhtml+xml");
            Assert.assertEquals((long)201L, (long)response.getStatus());
            response = this.getAsServletResponse("/rest/workspaces/cdf/featuretypes/Fifteen/featurestemplates/foo3");
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertEquals((Object)XHTML_TEMPLATE.trim(), (Object)response.getContentAsString());
            response = this.putAsServletResponse("/rest/workspaces/cdf/featuretypes/Fifteen/featurestemplates/foo3", XHTML_TEMPLATE_2, "application/xhtml+xml");
            Assert.assertEquals((long)201L, (long)response.getStatus());
            response = this.getAsServletResponse("/rest/workspaces/cdf/featuretypes/Fifteen/featurestemplates/foo3");
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertEquals((Object)XHTML_TEMPLATE_2.trim(), (Object)response.getContentAsString());
            response = this.deleteAsServletResponse("/rest/workspaces/cdf/featuretypes/Fifteen/featurestemplates/foo3");
            Assert.assertEquals((long)HttpStatus.NO_CONTENT.value(), (long)response.getStatus());
            Assert.assertNull((Object)TemplateInfoDAO.get().findByFullName("cdf:Fifteen:foo3"));
        }
        finally {
            TemplateInfoDAO.get().deleteAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testZip() throws Exception {
        try {
            URL url = ((Object)((Object)this)).getClass().getResource("test-template.zip");
            byte[] bytes = FileUtils.readFileToByteArray((File)URLs.urlToFile((URL)url));
            MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/cdf/featuretypes/Fifteen/featurestemplates", bytes, "application/zip");
            Assert.assertEquals((long)201L, (long)response.getStatus());
            response = this.getAsServletResponse("/rest/workspaces/cdf/featuretypes/Fifteen/featurestemplates/test-template");
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertEquals((Object)this.unzip("test-template.zip", ((Object)((Object)this)).getClass()).trim(), (Object)response.getContentAsString().trim());
            url = ((Object)((Object)this)).getClass().getResource("test-template2.zip");
            bytes = FileUtils.readFileToByteArray((File)URLs.urlToFile((URL)url));
            response = this.putAsServletResponse("/rest/workspaces/cdf/featuretypes/Fifteen/featurestemplates/test-template", bytes, "application/zip");
            Assert.assertEquals((long)201L, (long)response.getStatus());
            response = this.getAsServletResponse("/rest/workspaces/cdf/featuretypes/Fifteen/featurestemplates/test-template");
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertEquals((Object)this.unzip("test-template2.zip", ((Object)((Object)this)).getClass()).trim(), (Object)response.getContentAsString());
            response = this.deleteAsServletResponse("/rest/workspaces/cdf/featuretypes/Fifteen/featurestemplates/test-template");
            Assert.assertEquals((long)HttpStatus.NO_CONTENT.value(), (long)response.getStatus());
            Assert.assertNull((Object)TemplateInfoDAO.get().findByFullName("cdf:Fifteen:test-template"));
        }
        finally {
            TemplateInfoDAO.get().deleteAll();
        }
    }

    private String unzip(String resourceName, Class<?> context) {
        InputStream object = context.getResourceAsStream(resourceName);
        try {
            File tempDir = Files.createTempDirectory("_template", new FileAttribute[0]).toFile();
            IOUtils.decompress((InputStream)object, (File)tempDir);
            File file = tempDir.listFiles()[0];
            byte[] bytes = FileUtils.readFileToByteArray((File)file);
            return new String(bytes, Charset.defaultCharset());
        }
        catch (Exception e) {
            LOGGER.severe("Error processing the template zip (PUT): " + e.getMessage());
            throw new RestException("Error processing the template", HttpStatus.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    @Test
    public void testFindAll() throws Exception {
        this.newTemplateInfo("jsontemplate", "json", null, null, JSON_TEMPLATE);
        this.newTemplateInfo("gmltemplate", "xml", "cdf", null, GML_TEMPLATE);
        this.newTemplateInfo(XHTMLTEMPLATE_NAME, "xhtml", "cdf", "Fifteen", XHTML_TEMPLATE);
        this.newTemplateInfo("jsontemplate2", "json", "cdf", "Fifteen", JSON_TEMPLATE_2);
        this.newTemplateInfo("gmltemplate2", "xml", null, null, GML_TEMPLATE_2);
        this.newTemplateInfo("xhtmltemplate2", "xhtml", "cdf", null, XHTML_TEMPLATE_2);
        JSON result = this.getAsJSON("/rest/workspaces/cdf/featuretypes/Fifteen/featurestemplates.json", 200);
        JSONObject object = ((JSONObject)result).getJSONObject("templatesInfo");
        JSONArray array = object.getJSONArray("templates");
        Assert.assertEquals((long)2L, (long)array.size());
        this.assertInfos(array);
        result = this.getAsJSON("/rest/workspaces/cdf/featurestemplates.json", 200);
        object = ((JSONObject)result).getJSONObject("templatesInfo");
        array = object.getJSONArray("templates");
        Assert.assertEquals((long)2L, (long)array.size());
        this.assertInfos(array);
        result = this.getAsJSON("/rest/featurestemplates.json", 200);
        object = ((JSONObject)result).getJSONObject("templatesInfo");
        array = object.getJSONArray("templates");
        Assert.assertEquals((long)2L, (long)array.size());
        this.assertInfos(array);
    }

    private void assertInfos(JSONArray array) {
        for (int i = 0; i < array.size(); ++i) {
            JSONObject info = array.getJSONObject(i);
            Assert.assertNotNull((Object)info.getString("name"));
            Assert.assertNotNull((Object)info.getString("fileType"));
            Assert.assertNotNull((Object)info.getString("location"));
        }
    }

    private TemplateInfo newTemplateInfo(String name, String extension, String workspace, String featureType, String rawTemplate) {
        TemplateInfo info = new TemplateInfo();
        info.setTemplateName(name);
        info.setExtension(extension);
        info.setWorkspace(workspace);
        info.setFeatureType(featureType);
        TemplateInfoDAO.get().saveOrUpdate(info);
        TemplateFileManager.get().saveTemplateFile(info, rawTemplate);
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdatedCacheOnPut() throws Exception {
        try {
            TemplateInfo info = this.newTemplateInfo("testJsonTemplateCache", "json", null, null, "{\"static\":\"value\"}");
            FeatureTypeInfo fifteen = this.getCatalog().getFeatureTypeByName("cite", "NamedPlaces");
            TemplateRuleService service = new TemplateRuleService(fifteen);
            TemplateRule templateRule = new TemplateRule();
            templateRule.setTemplateName(info.getFullName());
            templateRule.setTemplateIdentifier(info.getIdentifier());
            templateRule.setOutputFormat(SupportedFormat.GEOJSON);
            service.saveRule(templateRule);
            Request request = new Request();
            request.setOutputFormat(TemplateIdentifier.JSON.getOutputFormat());
            Dispatcher.REQUEST.set(request);
            RootBuilder rootBuilder = TemplateLoader.get().getTemplate(fifteen, TemplateIdentifier.JSON.getOutputFormat());
            StaticBuilder builder = (StaticBuilder)((TemplateBuilder)rootBuilder.getChildren().get(0)).getChildren().get(0);
            String value = builder.getStaticValue().textValue();
            Assert.assertEquals((Object)"value", (Object)value);
            this.putAsServletResponse("/rest/featurestemplates/testJsonTemplateCache", "{\"differentStatic\":\"differentValue\"}", "application/json");
            rootBuilder = TemplateLoader.get().getTemplate(fifteen, TemplateIdentifier.JSON.getOutputFormat());
            Assert.assertNotNull((Object)rootBuilder);
            builder = (StaticBuilder)((TemplateBuilder)rootBuilder.getChildren().get(0)).getChildren().get(0);
            value = builder.getStaticValue().textValue();
            Assert.assertEquals((Object)"differentValue", (Object)value);
            this.deleteAsServletResponse("/rest/featurestemplates/testJsonTemplateCache");
        }
        finally {
            Dispatcher.REQUEST.set(null);
        }
    }

    @Test
    public void testGetByFeatureType() throws Exception {
        try {
            this.newTemplateInfo("jsontemplate", "json", null, null, JSON_TEMPLATE);
            this.newTemplateInfo("gmltemplate", "xml", "cdf", null, GML_TEMPLATE);
            this.newTemplateInfo(XHTMLTEMPLATE_NAME, "xhtml", "cdf", "Fifteen", XHTML_TEMPLATE);
            MockHttpServletResponse response = this.getAsServletResponse("/rest/workspaces/cdf/featuretypes/Fifteen/featurestemplates/xhtmltemplate.xml");
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertEquals((Object)XHTML_TEMPLATE.trim(), (Object)response.getContentAsString());
        }
        finally {
            TemplateInfoDAO.get().deleteAll();
        }
    }

    @Test
    public void testPostByFeatureType() throws Exception {
        try {
            MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/cdf/featuretypes/Fifteen/featurestemplates?templateName=foo2", GML_TEMPLATE, "application/xml");
            Assert.assertEquals((long)201L, (long)response.getStatus());
            Assert.assertEquals((Object)"foo2", (Object)response.getContentAsString());
        }
        finally {
            TemplateInfoDAO.get().deleteAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPostZipByFeatureType() throws Exception {
        try {
            URL url = ((Object)((Object)this)).getClass().getResource("test-template.zip");
            byte[] bytes = FileUtils.readFileToByteArray((File)URLs.urlToFile((URL)url));
            MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/cdf/featuretypes/Fifteen/featurestemplates", bytes, "application/zip");
            Assert.assertEquals((long)201L, (long)response.getStatus());
            TemplateInfo templateInfo = TemplateInfoDAO.get().findByFullName("cdf:Fifteen:test-template");
            Assert.assertNotNull((Object)templateInfo);
            Assert.assertEquals((Object)this.unzip("test-template.zip", ((Object)((Object)this)).getClass()).trim(), (Object)this.getTemplateContentByFullName(templateInfo.getFullName()).orElseGet(() -> null));
        }
        finally {
            TemplateInfoDAO.get().deleteAll();
        }
    }

    @Test
    public void testPutByFeatureType() throws Exception {
        TemplateInfoDAO.get().deleteAll();
        try {
            MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/cdf/featuretypes/Fifteen/featurestemplates?templateName=foo3", XHTML_TEMPLATE, "application/xhtml+xml");
            Assert.assertEquals((long)201L, (long)response.getStatus());
            response = this.putAsServletResponse("/rest/workspaces/cdf/featuretypes/Fifteen/featurestemplates/foo3", XHTML_TEMPLATE_2, "application/xhtml+xml");
            Assert.assertEquals((long)201L, (long)response.getStatus());
            this.getTemplateContentByFullName("cdf:Fifteen:foo3").ifPresentOrElse(content -> Assert.assertEquals((Object)XHTML_TEMPLATE_2.trim(), (Object)content), () -> Assert.assertNull((Object)"Template not found"));
        }
        finally {
            TemplateInfoDAO.get().deleteAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPutZipByFeatureType() throws Exception {
        try {
            URL url = ((Object)((Object)this)).getClass().getResource("test-template.zip");
            byte[] bytes = FileUtils.readFileToByteArray((File)URLs.urlToFile((URL)url));
            MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/cdf/featuretypes/Fifteen/featurestemplates", bytes, "application/zip");
            Assert.assertEquals((long)201L, (long)response.getStatus());
            url = ((Object)((Object)this)).getClass().getResource("test-template2.zip");
            bytes = FileUtils.readFileToByteArray((File)URLs.urlToFile((URL)url));
            response = this.putAsServletResponse("/rest/workspaces/cdf/featuretypes/Fifteen/featurestemplates/test-template", bytes, "application/zip");
            Assert.assertEquals((long)201L, (long)response.getStatus());
            TemplateInfo templateInfo = TemplateInfoDAO.get().findByFullName("cdf:Fifteen:test-template");
            Assert.assertNotNull((Object)templateInfo);
            Assert.assertEquals((Object)this.unzip("test-template2.zip", ((Object)((Object)this)).getClass()).trim(), (Object)this.getTemplateContentByFullName(templateInfo.getFullName()).orElseGet(() -> null));
        }
        finally {
            TemplateInfoDAO.get().deleteAll();
        }
    }

    private Optional<String> getTemplateContentByFullName(String templateName) {
        TemplateInfo templateInfo = TemplateInfoDAO.get().findByFullName(templateName);
        if (templateInfo == null) {
            return Optional.empty();
        }
        Resource resource = TemplateFileManager.get().getTemplateResource(templateInfo);
        if (resource.getType() != Resource.Type.RESOURCE) {
            throw new IllegalArgumentException("Template with fullName " + templateInfo.getFullName() + " not found");
        }
        try {
            return Optional.of(StringUtils.toEncodedString((byte[])resource.getContents(), (Charset)StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

