/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.ows.wfs;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.featurestemplating.builders.impl.RootBuilder;
import org.geoserver.featurestemplating.builders.impl.TemplateBuilderContext;
import org.geoserver.featurestemplating.configuration.TemplateIdentifier;
import org.geoserver.featurestemplating.configuration.TemplateLoader;
import org.geoserver.featurestemplating.ows.wfs.TemplateGetFeatureResponseHelper;
import org.geoserver.featurestemplating.writers.TemplateOutputWriter;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.WFSGetFeatureOutputFormat;
import org.geoserver.wfs.request.FeatureCollectionResponse;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.Property;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Envelope;

public abstract class BaseTemplateGetFeatureResponse
extends WFSGetFeatureOutputFormat {
    protected TemplateLoader configuration;
    protected TemplateGetFeatureResponseHelper helper;
    protected TemplateIdentifier identifier;
    protected boolean hasGeometry;

    public BaseTemplateGetFeatureResponse(GeoServer gs, TemplateLoader configuration, TemplateIdentifier identifier) {
        super(gs, identifier.getOutputFormat());
        this.configuration = configuration;
        this.helper = new TemplateGetFeatureResponseHelper(gs.getCatalog(), identifier);
        this.identifier = identifier;
    }

    protected void write(FeatureCollectionResponse featureCollection, OutputStream output, Operation getFeature) throws ServiceException {
        try (TemplateOutputWriter writer = this.helper.getOutputWriter(output);){
            writer.startTemplateOutput(null);
            this.iterateFeatureCollection(writer, featureCollection, getFeature);
            writer.endTemplateOutput(null);
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    protected void iterateFeatureCollection(TemplateOutputWriter writer, FeatureCollectionResponse featureCollection, Operation operation) throws IOException, ExecutionException {
        List collectionList = featureCollection.getFeature();
        for (FeatureCollection collection : collectionList) {
            FeatureTypeInfo fti = this.helper.getFeatureTypeInfo(collection);
            RootBuilder root = this.configuration.getTemplate(fti, this.getMimeType(null, operation));
            this.beforeFeatureIteration(writer, root, fti);
            this.iterateFeatures(root, writer, collection);
        }
    }

    protected void iterateFeatureCollection(TemplateOutputWriter writer, FeatureCollectionResponse featureCollection) throws IOException, ExecutionException {
        this.iterateFeatureCollection(writer, featureCollection, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void iterateFeatures(RootBuilder rootBuilder, TemplateOutputWriter writer, FeatureCollection collection) throws IOException {
        try (FeatureIterator iterator = collection.features();){
            while (iterator.hasNext()) {
                Feature feature = iterator.next();
                this.beforeEvaluation(writer, rootBuilder, feature);
                TemplateBuilderContext context = new TemplateBuilderContext((Object)feature);
                rootBuilder.evaluate(writer, context);
                this.afterEvaluation(writer, rootBuilder, feature);
            }
        }
    }

    protected abstract void beforeFeatureIteration(TemplateOutputWriter var1, RootBuilder var2, FeatureTypeInfo var3);

    protected void beforeEvaluation(TemplateOutputWriter writer, RootBuilder root, Feature feature) throws IOException {
        GeometryDescriptor descriptor;
        writer.incrementNumberReturned();
        if (!this.hasGeometry && (descriptor = feature.getType().getGeometryDescriptor()) != null) {
            Property geometry = feature.getProperty(descriptor.getName());
            boolean bl = this.hasGeometry = geometry != null;
            if (writer.getCrs() == null) {
                CoordinateReferenceSystem featureCrs = descriptor.getCoordinateReferenceSystem();
                writer.setCrs(featureCrs);
                writer.setAxisOrder(CRS.getAxisOrder((CoordinateReferenceSystem)featureCrs));
            }
        }
    }

    protected void afterEvaluation(TemplateOutputWriter writer, RootBuilder root, Feature feature) throws IOException {
    }

    protected void writeAdditionalFields(TemplateOutputWriter writer, FeatureCollectionResponse featureCollection, Operation getFeature) throws IOException {
        BigInteger totalNumberOfFeatures = featureCollection.getTotalNumberOfFeatures();
        BigInteger featureCount = totalNumberOfFeatures != null && totalNumberOfFeatures.longValue() < 0L ? null : totalNumberOfFeatures;
        boolean isFeatureBounding = this.getInfo().isFeatureBounding();
        ReferencedEnvelope featuresBounds = this.getBoundsFromFeatureCollections(featureCollection.getFeature(), isFeatureBounding);
        this.writeAdditionalFieldsInternal(writer, featureCollection, getFeature, featureCount, featuresBounds);
    }

    private ReferencedEnvelope getBoundsFromFeatureCollections(List<FeatureCollection> featureCollectionList, boolean isFeatureBounding) {
        ReferencedEnvelope e = null;
        if (this.hasGeometry && isFeatureBounding) {
            for (int i = 0; i < featureCollectionList.size(); ++i) {
                FeatureCollection collection = featureCollectionList.get(i);
                if (e == null) {
                    e = collection.getBounds();
                    continue;
                }
                e.expandToInclude((Envelope)collection.getBounds());
            }
        }
        return e;
    }

    protected abstract void writeAdditionalFieldsInternal(TemplateOutputWriter var1, FeatureCollectionResponse var2, Operation var3, BigInteger var4, ReferencedEnvelope var5) throws IOException;
}

