/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.ows;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.featurestemplating.builders.impl.RootBuilder;
import org.geoserver.featurestemplating.configuration.TemplateIdentifier;
import org.geoserver.featurestemplating.configuration.TemplateLoader;
import org.geoserver.featurestemplating.ows.OWSResponseFactory;
import org.geoserver.featurestemplating.ows.wfs.BaseTemplateGetFeatureResponse;
import org.geoserver.featurestemplating.request.TemplatePathVisitor;
import org.geoserver.ows.AbstractDispatcherCallback;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.ows.Response;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.request.GetFeatureRequest;
import org.geoserver.wfs.request.Query;
import org.geoserver.wms.GetFeatureInfoRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.NameImpl;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.util.logging.Logging;

public class TemplateCallback
extends AbstractDispatcherCallback {
    private static final Logger LOGGER = Logging.getLogger(TemplateCallback.class);
    private Catalog catalog;
    private GeoServer gs;
    private TemplateLoader configuration;
    static FilterFactory ff = CommonFactoryFinder.getFilterFactory();

    public TemplateCallback(GeoServer gs, TemplateLoader configuration) {
        this.gs = gs;
        this.catalog = gs.getCatalog();
        this.configuration = configuration;
    }

    public Operation operationDispatched(Request request, Operation operation) {
        if (this.operationSupported(operation)) {
            try {
                List queries;
                GetFeatureRequest getFeature = GetFeatureRequest.adapt((Object)operation.getParameters()[0]);
                if (getFeature != null && (queries = getFeature.getQueries()) != null && queries.size() > 0) {
                    this.handleTemplateFilters(queries, request.getOutputFormat());
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return super.operationDispatched(request, operation);
    }

    private void handleTemplateFilters(List<Query> queries, String outputFormat) throws ExecutionException {
        for (Query q : queries) {
            List<FeatureTypeInfo> featureTypeInfos = this.getFeatureTypeInfoFromQuery(q);
            List<RootBuilder> rootBuilders = this.getRootBuildersFromFeatureTypeInfo(featureTypeInfos, outputFormat);
            if (rootBuilders.size() <= 0) continue;
            for (int i = 0; i < featureTypeInfos.size(); ++i) {
                FeatureTypeInfo fti = featureTypeInfos.get(i);
                RootBuilder root = rootBuilders.get(i);
                this.replaceTemplatePath(q, fti, root);
            }
        }
    }

    private List<FeatureTypeInfo> getFeatureTypeInfoFromQuery(Query q) {
        ArrayList<FeatureTypeInfo> typeInfos = new ArrayList<FeatureTypeInfo>();
        for (QName typeName : q.getTypeNames()) {
            typeInfos.add(this.catalog.getFeatureTypeByName((Name)new NameImpl(typeName.getPrefix(), typeName.getLocalPart())));
        }
        return typeInfos;
    }

    private List<RootBuilder> getRootBuildersFromFeatureTypeInfo(List<FeatureTypeInfo> typeInfos, String outputFormat) throws ExecutionException {
        ArrayList<RootBuilder> rootBuilders = new ArrayList<RootBuilder>();
        int nullRootIndex = 0;
        for (int i = 0; i < typeInfos.size(); ++i) {
            FeatureTypeInfo fti = typeInfos.get(i);
            RootBuilder root = this.ensureTemplatesExist(fti, outputFormat);
            if (root == null) {
                nullRootIndex = i;
                continue;
            }
            rootBuilders.add(root);
        }
        int rootsSize = rootBuilders.size();
        if (rootsSize > 0 && rootsSize != typeInfos.size()) {
            throw new RuntimeException("No template found for feature type " + typeInfos.get(nullRootIndex).getName() + " for output format " + outputFormat);
        }
        return rootBuilders;
    }

    private void replaceTemplatePath(Query q, FeatureTypeInfo fti, RootBuilder root) {
        try {
            TemplatePathVisitor visitor = new TemplatePathVisitor(fti.getFeatureType());
            if (q.getFilter() != null) {
                Filter old = q.getFilter();
                Filter newFilter = (Filter)old.accept((FilterVisitor)visitor, (Object)root);
                ArrayList<Filter> templateFilters = new ArrayList<Filter>();
                templateFilters.addAll(visitor.getFilters());
                if (templateFilters != null && templateFilters.size() > 0) {
                    templateFilters.add(newFilter);
                    newFilter = ff.and(templateFilters);
                }
                q.setFilter(newFilter);
                if (newFilter.equals(old)) {
                    LOGGER.warning("Failed to resolve filter " + ECQL.toCQL((Filter)old) + " against the template. If the property name was intended to be a template path, check that the path specified in the cql filter is correct.");
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Response responseDispatched(Request request, Operation operation, Object result, Response response) {
        Object param1;
        Response replacer;
        Object[] params = operation.getParameters();
        if (this.operationSupported(operation) && params.length > 0 && (replacer = this.findResponse(param1 = params[0])) != null) {
            response = replacer;
        }
        return super.responseDispatched(request, operation, result, response);
    }

    private boolean operationSupported(Operation operation) {
        String id = operation.getId();
        String serviceId = operation.getService().getId();
        GetFeatureRequest getFeature = operation.getParameters().length > 0 ? GetFeatureRequest.adapt((Object)operation.getParameters()[0]) : null;
        boolean isHits = getFeature != null && getFeature.isResultTypeHits();
        return "GetFeatureInfo".equalsIgnoreCase(id) && "wms".equalsIgnoreCase(serviceId) || "GetFeature".equalsIgnoreCase(id) && "wfs".equalsIgnoreCase(serviceId) && !isHits;
    }

    private Response findResponse(Object param1) {
        Response response = null;
        if (param1 instanceof GetFeatureInfoRequest) {
            GetFeatureInfoRequest request = (GetFeatureInfoRequest)param1;
            if (request.getInfoFormat() != null) {
                response = this.getTemplateFeatureInfoResponse(request);
            }
        } else {
            GetFeatureRequest getFeature = GetFeatureRequest.adapt((Object)param1);
            if (getFeature != null) {
                List queries = getFeature.getQueries();
                for (Query q : queries) {
                    List<FeatureTypeInfo> typeInfos = this.getFeatureTypeInfoFromQuery(q);
                    Response templateResponse = this.getTemplateFeatureResponse(typeInfos, getFeature.getOutputFormat());
                    if (templateResponse == null) continue;
                    response = templateResponse;
                }
            }
        }
        return response;
    }

    private Response getTemplateFeatureInfoResponse(GetFeatureInfoRequest request) {
        String infoFormat = request.getInfoFormat();
        TemplateIdentifier identifier = TemplateIdentifier.fromOutputFormat((String)request.getInfoFormat());
        if (identifier == null) {
            return null;
        }
        List layers = request.getQueryLayers();
        int matchingTemplates = 0;
        for (MapLayerInfo layer : layers) {
            if (layer == null || !(layer.getResource() instanceof FeatureTypeInfo) || this.ensureTemplatesExist(layer.getFeature(), identifier.getOutputFormat()) == null) continue;
            ++matchingTemplates;
        }
        if (matchingTemplates == 0) {
            return null;
        }
        int matchTemplatesDiff = layers.size() - matchingTemplates;
        if (matchTemplatesDiff != 0) {
            throw new ServiceException("To get a features templating getFeatureInfo a template is needed for every FeatureType but " + matchTemplatesDiff + " among the requested ones are missing a template");
        }
        return OWSResponseFactory.getInstance().featureInfoResponse(identifier, infoFormat);
    }

    private Response getTemplateFeatureResponse(List<FeatureTypeInfo> typeInfos, String outputFormat) {
        BaseTemplateGetFeatureResponse response = null;
        try {
            List<RootBuilder> rootBuilders = this.getRootBuildersFromFeatureTypeInfo(typeInfos, outputFormat);
            if (rootBuilders.size() > 0) {
                TemplateIdentifier templateIdentifier = TemplateIdentifier.fromOutputFormat((String)outputFormat);
                response = OWSResponseFactory.getInstance().getFeatureResponse(templateIdentifier);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return response;
    }

    private RootBuilder ensureTemplatesExist(FeatureTypeInfo typeInfo, String outputFormat) {
        try {
            TemplateIdentifier identifier = TemplateIdentifier.fromOutputFormat((String)outputFormat);
            RootBuilder rootBuilder = null;
            if (identifier != null) {
                rootBuilder = this.configuration.getTemplate(typeInfo, identifier.getOutputFormat());
                if (this.templateIsMandatory(identifier) && rootBuilder == null) {
                    throw new RuntimeException("No template found for feature type " + typeInfo.getName() + " for output format " + outputFormat);
                }
            }
            return rootBuilder;
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Exception will trying to check the existence of features templates for the requested feature types", e);
        }
    }

    private boolean templateIsMandatory(TemplateIdentifier identifier) {
        String requestName = ((Request)Dispatcher.REQUEST.get()).getRequest();
        boolean isFeatureInfo = requestName != null && requestName.equalsIgnoreCase("GetFeatureInfo");
        boolean mandatoryHTML = !isFeatureInfo && identifier.equals((Object)TemplateIdentifier.HTML);
        return identifier != null && (mandatoryHTML || identifier.equals((Object)TemplateIdentifier.JSONLD));
    }
}

