/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.ows;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.featurestemplating.configuration.schema.SchemaLoader;
import org.geoserver.featurestemplating.ows.wfs.SchemaOverrideDescribeFeatureTypeResponse;
import org.geoserver.ows.AbstractDispatcherCallback;
import org.geoserver.ows.Request;
import org.geoserver.ows.Response;
import org.geoserver.platform.Operation;
import org.geoserver.wfs.request.DescribeFeatureTypeRequest;
import org.geoserver.wfs.request.Query;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.FilterFactory;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.NameImpl;
import org.geotools.util.logging.Logging;

public class SchemaCallback
extends AbstractDispatcherCallback {
    private static final Logger LOGGER = Logging.getLogger(SchemaCallback.class);
    private Catalog catalog;
    private GeoServer gs;
    private SchemaLoader configuration;
    static FilterFactory ff = CommonFactoryFinder.getFilterFactory();

    public SchemaCallback(GeoServer gs, SchemaLoader configuration) {
        this.gs = gs;
        this.catalog = gs.getCatalog();
        this.configuration = configuration;
    }

    public Operation operationDispatched(Request request, Operation operation) {
        return super.operationDispatched(request, operation);
    }

    private List<FeatureTypeInfo> getFeatureTypeInfoFromQuery(Query q) {
        ArrayList<FeatureTypeInfo> typeInfos = new ArrayList<FeatureTypeInfo>();
        for (QName typeName : q.getTypeNames()) {
            typeInfos.add(this.catalog.getFeatureTypeByName((Name)new NameImpl(typeName.getPrefix(), typeName.getLocalPart())));
        }
        return typeInfos;
    }

    public Response responseDispatched(Request request, Operation operation, Object result, Response response) {
        Object param1;
        Response replacer;
        Object[] params = operation.getParameters();
        if (this.operationSupported(operation) && params.length > 0 && (replacer = this.findResponse(param1 = params[0])) != null) {
            response = replacer;
        }
        return super.responseDispatched(request, operation, result, response);
    }

    private boolean operationSupported(Operation operation) {
        String id = operation.getId();
        String serviceId = operation.getService().getId();
        return "DescribeFeatureType".equalsIgnoreCase(id) && "wfs".equalsIgnoreCase(serviceId);
    }

    private Response findResponse(Object param1) {
        DescribeFeatureTypeRequest dftr = DescribeFeatureTypeRequest.adapt((Object)param1);
        List qNames = dftr.getTypeNames();
        QName qName = (QName)qNames.get(0);
        FeatureTypeInfo featureTypeByName = this.catalog.getFeatureTypeByName(qName.getPrefix(), qName.getLocalPart());
        return this.getTemplateFeatureResponse(featureTypeByName, dftr.getOutputFormat());
    }

    private Response getTemplateFeatureResponse(FeatureTypeInfo typeInfos, String outputFormat) {
        SchemaOverrideDescribeFeatureTypeResponse response = null;
        try {
            String schema = this.configuration.getSchema(typeInfos, outputFormat);
            if (schema == null) {
                return null;
            }
            response = new SchemaOverrideDescribeFeatureTypeResponse(this.gs, outputFormat, schema);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return response;
    }
}

