/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.response;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.geoserver.featurestemplating.response.JSONLDGetSimpleFeaturesResponseTest;
import org.junit.Assert;
import org.junit.Test;

public class JSONLDGetSimpleFeaturesResponseWFSTest
extends JSONLDGetSimpleFeaturesResponseTest {
    @Test
    public void testJsonLdResponse() throws Exception {
        this.setUpSimple("NamedPlaces.json");
        StringBuilder sb = new StringBuilder("wfs?request=GetFeature&version=2.0");
        sb.append("&TYPENAME=cite:NamedPlaces&outputFormat=");
        sb.append("application%2Fld%2Bjson");
        JSONObject result = (JSONObject)this.getJsonLd(sb.toString());
        JSONObject context = (JSONObject)result.get("@context");
        Assert.assertNotNull((Object)context);
        JSONArray features = (JSONArray)result.get("features");
        Assert.assertEquals((long)features.size(), (long)2L);
        this.checkFeature((JSONObject)features.get(0));
    }

    @Test
    public void testJsonLdQueryPointingToExpr() throws Exception {
        this.setUpSimple("NamedPlaces.json");
        StringBuilder sb = new StringBuilder("wfs?request=GetFeature&version=2.0").append("&TYPENAME=cite:NamedPlaces&outputFormat=").append("application%2Fld%2Bjson").append("&cql_filter= features.geometry.wkt IS NULL ");
        JSONObject result = (JSONObject)this.getJsonLd(sb.toString());
        JSONObject context = (JSONObject)result.get("@context");
        Assert.assertNotNull((Object)context);
        JSONArray features = (JSONArray)result.get("features");
        Assert.assertEquals((long)0L, (long)features.size());
    }

    @Test
    public void testJsonLdResponseWithFilter() throws Exception {
        this.setUpSimple("NamedPlaces.json");
        StringBuilder path = new StringBuilder("wfs?request=GetFeature&version=2.0").append("&TYPENAME=cite:NamedPlaces").append("&outputFormat=application%2Fld%2Bjson").append("&cql_filter= features.id = '118'");
        JSONObject result = (JSONObject)this.getJsonLd(path.toString());
        JSONObject context = (JSONObject)result.get("@context");
        Assert.assertNotNull((Object)context);
        JSONArray features = (JSONArray)result.get("features");
        Assert.assertEquals((long)features.size(), (long)1L);
        JSONObject feature = (JSONObject)features.get(0);
        Assert.assertEquals((Object)feature.getString("id"), (Object)"118");
        Assert.assertNotNull((String)feature.getString("name"), (Object)"Goose Island");
        JSONObject geometry = (JSONObject)feature.get("geometry");
        Assert.assertEquals((Object)geometry.getString("@type"), (Object)"MultiPolygon");
        Assert.assertNotNull((Object)geometry.getString("wkt"));
    }
}

