/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.response;

import java.io.IOException;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.featurestemplating.configuration.SupportedFormat;
import org.geoserver.featurestemplating.response.TemplateComplexTestSupport;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HTMLGetComplexFeatureResponseTest
extends TemplateComplexTestSupport {
    private static final String MF_HTML = "HTMLMappedFeature";
    private static final String MF_HTML_PARAM = "&HTMLMappedFeature=true";
    private static final String MF_HTML_JSONLD = "HTMLMappedFeatureJSONLD";
    private static final String MF_HTML_PARAM_JSONLD = "&HTMLMappedFeatureJSONLD=true";
    private static final String MF_JSON_LD_TEMPLATE = "MappedFeatureJSONLDForHTML";
    private static final String MF_JSON_LD_PARAM = "&MappedFeatureJSONLDForHTML=true";

    public void onSetUp(SystemTestData testData) throws IOException {
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo mappedFeature = catalog.getFeatureTypeByName("gsml", "MappedFeature");
        String templateMappedFeature = "HTMLMappedFeature.xhtml";
        this.setUpTemplate("requestParam('HTMLMappedFeature')='true'", SupportedFormat.HTML, templateMappedFeature, MF_HTML, ".xhtml", "gsml", mappedFeature);
        String htmlWithJSONLD = "HTMLMappedFeatureWithJSONLD.xhtml";
        this.setUpTemplate("requestParam('HTMLMappedFeatureJSONLD')='true'", SupportedFormat.HTML, htmlWithJSONLD, MF_HTML_JSONLD, ".xhtml", "gsml", mappedFeature);
        String jsonLDMappedFeature = "ManagedMappedFeatureJSONLD.json";
        this.setUpTemplate("requestParam('MappedFeatureJSONLDForHTML')='true'", SupportedFormat.JSONLD, jsonLDMappedFeature, MF_JSON_LD_TEMPLATE, ".json", "gsml", mappedFeature);
    }

    @Test
    public void getMappedFeature() throws Exception {
        Document doc = this.getAsJSoup("wfs?request=GetFeature&version=1.1.0&typename=gsml:MappedFeature&outputFormat=text/html&HTMLMappedFeature=true");
        Assert.assertEquals((long)1L, (long)doc.select("script").size());
        this.assertHTMLResult(doc);
    }

    @Test
    public void getMappedFeatureHTMLWithJSONLD() {
        org.w3c.dom.Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&typename=gsml:MappedFeature&outputFormat=text/html&HTMLMappedFeatureJSONLD=true&MappedFeatureJSONLDForHTML=true");
        this.assertXpathCount(2, "//html/head/script", doc);
        NodeList list = doc.getElementsByTagName("script");
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            Node type = node.getAttributes().getNamedItem("type");
            if (type == null || !type.getTextContent().equals("application/ld+json")) continue;
            JSONObject jsonLD = (JSONObject)JSONSerializer.toJSON((Object)node.getTextContent());
            Object context = jsonLD.get("@context");
            this.checkContext(context);
            Assert.assertNotNull((Object)context);
            JSONArray features = (JSONArray)jsonLD.get("features");
            Assert.assertEquals((long)5L, (long)features.size());
            for (int j = 0; j < features.size(); ++j) {
                JSONObject feature = (JSONObject)features.get(i);
                this.checkMappedFeatureJSON(feature);
            }
        }
        this.assertHTMLResultXPath(doc);
    }

    @Test
    public void getMappedFeatureHTMLWithJSONLDTemplateMissing() throws Exception {
        MockHttpServletResponse resp = this.getAsServletResponse("wfs?request=GetFeature&version=1.1.0&typename=gsml:MappedFeature&outputFormat=text/html&HTMLMappedFeatureJSONLD=true");
        Assert.assertTrue((boolean)resp.getContentAsString().contains("Unable to find a JSON-LD template"));
    }

    @Test
    public void testEscaping() throws Exception {
        Document doc = this.getAsJSoup("wfs?request=GetFeature&version=1.1.0&typename=gsml:MappedFeature&outputFormat=text/html&HTMLMappedFeature=true");
        Assert.assertFalse((boolean)doc.select("li:contains(60\u00b0)").isEmpty());
        this.assertHTMLResult(doc);
    }

    private void assertHTMLResultXPath(org.w3c.dom.Document doc) {
        this.assertXpathCount(1, "//html/head/style", doc);
        this.assertXpathCount(5, "//html/body/ul/li[./span = 'MappedFeature']", doc);
        this.assertXpathCount(1, "//html/body/ul/li/ul[./li = 'mf1']", doc);
        this.assertXpathCount(1, "//html/body/ul/li/ul[./li = 'mf2']", doc);
        this.assertXpathCount(1, "//html/body/ul/li/ul[./li = 'mf3']", doc);
        this.assertXpathCount(1, "//html/body/ul/li/ul[./li = 'mf4']", doc);
        this.assertXpathCount(1, "//html/body/ul/li/ul[./li = 'mf5']", doc);
        this.assertXpathCount(1, "//html/body/ul/li/ul/li/ul[./li = 'GUNTHORPE FORMATION']", doc);
        this.assertXpathCount(1, "//html/body/ul/li/ul/li/ul[./li = 'MERCIA MUDSTONE GROUP']", doc);
        this.assertXpathCount(1, "//html/body/ul/li/ul/li/ul[./li = 'CLIFTON FORMATION']", doc);
        this.assertXpathCount(1, "//html/body/ul/li/ul/li/ul[./li = 'MURRADUC BASALT']", doc);
        this.assertXpathCount(1, "//html/body/ul/li/ul/li/ul[./li = 'IDONTKNOW']", doc);
        this.assertXpathCount(5, "//html/body/ul/li/ul/li[./span = 'Shape']", doc);
        this.assertXpathCount(4, "//html/body/ul/li/ul/li[./span = 'Specifications']", doc);
        this.assertXpathCount(4, "//html/body/ul/li/ul/li/ul/li[./span = 'Geologic Unit']", doc);
        this.assertXpathCount(4, "//html/body/ul/li/ul/li/ul/li/ul/li[./span = 'Purpose']", doc);
        this.assertXpathCount(4, "//html/body/ul/li/ul/li/ul/li/ul/li/ul[./li = 'instance']", doc);
        this.assertXpathCount(1, "//html/body/ul/li/ul/li/ul/li/ul/li/ul[./li = 'New Group']", doc);
        this.assertXpathCount(1, "//html/body/ul/li/ul/li/ul/li/ul/li/ul[./li = '-Xy']", doc);
        this.assertXpathCount(1, "//html/body/ul/li/ul/li/ul/li/ul/li/ul[./li = 'Yaugher Volcanic Group']", doc);
        this.assertXpathCount(2, "//html/body/ul/li/ul/li/ul/li/ul/li/ul[./li = 'Yaugher Volcanic Group 1']", doc);
        this.assertXpathCount(2, "//html/body/ul/li/ul/li/ul/li/ul/li/ul[./li = 'Yaugher Volcanic Group 2']", doc);
        this.assertXpathCount(3, "//html/body/ul/li/ul/li/ul/li/ul/li/ul[./li = '-Py']", doc);
        this.assertXpathCount(6, "//html/body/ul/li/ul/li/ul/li/ul/li[./span = 'Composition Parts']", doc);
        this.assertXpathCount(6, "//html/body/ul/li/ul/li/ul/li/ul/li/ul/li[./span = 'Part']", doc);
        this.assertXpathCount(6, "//html/body/ul/li/ul/li/ul/li/ul/li/ul/li/ul/li[./span = 'Role']", doc);
        this.assertXpathCount(5, "//html/body/ul/li/ul/li/ul/li/ul/li/ul/li/ul/li/ul[./li = 'interbedded component']", doc);
        this.assertXpathCount(1, "//html/body/ul/li/ul/li/ul/li/ul/li/ul/li/ul/li/ul[./li = 'fictitious component']", doc);
    }

    private void assertHTMLResult(Document doc) {
        Assert.assertEquals((long)1L, (long)doc.select("style").size());
        Assert.assertEquals((long)5L, (long)doc.select("span.caret:contains(MappedFeature)").size());
        Assert.assertEquals((long)1L, (long)doc.select("li ul li:contains(mf1)").size());
        Assert.assertEquals((long)1L, (long)doc.select("li ul li:contains(mf2)").size());
        Assert.assertEquals((long)1L, (long)doc.select("li ul li:contains(mf3)").size());
        Assert.assertEquals((long)1L, (long)doc.select("li ul li:contains(mf4)").size());
        Assert.assertEquals((long)1L, (long)doc.select("li ul li:contains(mf5)").size());
        Assert.assertEquals((long)1L, (long)doc.select("ul li ul li ul li:contains(GUNTHORPE FORMATION)").size());
        Assert.assertEquals((long)1L, (long)doc.select("ul li ul li ul li:contains(MERCIA MUDSTONE GROUP)").size());
        Assert.assertEquals((long)1L, (long)doc.select("ul li ul li ul li:contains(CLIFTON FORMATION)").size());
        Assert.assertEquals((long)1L, (long)doc.select("ul li ul li ul li:contains(MURRADUC BASALT)").size());
        Assert.assertEquals((long)1L, (long)doc.select("ul li ul li ul li:contains(IDONTKNOW)").size());
        Assert.assertEquals((long)5L, (long)doc.select("span:contains(Shape)").size());
        Assert.assertEquals((long)4L, (long)doc.select("ul li ul li span:contains(Specifications)").size());
        Assert.assertEquals((long)4L, (long)doc.select("ul li ul li span:contains(Geologic Unit)").size());
        Assert.assertEquals((long)4L, (long)doc.select("ul li ul li span:contains(Purpose)").size());
        Assert.assertEquals((long)4L, (long)doc.select("ul li ul li ul li ul li ul li:contains(instance)").size());
        Assert.assertEquals((long)1L, (long)doc.select("ul li ul li ul li ul li ul li:contains(New Group)").size());
        Assert.assertEquals((long)1L, (long)doc.select("ul li ul li ul li ul li ul li:contains(-Xy)").size());
        Assert.assertEquals((Object)"Yaugher Volcanic Group", (Object)((Element)doc.select("ul li ul li ul li ul li ul li:contains(Yaugher Volcanic Group):first-child").get(0)).text());
        Assert.assertEquals((long)2L, (long)doc.select("ul li ul li ul li ul li ul li:contains(Yaugher Volcanic Group 1)").size());
        Assert.assertEquals((long)2L, (long)doc.select("ul li ul li ul li ul li ul li:contains(Yaugher Volcanic Group 2)").size());
        Assert.assertEquals((long)3L, (long)doc.select("ul li ul li ul li ul li ul li:contains(-Py)").size());
        Assert.assertEquals((long)6L, (long)doc.select("ul li ul li ul li ul li span:contains(Composition Parts)").size());
        Assert.assertEquals((long)6L, (long)doc.select("ul li ul li ul li ul li ul li span:contains(Part)").size());
        Assert.assertEquals((long)6L, (long)doc.select("ul li ul li ul li ul li ul li span:contains(Role)").size());
        Assert.assertEquals((long)5L, (long)doc.select("ul li ul li ul li ul li ul li ul li ul li:contains(interbedded component)").size());
        Assert.assertEquals((long)1L, (long)doc.select("ul li ul li ul li ul li ul li ul li ul li:contains(fictitious component)").size());
    }
}

