/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.response;

import java.io.IOException;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.featurestemplating.configuration.SupportedFormat;
import org.geoserver.featurestemplating.response.TemplateComplexTestSupport;
import org.junit.Test;
import org.w3c.dom.Document;

public class GML2GetComplexFeatureTest
extends TemplateComplexTestSupport {
    private static final String MF_GML2 = "MappedFeatureGML2";
    private static final String MF_GML2_PARAM = "&MappedFeatureGML2=true";

    public void onSetUp(SystemTestData testData) throws IOException {
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo mappedFeature = catalog.getFeatureTypeByName("gsml", "MappedFeature");
        String templateMappedFeature = "MappedFeatureGML2.xml";
        this.setUpTemplate("requestParam('MappedFeatureGML2')='true'", SupportedFormat.GML, templateMappedFeature, MF_GML2, ".xml", "gsml", mappedFeature);
    }

    @Test
    public void getMappedFeature() throws IOException {
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.0.0&typename=gsml:MappedFeature&outputFormat=text%2Fxml%3B%20subtype%3Dgml%2F2.1.2&MappedFeatureGML2=true");
        this.assertXpathCount(5, "//gsml:MappedFeature", doc);
        this.assertXpathCount(5, "//gsml:samplingFrame//@xlink:href", doc);
        this.assertXpathCount(5, "//gsml:MappedFeature/gsml:geometry/gml:Polygon", doc);
        this.assertXpathCount(4, "//gsml:MappedFeature/gsml:specification/gsml:GeologicUnit", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature/gsml:specification/gsml:GeologicUnit/@xlink:title", doc);
        this.assertXpathEvaluatesTo("name_cc_5", "//gsml:MappedFeature[@gml:id='mf1']/gsml:specification/gsml:GeologicUnit/gsml:lithology", doc);
    }

    @Test
    public void testBackwardMappingOnFilterStaticAttribute() throws IOException {
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.0.0&typename=gsml:MappedFeature&outputFormat=text%2Fxml%3B%20subtype%3Dgml%2F2.1.2&cql_filter=wfs:FeatureCollection.gml:featureMember.gsml:MappedFeature.gsml:specification.gsml:GeologicUnit.xlink:title='a static xlink:title filtered'&MappedFeatureGML2=true");
        this.assertXpathCount(1, "//gsml:MappedFeature", doc);
    }
}

