/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.ows.wfs;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.featurestemplating.builders.EncodingHints;
import org.geoserver.featurestemplating.builders.impl.RootBuilder;
import org.geoserver.featurestemplating.configuration.TemplateIdentifier;
import org.geoserver.featurestemplating.configuration.TemplateLoader;
import org.geoserver.featurestemplating.ows.wfs.BaseTemplateGetFeatureResponse;
import org.geoserver.featurestemplating.writers.GeoJSONWriter;
import org.geoserver.featurestemplating.writers.TemplateOutputWriter;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.request.FeatureCollectionResponse;
import org.geotools.geometry.jts.ReferencedEnvelope;

public class GeoJSONTemplateGetFeatureResponse
extends BaseTemplateGetFeatureResponse {
    protected boolean hasGeometry;

    public GeoJSONTemplateGetFeatureResponse(GeoServer gs, TemplateLoader configuration, TemplateIdentifier identifier) {
        super(gs, configuration, identifier);
    }

    @Override
    protected void write(FeatureCollectionResponse featureCollection, OutputStream output, Operation getFeature) throws ServiceException {
        try (GeoJSONWriter writer = this.getOutputWriter(output);){
            EncodingHints encodingHints = new EncodingHints();
            writer.startTemplateOutput(encodingHints);
            this.iterateFeatureCollection((TemplateOutputWriter)writer, featureCollection);
            if (!EncodingHints.isSingleFeatureRequest() || !this.identifier.equals((Object)TemplateIdentifier.GEOJSON)) {
                writer.endArray(null, null);
            }
            this.writeAdditionalFields((TemplateOutputWriter)writer, featureCollection, getFeature);
            writer.endTemplateOutput(encodingHints);
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    protected GeoJSONWriter getOutputWriter(OutputStream output) throws IOException {
        return (GeoJSONWriter)this.helper.getOutputWriter(output);
    }

    @Override
    protected void beforeFeatureIteration(TemplateOutputWriter writer, RootBuilder root, FeatureTypeInfo typeInfo) {
        RootBuilder rb = root;
        GeoJSONWriter jsonWriter = (GeoJSONWriter)writer;
        boolean flatOutput = (Boolean)rb.getVendorOptions().get("flat_output", Boolean.class, (Object)false);
        jsonWriter.setFlatOutput(flatOutput);
    }

    public String getMimeType(Object value, Operation operation) throws ServiceException {
        return this.identifier.getOutputFormat();
    }

    @Override
    protected void writeAdditionalFieldsInternal(TemplateOutputWriter writer, FeatureCollectionResponse featureCollection, Operation getFeature, BigInteger featureCount, ReferencedEnvelope bounds) throws IOException {
        writer.writeCollectionCounts(featureCount);
        writer.writeTimeStamp();
        String previous = featureCollection.getPrevious();
        String next = featureCollection.getNext();
        if (next != null || previous != null) {
            ((GeoJSONWriter)writer).writePagingLinks(this.identifier.getOutputFormat(), previous, next);
        }
        writer.writeCrs();
        if (bounds != null) {
            writer.writeCollectionBounds(bounds);
        }
    }
}

