/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.response;

import java.io.IOException;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.featurestemplating.configuration.SupportedFormat;
import org.geoserver.featurestemplating.response.TemplateComplexTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;

public class JSONLDGetComplexFeaturesResponseWFSTest
extends TemplateComplexTestSupport {
    private static final String MF_JSON_LD_TEMPLATE = "MappedFeatureJSONLD";
    private static final String MF_JSON_LD_PARAM = "&MappedFeatureJSONLD=true";
    private static final String MF_JSON_LD_FILTERS = "MappedFeatureJSONLDFilters";
    private static final String MF_JSON_LD_FILTERS_PARAM = "&MappedFeatureJSONLDFilters=true";
    private static final String GU_JSON_LD_FILTERS = "GeologicFilterJSONLD";
    private static final String GU_JSON_LD_FILTERS_PARAM = "&GeologicFilterJSONLD=true";
    private static final String INVALID = "InvalidJSONLD";
    private static final String INVALID_PARAM = "&InvalidJSONLD=true";
    private static final String INVALID_GU = "InvalidJSONLDGu";
    private static final String INVALID_GU_PARAM = "&InvalidJSONLDGu=true";
    private static final String MF_JSON_LD_DEF_ENC = "MfJsonLdDefEncoding";
    private static final String MF_JSON_LD_DEF_ENC_PARAM = "&MfJsonLdDefEncoding=true";

    public void onSetUp(SystemTestData testData) throws IOException {
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo mappedFeature = catalog.getFeatureTypeByName("gsml", "MappedFeature");
        String templateMappedFeature = "MappedFeature.json";
        this.setUpTemplate("requestParam('MappedFeatureJSONLD')='true'", SupportedFormat.JSONLD, templateMappedFeature, MF_JSON_LD_TEMPLATE, ".json", "gsml", mappedFeature);
        String mappedFeatureFilter = "MappedFeatureIteratingAndCompositeFilter.json";
        this.setUpTemplate("requestParam('MappedFeatureJSONLDFilters')='true'", SupportedFormat.JSONLD, mappedFeatureFilter, MF_JSON_LD_FILTERS, ".json", "gsml", mappedFeature);
        String geologicUnitFilter = "GeologicUnitDynamicStaticFilter.json";
        FeatureTypeInfo geologic = this.getCatalog().getFeatureTypeByName("gsml", "GeologicUnit");
        this.setUpTemplate("requestParam('GeologicFilterJSONLD')='true'", SupportedFormat.JSONLD, geologicUnitFilter, GU_JSON_LD_FILTERS, ".json", "gsml", geologic);
        String invalid = "FirstParentFeature_invalid.json";
        FeatureTypeInfo parentF = this.getCatalog().getFeatureTypeByName("ex", "FirstParentFeature");
        this.setUpTemplate("requestParam('InvalidJSONLD')='true'", SupportedFormat.JSONLD, invalid, INVALID, ".json", "ex", parentF);
        String invalidGeologic = "GeologicUnit_invalid.json";
        this.setUpTemplate("requestParam('InvalidJSONLDGu')='true'", SupportedFormat.JSONLD, invalidGeologic, INVALID_GU, ".json", "gsml", geologic);
        String mappedFeatureDefEncoding = "MfJsonLdDefEncoding.json";
        this.setUpTemplate("requestParam('MfJsonLdDefEncoding')='true'", SupportedFormat.JSONLD, mappedFeatureDefEncoding, MF_JSON_LD_DEF_ENC, ".json", "gsml", mappedFeature);
    }

    @Test
    public void testJsonLdResponse() throws Exception {
        StringBuffer sb = new StringBuffer("wfs?request=GetFeature&version=2.0");
        sb.append("&TYPENAME=gsml:MappedFeature&outputFormat=");
        sb.append("application%2Fld%2Bjson").append(MF_JSON_LD_PARAM);
        JSONObject result = (JSONObject)this.getJsonLd(sb.toString());
        Object context = result.get("@context");
        this.checkContext(context);
        Assert.assertNotNull((Object)context);
        JSONArray features = (JSONArray)result.get("features");
        Assert.assertEquals((long)5L, (long)features.size());
        for (int i = 0; i < features.size(); ++i) {
            JSONObject feature = (JSONObject)features.get(i);
            this.checkMappedFeatureJSON(feature);
        }
    }

    @Test
    public void testJsonLdResponseWithoutTemplate() throws Exception {
        StringBuffer sb = new StringBuffer("wfs?request=GetFeature&version=2.0");
        sb.append("&TYPENAME=ex:SecondParentFeature&outputFormat=");
        sb.append("application%2Fld%2Bjson");
        MockHttpServletResponse response = this.getAsServletResponse(sb.toString());
        Assert.assertTrue((boolean)response.getContentAsString().contains("No template found for feature type"));
    }

    @Test
    public void testJsonLdQueryWithGET() throws Exception {
        StringBuilder sb = new StringBuilder("wfs?request=GetFeature&version=2.0").append("&TYPENAME=gsml:MappedFeature&outputFormat=").append("application%2Fld%2Bjson").append("&cql_filter=features.gsml:GeologicUnit.description = 'Olivine basalt'").append(MF_JSON_LD_PARAM);
        JSONObject result = (JSONObject)this.getJsonLd(sb.toString());
        Object context = result.get("@context");
        this.checkContext(context);
        Assert.assertNotNull((Object)context);
        JSONArray features = (JSONArray)result.get("features");
        Assert.assertEquals((long)1L, (long)features.size());
        Assert.assertEquals((Object)((JSONObject)features.get(0)).get("@id").toString(), (Object)"mf4");
    }

    @Test
    public void testJsonLdQueryPointingToExpr() throws Exception {
        StringBuilder sb = new StringBuilder("wfs?request=GetFeature&version=2.0").append("&TYPENAME=gsml:MappedFeature&outputFormat=").append("application%2Fld%2Bjson").append("&cql_filter= features.geometry.wkt IS NULL").append(MF_JSON_LD_PARAM);
        JSONObject result = (JSONObject)this.getJsonLd(sb.toString());
        Object context = result.get("@context");
        this.checkContext(context);
        Assert.assertNotNull((Object)context);
        JSONArray features = (JSONArray)result.get("features");
        Assert.assertEquals((long)0L, (long)features.size());
    }

    @Test
    public void testJsonLdQueryWithPOST() throws Exception {
        StringBuilder xml = new StringBuilder("<wfs:GetFeature ").append(" service=\"WFS\" ").append(" outputFormat=\"application/ld+json\" ").append(" version=\"1.0.0\" ").append(" xmlns:gsml=\"urn:cgi:xmlns:CGI:GeoSciML:2.0\" ").append(" xmlns:wfs=\"http://www.opengis.net/wfs\" ").append(" xmlns:ogc=\"http://www.opengis.net/ogc\" ").append(">").append(" <wfs:Query typeName=\"gsml:MappedFeature\">").append(" <ogc:Filter><ogc:PropertyIsEqualTo> ").append("<ogc:PropertyName>features.gsml:GeologicUnit.description</ogc:PropertyName>").append("<ogc:Literal>Olivine basalt</ogc:Literal>").append("</ogc:PropertyIsEqualTo></ogc:Filter></wfs:Query>").append("</wfs:GetFeature>");
        JSONObject result = (JSONObject)this.postJsonLd("wfs?&MappedFeatureJSONLD=true", xml.toString());
        Object context = result.get("@context");
        this.checkContext(context);
        Assert.assertNotNull((Object)context);
        JSONArray features = (JSONArray)result.get("features");
        Assert.assertEquals((long)1L, (long)features.size());
        Assert.assertEquals((Object)((JSONObject)features.get(0)).get("@id").toString(), (Object)"mf4");
    }

    @Test
    public void testInvalidTemplateResponse() throws Exception {
        StringBuilder sb = new StringBuilder("wfs?request=GetFeature&version=2.0");
        sb.append("&TYPENAME=ex:FirstParentFeature&outputFormat=");
        sb.append("application%2Fld%2Bjson").append(INVALID_PARAM);
        MockHttpServletResponse response = this.getAsServletResponse(sb.toString());
        Assert.assertTrue((boolean)response.getContentAsString().contains("Failed to validate template for feature type FirstParentFeature. Failing attribute is Key: @id Value: &amp;quot;invalid/id&amp;quot;"));
    }

    @Test
    public void testInvalidTemplateResponse2() throws Exception {
        StringBuffer sb = new StringBuffer("wfs?request=GetFeature&version=2.0");
        sb.append("&TYPENAME=gsml:GeologicUnit&outputFormat=");
        sb.append("application%2Fld%2Bjson").append(INVALID_GU_PARAM);
        MockHttpServletResponse resp = this.getAsServletResponse(sb.toString());
        Assert.assertTrue((boolean)resp.getContentAsString().contains("Failed to validate template for feature type GeologicUnit. Failing attribute is Key: invalidAttr Value: &amp;quot;gsml:notExisting&amp;quot;"));
    }

    @Test
    public void testJsonLdWithFilterOnIteratingAndComposite() throws Exception {
        StringBuilder sb = new StringBuilder("wfs?request=GetFeature&version=2.0").append("&TYPENAME=gsml:MappedFeature&outputFormat=").append("application%2Fld%2Bjson").append(MF_JSON_LD_FILTERS_PARAM);
        JSONObject result = (JSONObject)this.getJsonLd(sb.toString());
        Object context = result.get("@context");
        this.checkContext(context);
        Assert.assertNotNull((Object)context);
        JSONArray features = (JSONArray)result.get("features");
        int size = features.size();
        for (int i = 0; i < size; ++i) {
            JSONObject feature = features.getJSONObject(i);
            if (i + 1 != 4) {
                Assert.assertEquals((long)5L, (long)feature.size());
                Assert.assertNull((Object)feature.get("gsml:GeologicUnit"));
                continue;
            }
            Assert.assertEquals((long)6L, (long)feature.size());
            Object geologicUnit = feature.get("gsml:GeologicUnit");
            Assert.assertNotNull((Object)feature.get("gsml:GeologicUnit"));
            JSONArray lithologyAr = (JSONArray)((JSONObject)geologicUnit).getJSONArray("gsml:composition").getJSONObject(0).getJSONArray("gsml:compositionPart").getJSONObject(0).get("lithology");
            Assert.assertEquals((long)1L, (long)lithologyAr.size());
            JSONObject lithology = lithologyAr.getJSONObject(0);
            Assert.assertEquals((Object)"cc.2", (Object)lithology.getString("@id"));
            Assert.assertEquals((Object)"name_2", (Object)lithology.getJSONObject("name").getString("value"));
        }
    }

    @Test
    public void testJsonLdWithFilterOnStaticAndDynamic() throws Exception {
        StringBuilder sb = new StringBuilder("wfs?request=GetFeature&version=2.0").append("&TYPENAME=gsml:GeologicUnit&outputFormat=").append("application%2Fld%2Bjson").append(GU_JSON_LD_FILTERS_PARAM);
        JSONObject result = (JSONObject)this.getJsonLd(sb.toString());
        Object context = result.get("@context");
        this.checkContext(context);
        Assert.assertNotNull((Object)context);
        JSONArray features = (JSONArray)result.get("features");
        int size = features.size();
        Assert.assertEquals((long)3L, (long)size);
        for (int i = 0; i < size; ++i) {
            JSONObject geologicUnit = features.getJSONObject(i);
            Object description = geologicUnit.get("description");
            if (description != null) {
                Assert.assertEquals((Object)"Olivine basalt", (Object)description);
            }
            JSONArray composition = geologicUnit.getJSONArray("gsml:composition");
            for (int j = 0; j < composition.size(); ++j) {
                JSONArray compositionPart = (JSONArray)((JSONObject)composition.get(j)).get("gsml:compositionPart");
                Assert.assertTrue((compositionPart.size() > 0 ? 1 : 0) != 0);
                JSONObject role = compositionPart.getJSONObject(0).getJSONObject("gsml:role");
                Object codeSpace = role.get("@codeSpace");
                if (description == null) {
                    Assert.assertNull((Object)codeSpace);
                    continue;
                }
                Assert.assertNotNull((Object)codeSpace);
            }
        }
    }

    @Test
    public void testJsonLdNotEncodingArrayFilteredOut() throws Exception {
        StringBuilder sb = new StringBuilder("wfs?request=GetFeature&version=2.0").append("&TYPENAME=gsml:GeologicUnit&outputFormat=").append("application%2Fld%2Bjson").append(GU_JSON_LD_FILTERS_PARAM);
        JSONObject result = (JSONObject)this.getJsonLd(sb.toString());
        Object context = result.get("@context");
        this.checkContext(context);
        Assert.assertNotNull((Object)context);
        JSONArray features = (JSONArray)result.get("features");
        int size = features.size();
        Assert.assertEquals((long)3L, (long)size);
        for (int i = 0; i < size; ++i) {
            JSONArray composition = features.getJSONObject(i).getJSONArray("gsml:composition");
            for (int j = 0; j < composition.size(); ++j) {
                JSONArray compositionPart = (JSONArray)((JSONObject)composition.get(j)).get("gsml:compositionPart");
                for (int z = 0; z < compositionPart.size(); ++z) {
                    Assert.assertNull((Object)compositionPart.getJSONObject(z).get("lithology"));
                }
            }
        }
    }

    @Test
    public void testJsonLdResponseNonStringValues() throws Exception {
        StringBuffer sb = new StringBuffer("wfs?request=GetFeature&version=2.0");
        sb.append("&TYPENAME=gsml:MappedFeature&outputFormat=");
        sb.append("application%2Fld%2Bjson").append(MF_JSON_LD_DEF_ENC_PARAM);
        JSONObject result = (JSONObject)this.getJsonLd(sb.toString());
        Object context = result.get("@context");
        this.checkContext(context);
        Assert.assertNotNull((Object)context);
        JSONArray features = (JSONArray)result.get("features");
        Assert.assertEquals((long)5L, (long)features.size());
        JSONObject feature = features.getJSONObject(0);
        Assert.assertTrue((boolean)(feature.getJSONObject("gsml:positionalAccuracy").get("value") instanceof Double));
        Assert.assertTrue((boolean)(feature.getJSONObject("gsml:positionalAccuracy").getJSONArray("valueArray").get(0) instanceof Double));
        Object geom = feature.get("geometry");
        Assert.assertTrue((boolean)(geom instanceof JSONObject));
        JSONObject geomJSON = (JSONObject)geom;
        Object coors = geomJSON.get("coordinates");
        Assert.assertTrue((boolean)(coors instanceof JSONArray));
    }
}

