/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.response;

import com.google.common.base.Charsets;
import java.nio.charset.Charset;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.featurestemplating.configuration.SupportedFormat;
import org.geoserver.featurestemplating.response.TemplateTestHelper;
import org.geoserver.wms.WMSTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class GetFeatureInfoGroupTest
extends WMSTestSupport {
    private static final String FORESTS_GML_FEATUREINFO = "GMLFeatureInfoFORESTS";
    private static final String FORESTS_GML_PARAM = "&GMLFeatureInfoFORESTS=true";
    private static final String FORESTS_GEOJSON_FEATUREINFO = "GeoJSONFeatureInfoFORESTS";
    private static final String FORESTS_GEOJSON_PARAM = "&GeoJSONFeatureInfoFORESTS=true";
    private static final String FORESTS_JSONLD_FEATUREINFO = "JSONLDFeatureInfoFORESTS";
    private static final String FORESTS_JSONLD_PARAM = "&JSONLDFeatureInfoFORESTS=true";
    private static final String F_TEST_CONTEXT_JSONLD_FEATUREINFO = "JSONLDFORESTSSameContext";
    private static final String F_TEST_CONTEXT_JSONLD_PARAM = "&JSONLDFORESTSSameContext=true";
    private static final String FORESTS_HTML_FEATUREINFO = "HTMLFeatureInfoFORESTS";
    private static final String FORESTS_HTML_PARAM = "&HTMLFeatureInfoFORESTS=true";
    private static final String FORESTS_HTML_JSONLD_FEATUREINFO = "HTMLFeatureInfoJSONLDFORESTS";
    private static final String FORESTS_HTML_JSONLD_PARAM = "&HTMLFeatureInfoJSONLDFORESTS=true";
    private static final String LAKES_GML_FEATUREINFO = "GMLFeatureInfoLAKES";
    private static final String LAKES_GML_PARAM = "&GMLFeatureInfoLAKES=true";
    private static final String LAKES_GEOJSON_FEATUREINFO = "GeoJSONFeatureInfoLAKES";
    private static final String LAKES_GEOJSON_PARAM = "&GeoJSONFeatureInfoLAKES=true";
    private static final String LAKES_JSONLD_FEATUREINFO = "JSONLDFeatureInfoLAKES";
    private static final String LAKES_JSONLD_PARAM = "&JSONLDFeatureInfoLAKES=true";
    private static final String L_TEST_CONTEXT_JSONLD_FEATUREINFO = "JSONLDLAKESSameContext";
    private static final String L_TEST_CONTEXT_JSONLD_PARAM = "&JSONLDLAKESSameContext=true";
    private static final String LAKES_HTML_FEATUREINFO = "HTMLFeatureInfoLAKES";
    private static final String LAKES_HTML_PARAM = "&HTMLFeatureInfoLAKES=true";
    private static final String LAKES_HTML_JSONLD_FEATUREINFO = "HTMLJSONLDFeatureInfoLAKES";
    private static final String LAKES_HTML_JSONLD_PARAM = "&HTMLJSONLDFeatureInfoLAKES=true";
    private static final String GEOJSON_LAKE_TEMPLATE = "{\n   \"type\":\"Feature\",\n   \"id\":\"${@id}\",\n   \"geometry\":\"${the_geom}\",\n   \"properties\":{\n     \"name\":\"${NAME}\",\n     \"staticAttr\":\"I'm a lake\"\n   }\n}";
    private static final String GEOJSON_FOREST_TEMPLATE = "{\n   \"type\":\"Feature\",\n   \"id\":\"${@id}\",\n   \"geometry\":\"${the_geom}\",\n   \"properties\":{\n     \"name\":\"${NAME}\",\n     \"staticAttr\":\"I'm a forest\"\n   }\n}\n";
    private static final String JSONLD_LAKE_TEMPLATE = "{\n   \"$options\":{\n      \"@context\":[\n         \"https://geoserver/lake.org\",\n         {\n            \"sf\":\"http://www.opengis.net/ont/sf#\",\n            \"schema\":\"https://schema.org/\",\n            \"wkt\":\"gsp:asWKT\",\n            \"Feature\":\"gsp:Feature\",\n            \"geometry\":\"gsp:hasGeometry\",\n            \"polygon\":\"sf:polygon\",\n            \"features\":{\n               \"@container\":\"@set\",\n               \"@id\":\"schema:hasPart\"\n            }\n         }\n      ]\n   },\n   \"type\":\"Feature\",\n   \"id\":\"${@id}\",\n   \"geometry\":\"$${toWKT(the_geom)}\",\n   \"properties\":{\n      \"name\":\"${NAME}\",\n      \"staticAttr\":\"I'm a lake\"\n   }\n}";
    private static final String JSONLD_FOREST_TEMPLATE = "{  \n   \"$options\": {\n    \"@context\": \"https://geoserver/forest.org\"\n   },\n   \"type\":\"Feature\",\n   \"id\":\"${@id}\",\n   \"geometry\":\"$${toWKT(the_geom)}\",\n   \"properties\":{\n     \"name\":\"${NAME}\",\n     \"staticAttr\":\"I'm a forest\"\n   }\n}";
    private static final String JSONLD_L_TEST_CONTEXT_TEMPLATE = "{\n   \"$options\":{\n      \"@context\":{\n            \"sf\":\"http://www.opengis.net/ont/sf#\",\n            \"schema\":\"https://schema.org/\",\n            \"wkt\":\"gsp:asWKT\",\n            \"Feature\":\"gsp:Feature\",\n            \"geometry\":\"gsp:hasGeometry\",\n            \"polygon\":\"sf:polygon\",\n            \"features\":{\n               \"@container\":\"@set\",\n               \"@id\":\"schema:hasPart\"\n            }\n         }\n   },\n   \"type\":\"Feature\",\n   \"id\":\"${@id}\",\n   \"geometry\":\"$${toWKT(the_geom)}\",\n   \"properties\":{\n      \"name\":\"${NAME}\",\n      \"staticAttr\":\"I'm a lake\"\n   }\n}";
    private static final String JSONLD_F_TEST_CONTEXT_TEMPLATE = "{\n   \"$options\":{\n      \"@context\": {\n            \"sf\":\"http://www.opengis.net/ont/sf#\",\n            \"schema\":\"https://schema.org/\",\n            \"wkt\":\"gsp:asWKT\",\n            \"Feature\":\"gsp:Feature\",\n            \"geometry\":\"gsp:hasGeometry\",\n            \"polygon\":\"sf:polygon\"\n         }\n   },\n   \"type\":\"Feature\",\n   \"id\":\"${@id}\",\n   \"geometry\":\"$${toWKT(the_geom)}\",\n   \"properties\":{\n     \"name\":\"${NAME}\",\n     \"staticAttr\":\"I'm a forest\"\n   }\n}";
    private static final String GML_LAKES_TEMPLATE = "<gft:Template>\n        <gft:Options>\n         <gft:Namespaces xmlns:cite=\"http://www.opengis.net/cite\"/>\n         <gft:SchemaLocation xsi:schemaLocation=\"http://www.opengis.net/wfs http://localhost:8080/geoserver/schemas/wfs/1.0.0/WFS-basic.xsd http://www.opengis.net/cite http://localhost:8080/geoserver/wfs?service=WFS&amp;version=1.0.0&amp;request=DescribeFeatureType&amp;typeName=cite%3ALakes,cite%3AForests\"/>\n        </gft:Options>\n        <cite:Lakes fid=\"${@id}\">\n          <cite:the_geom>${the_geom}</cite:the_geom>\n          <cite:name>${NAME}</cite:name>\n          <cite:staticAttr>I'm a lake</cite:staticAttr>\n        </cite:Lakes>\n      </gft:Template>";
    private static final String GML_FOREST_TEMPLATE = "<gft:Template>\n        <gft:Options>\n         <gft:Namespaces xmlns:cite=\"http://www.opengis.net/cite\"/>\n         <gft:SchemaLocation xsi:schemaLocation=\"http://www.opengis.net/wfs http://localhost:8080/geoserver/schemas/wfs/1.0.0/WFS-basic.xsd http://www.opengis.net/cite http://localhost:8080/geoserver/wfs?service=WFS&amp;version=1.0.0&amp;request=DescribeFeatureType&amp;typeName=cite%3ALakes,cite%3AForests\"/>\n        </gft:Options>\n        <cite:Forests fid=\"${@id}\">\n          <cite:the_geom>${the_geom}</cite:the_geom>\n          <cite:name>${NAME}</cite:name>\n          <cite:staticAttr>I'm a forest</cite:staticAttr>\n        </cite:Forests>\n      </gft:Template>";
    private static final String HTML_LAKE_TEMPLATE = "<gft:Template>\n        <table class=\"featureInfo\">\n         <tr>\n            <th>fid</th>\n            <th>name</th>\n            <th>static attribute</th>\n         </tr>\n         <tr>\n            <td>${@id}</td>\n            <td>${NAME}</td>\n            <td>I'm a lake</td>\n         </tr>\n      </table>\n      </gft:Template>";
    private static final String HTML_FOREST_TEMPLATE = "<gft:Template>\n        <table class=\"featureInfo\">\n         <tr>\n            <th>fid</th>\n            <th>name</th>\n            <th>static attribute</th>\n         </tr>\n         <tr>\n            <td>${@id}</td>\n            <td>${NAME}</td>\n            <td>I'm a forest</td>\n         </tr>\n      </table>\n      </gft:Template>";
    private static final String HTML_LAKE_TEMPLATE_JSON_LD = "<gft:Template>\n        <gft:Options>          <script type=\"application/ld+json\"/>        </gft:Options>        <table class=\"featureInfo\">\n         <tr>\n            <th>fid</th>\n            <th>name</th>\n            <th>static attribute</th>\n         </tr>\n         <tr>\n            <td>${@id}</td>\n            <td>${NAME}</td>\n            <td>I'm a lake</td>\n         </tr>\n      </table>\n      </gft:Template>";
    private static final String HTML_FOREST_TEMPLATE_JSON_LD = "<gft:Template>\n        <gft:Options>          <script type=\"application/ld+json\"/>        </gft:Options>        <table class=\"featureInfo\">\n         <tr>\n            <th>fid</th>\n            <th>name</th>\n            <th>static attribute</th>\n         </tr>\n         <tr>\n            <td>${@id}</td>\n            <td>${NAME}</td>\n            <td>I'm a forest</td>\n         </tr>\n      </table>\n      </gft:Template>";

    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        TemplateTestHelper helper = new TemplateTestHelper();
        helper.setUpTemplate("requestParam('GeoJSONFeatureInfoFORESTS')='true'", SupportedFormat.GEOJSON, IOUtils.toInputStream((String)GEOJSON_FOREST_TEMPLATE, (Charset)Charsets.UTF_8), FORESTS_GEOJSON_FEATUREINFO, ".json", "cite", this.getCatalog().getFeatureTypeByName(MockData.FORESTS.getLocalPart()));
        helper.setUpTemplate("requestParam('GeoJSONFeatureInfoLAKES')='true'", SupportedFormat.GEOJSON, IOUtils.toInputStream((String)GEOJSON_LAKE_TEMPLATE, (Charset)Charsets.UTF_8), LAKES_GEOJSON_FEATUREINFO, ".json", "cite", this.getCatalog().getFeatureTypeByName(MockData.LAKES.getLocalPart()));
        helper.setUpTemplate("requestParam('JSONLDFeatureInfoFORESTS')='true'", SupportedFormat.JSONLD, IOUtils.toInputStream((String)JSONLD_FOREST_TEMPLATE, (Charset)Charsets.UTF_8), FORESTS_JSONLD_FEATUREINFO, ".json", "cite", this.getCatalog().getFeatureTypeByName(MockData.FORESTS.getLocalPart()));
        helper.setUpTemplate("requestParam('JSONLDFeatureInfoLAKES')='true'", SupportedFormat.JSONLD, IOUtils.toInputStream((String)JSONLD_LAKE_TEMPLATE, (Charset)Charsets.UTF_8), LAKES_JSONLD_FEATUREINFO, ".json", "cite", this.getCatalog().getFeatureTypeByName(MockData.LAKES.getLocalPart()));
        helper.setUpTemplate("requestParam('JSONLDFORESTSSameContext')='true'", SupportedFormat.JSONLD, IOUtils.toInputStream((String)JSONLD_F_TEST_CONTEXT_TEMPLATE, (Charset)Charsets.UTF_8), F_TEST_CONTEXT_JSONLD_FEATUREINFO, ".json", "cite", this.getCatalog().getFeatureTypeByName(MockData.FORESTS.getLocalPart()));
        helper.setUpTemplate("requestParam('JSONLDLAKESSameContext')='true'", SupportedFormat.JSONLD, IOUtils.toInputStream((String)JSONLD_L_TEST_CONTEXT_TEMPLATE, (Charset)Charsets.UTF_8), L_TEST_CONTEXT_JSONLD_FEATUREINFO, ".json", "cite", this.getCatalog().getFeatureTypeByName(MockData.LAKES.getLocalPart()));
        helper.setUpTemplate("requestParam('GMLFeatureInfoFORESTS')='true'", SupportedFormat.GML, IOUtils.toInputStream((String)GML_FOREST_TEMPLATE, (Charset)Charsets.UTF_8), FORESTS_GML_FEATUREINFO, ".xml", "cite", this.getCatalog().getFeatureTypeByName(MockData.FORESTS.getLocalPart()));
        helper.setUpTemplate("requestParam('GMLFeatureInfoLAKES')='true'", SupportedFormat.GML, IOUtils.toInputStream((String)GML_LAKES_TEMPLATE, (Charset)Charsets.UTF_8), LAKES_GML_FEATUREINFO, ".xml", "cite", this.getCatalog().getFeatureTypeByName(MockData.LAKES.getLocalPart()));
        helper.setUpTemplate("requestParam('HTMLFeatureInfoFORESTS')='true'", SupportedFormat.HTML, IOUtils.toInputStream((String)HTML_FOREST_TEMPLATE, (Charset)Charsets.UTF_8), FORESTS_HTML_FEATUREINFO, ".xhtml", "cite", this.getCatalog().getFeatureTypeByName(MockData.FORESTS.getLocalPart()));
        helper.setUpTemplate("requestParam('HTMLFeatureInfoLAKES')='true'", SupportedFormat.HTML, IOUtils.toInputStream((String)HTML_LAKE_TEMPLATE, (Charset)Charsets.UTF_8), LAKES_HTML_FEATUREINFO, ".xhtml", "cite", this.getCatalog().getFeatureTypeByName(MockData.LAKES.getLocalPart()));
        helper.setUpTemplate("requestParam('HTMLFeatureInfoJSONLDFORESTS')='true'", SupportedFormat.HTML, IOUtils.toInputStream((String)HTML_FOREST_TEMPLATE_JSON_LD, (Charset)Charsets.UTF_8), FORESTS_HTML_JSONLD_FEATUREINFO, ".xhtml", "cite", this.getCatalog().getFeatureTypeByName(MockData.FORESTS.getLocalPart()));
        helper.setUpTemplate("requestParam('HTMLJSONLDFeatureInfoLAKES')='true'", SupportedFormat.HTML, IOUtils.toInputStream((String)HTML_LAKE_TEMPLATE_JSON_LD, (Charset)Charsets.UTF_8), LAKES_HTML_JSONLD_FEATUREINFO, ".xhtml", "cite", this.getCatalog().getFeatureTypeByName(MockData.LAKES.getLocalPart()));
    }

    @Test
    public void testGeoJSON() throws Exception {
        String url = "wms?service=wms&version=1.1.1&layers=nature&width=100&height=100&format=image/png&srs=epsg:4326&bbox=-0.002,-0.003,0.005,0.002&info_format=application/json&request=GetFeatureInfo&query_layers=nature&x=50&y=50&feature_count=2&GeoJSONFeatureInfoFORESTS=true&GeoJSONFeatureInfoLAKES=true";
        JSONObject result = (JSONObject)this.getAsJSON(url);
        JSONArray array = result.getJSONArray("features");
        Assert.assertEquals((long)2L, (long)array.size());
        JSONObject lake = array.getJSONObject(0);
        JSONObject forest = array.getJSONObject(1);
        JSONObject lakeProps = lake.getJSONObject("properties");
        JSONObject forestsProps = forest.getJSONObject("properties");
        String lakeAttr = lakeProps.getString("staticAttr");
        String forestAttr = forestsProps.getString("staticAttr");
        Assert.assertEquals((Object)"I'm a lake", (Object)lakeAttr);
        Assert.assertEquals((Object)"I'm a forest", (Object)forestAttr);
    }

    @Test
    public void testJSONLD() throws Exception {
        String url = "wms?service=wms&version=1.1.1&layers=nature&width=100&height=100&format=image/png&srs=epsg:4326&bbox=-0.002,-0.003,0.005,0.002&info_format=application%2Fld%2Bjson&request=GetFeatureInfo&query_layers=nature&x=50&y=50&feature_count=2&JSONLDFeatureInfoFORESTS=true&JSONLDFeatureInfoLAKES=true";
        JSONObject result = (JSONObject)this.getAsJSON(url);
        JSONArray context = result.getJSONArray("@context");
        Assert.assertEquals((long)3L, (long)context.size());
        Assert.assertEquals((Object)"https://geoserver/lake.org", (Object)context.getString(0));
        Assert.assertNotNull((Object)context.getJSONObject(1));
        Assert.assertEquals((Object)"https://geoserver/forest.org", (Object)context.getString(2));
        JSONArray array = result.getJSONArray("features");
        Assert.assertEquals((long)2L, (long)array.size());
        JSONObject lake = array.getJSONObject(0);
        JSONObject forest = array.getJSONObject(1);
        JSONObject lakeProps = lake.getJSONObject("properties");
        JSONObject forestsProps = forest.getJSONObject("properties");
        String lakeAttr = lakeProps.getString("staticAttr");
        String forestAttr = forestsProps.getString("staticAttr");
        Assert.assertEquals((Object)"I'm a lake", (Object)lakeAttr);
        Assert.assertEquals((Object)"I'm a forest", (Object)forestAttr);
    }

    @Test
    public void testGML() throws Exception {
        String url = "wms?service=wms&version=1.1.1&layers=nature&width=100&height=100&format=image/png&srs=epsg:4326&bbox=-0.002,-0.003,0.005,0.002&info_format=text/xml; subtype=gml/3.1.1&request=GetFeatureInfo&query_layers=nature&x=50&y=50&feature_count=2&GMLFeatureInfoFORESTS=true&GMLFeatureInfoLAKES=true";
        Document dom = this.getAsDOM(url);
        NodeList nodes = dom.getElementsByTagName("cite:staticAttr");
        Assert.assertEquals((Object)"I'm a lake", (Object)nodes.item(0).getTextContent().trim());
        Assert.assertEquals((Object)"I'm a forest", (Object)nodes.item(1).getTextContent().trim());
    }

    @Test
    public void testHTML() throws Exception {
        String url = "wms?service=wms&version=1.1.1&layers=nature&width=100&height=100&format=image/png&srs=epsg:4326&bbox=-0.002,-0.003,0.005,0.002&info_format=text/html&request=GetFeatureInfo&query_layers=nature&x=50&y=50&feature_count=2&HTMLFeatureInfoLAKES=true&HTMLFeatureInfoFORESTS=true";
        String result = this.getAsString(url);
        Assert.assertTrue((boolean)result.trim().contains("<td>I'm a lake</td>"));
        Assert.assertTrue((boolean)result.trim().contains("<td>I'm a forest</td>"));
    }

    @Test
    public void testJSONLDObjectContextUnion() throws Exception {
        String url = "wms?service=wms&version=1.1.1&layers=nature&width=100&height=100&format=image/png&srs=epsg:4326&bbox=-0.002,-0.003,0.005,0.002&info_format=application%2Fld%2Bjson&request=GetFeatureInfo&query_layers=nature&x=50&y=50&feature_count=2&JSONLDFORESTSSameContext=true&JSONLDLAKESSameContext=true";
        JSONObject result = (JSONObject)this.getAsJSON(url);
        JSONObject context = result.getJSONObject("@context");
        Assert.assertEquals((long)7L, (long)context.size());
        Assert.assertTrue((boolean)context.has("features"));
        JSONArray array = result.getJSONArray("features");
        Assert.assertEquals((long)2L, (long)array.size());
        JSONObject lake = array.getJSONObject(0);
        JSONObject forest = array.getJSONObject(1);
        JSONObject lakeProps = lake.getJSONObject("properties");
        JSONObject forestsProps = forest.getJSONObject("properties");
        String lakeAttr = lakeProps.getString("staticAttr");
        String forestAttr = forestsProps.getString("staticAttr");
        Assert.assertEquals((Object)"I'm a lake", (Object)lakeAttr);
        Assert.assertEquals((Object)"I'm a forest", (Object)forestAttr);
    }

    @Test
    public void testGetFeatureInfoCoverageNotFails() throws Exception {
        String url = "wms?service=wms&version=1.1.1&layers=wcs:World&width=100&height=100&format=image/png&srs=epsg:4326&bbox=-180,-90,180,90&info_format=application/json&request=GetFeatureInfo&query_layers=wcs:World&x=50&y=50";
        JSONObject result = (JSONObject)this.getAsJSON(url);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)6L, (long)result.size());
    }

    @Test
    public void testHTMLWithJSONLD() throws Exception {
        String url = "wms?service=wms&version=1.1.1&layers=nature&width=100&height=100&format=image/png&srs=epsg:4326&bbox=-0.002,-0.003,0.005,0.002&info_format=text/html&request=GetFeatureInfo&query_layers=nature&x=50&y=50&feature_count=2&HTMLJSONLDFeatureInfoLAKES=true&HTMLFeatureInfoJSONLDFORESTS=true&JSONLDFeatureInfoLAKES=true&JSONLDFeatureInfoFORESTS=true";
        String result = this.getAsString(url);
        String trimmed = result.trim();
        Assert.assertTrue((boolean)trimmed.contains("@context"));
        Assert.assertTrue((boolean)trimmed.contains("\"staticAttr\":\"I'm a lake\""));
        Assert.assertTrue((boolean)trimmed.contains("\"staticAttr\":\"I'm a forest\""));
        Assert.assertTrue((boolean)trimmed.contains("<td>I'm a lake</td>"));
        Assert.assertTrue((boolean)trimmed.contains("<td>I'm a forest</td>"));
    }
}

