/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.response;

import java.io.IOException;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.geoserver.featurestemplating.response.GeoJSONGetSimpleFeaturesResponseTest;
import org.junit.Assert;
import org.junit.Test;

public class GeoJSONGetSimpleFeaturesResponseWFSTest
extends GeoJSONGetSimpleFeaturesResponseTest {
    protected void setUpSimple(String fileName) throws IOException {
        super.setUpSimple(fileName);
        this.getGeoServer().reset();
    }

    @Test
    public void testGeoJSONResponse() throws Exception {
        this.setUpSimple("NamedPlacesGeoJSON.json");
        StringBuilder sb = new StringBuilder("wfs?request=GetFeature&version=2.0");
        sb.append("&TYPENAME=cite:NamedPlaces&outputFormat=");
        sb.append("application/json");
        JSONObject result = (JSONObject)this.getJson(sb.toString());
        JSONArray features = (JSONArray)result.get("features");
        Assert.assertEquals((long)features.size(), (long)2L);
        for (int i = 0; i < features.size(); ++i) {
            this.checkFeature(features.getJSONObject(i));
        }
        this.checkAdditionalInfo(result);
    }

    @Test
    public void testGeoJSONQueryPointingToExpr() throws Exception {
        this.setUpSimple("NamedPlacesGeoJSON.json");
        StringBuilder sb = new StringBuilder("wfs?request=GetFeature&version=2.0").append("&TYPENAME=cite:NamedPlaces&outputFormat=").append("application/json").append("&cql_filter= features.name = 'Name: Goose Island' ");
        JSONObject result = (JSONObject)this.getJson(sb.toString());
        JSONArray features = (JSONArray)result.get("features");
        Assert.assertEquals((long)1L, (long)features.size());
        Assert.assertEquals((Object)features.getJSONObject(0).getString("name"), (Object)"Name: Goose Island");
        this.checkAdditionalInfo(result);
    }

    @Test
    public void testGeoJSONQueryPointingToSimpleAttribute() throws Exception {
        this.setUpSimple("NamedPlacesDifferentAttributesGeoJSON.json");
        StringBuilder sb = new StringBuilder("wfs?request=GetFeature&version=2.0").append("&TYPENAME=cite:NamedPlaces&outputFormat=").append("application/json").append("&cql_filter= NAME = 'Goose Island' ");
        JSONObject result = (JSONObject)this.getJson(sb.toString());
        JSONArray features = (JSONArray)result.get("features");
        Assert.assertEquals((long)1L, (long)features.size());
        Assert.assertEquals((Object)features.getJSONObject(0).getString("name_cod"), (Object)"Goose Island");
        this.checkAdditionalInfo(result);
    }

    @Test
    public void testGeoJSONResponseWithFilter() throws Exception {
        this.setUpSimple("NamedPlacesGeoJSON.json");
        StringBuilder path = new StringBuilder("wfs?request=GetFeature&version=2.0").append("&TYPENAME=cite:NamedPlaces").append("&outputFormat=application/json").append("&cql_filter= features.id = '118'");
        JSONObject result = (JSONObject)this.getJson(path.toString());
        JSONArray features = (JSONArray)result.get("features");
        Assert.assertEquals((long)features.size(), (long)1L);
        JSONObject feature = (JSONObject)features.get(0);
        Assert.assertEquals((Object)feature.getString("id"), (Object)"118");
        Assert.assertNotNull((String)feature.getString("name"), (Object)"Goose Island");
        JSONObject geometry = (JSONObject)feature.get("geometry");
        Assert.assertEquals((Object)geometry.getString("type"), (Object)"MultiPolygon");
        this.checkAdditionalInfo(result);
    }

    @Test
    public void testGeoJSONResponseDynamicKey() throws Exception {
        this.setUpSimple("NamedPlacesDynKeyGeoJSON.json");
        String url = "wfs?request=GetFeature&version=2.0&TYPENAME=cite:NamedPlaces&outputFormat=application/json&featureId=NamedPlaces.1107531895891";
        JSONObject result = (JSONObject)this.getJson(url);
        this.print((JSON)result);
        JSONArray features = (JSONArray)result.get("features");
        Assert.assertEquals((long)1L, (long)features.size());
        JSONObject feature = features.getJSONObject(0);
        Assert.assertNotNull((Object)feature.getString("id"));
        Assert.assertEquals((Object)"Name: Goose Island", (Object)feature.getString("Goose Island"));
    }

    @Test
    public void testGeoJSONResponseFilteredDynamicKey() throws Exception {
        this.setUpSimple("NamedPlacesDynKeyGeoJSON.json");
        String url = "wfs?request=GetFeature&version=2.0&TYPENAME=cite:NamedPlaces&outputFormat=application/json&CQL_FILTER=id=118";
        JSONObject result = (JSONObject)this.getJson(url);
        this.print((JSON)result);
        JSONArray features = (JSONArray)result.get("features");
        Assert.assertEquals((long)1L, (long)features.size());
        JSONObject feature = features.getJSONObject(0);
        Assert.assertNotNull((Object)feature.getString("id"));
        Assert.assertEquals((Object)"Name: Goose Island", (Object)feature.getString("Goose Island"));
    }
}

