/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.response;

import java.io.IOException;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.featurestemplating.configuration.SupportedFormat;
import org.geoserver.featurestemplating.response.TemplateComplexTestSupport;
import org.junit.Assert;
import org.junit.Test;

public class FlatGeoJSONComplexFeaturesResponseWFSTest
extends TemplateComplexTestSupport {
    private static final String FLAT_MF_TEMPLATE = "FlatMappedFeatureWFS";
    private static final String FLAT_MF_PARAM = "&FlatMappedFeatureWFS=true";
    private static final String FLAT_MF_TEMPLATE_FILTERED = "FlatFilteredMappedFeatureWFS";
    private static final String FLAT_MF_PARAM_FILTERED = "&FlatFilteredMappedFeatureWFS=true";

    public void onSetUp(SystemTestData testData) throws IOException {
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo mappedFeature = catalog.getFeatureTypeByName("gsml", "MappedFeature");
        String templateMappedFeature = "FlatGeoJSONMappedFeature.json";
        this.setUpTemplate("requestParam('FlatMappedFeatureWFS')='true'", SupportedFormat.GEOJSON, templateMappedFeature, FLAT_MF_TEMPLATE, ".json", "gsml", mappedFeature);
        String filteringFlat = "FilteringFlatGeoJSONMappedFeature.json";
        this.setUpTemplate("requestParam('FlatFilteredMappedFeatureWFS')='true'", SupportedFormat.GEOJSON, filteringFlat, FLAT_MF_TEMPLATE_FILTERED, ".json", "gsml", mappedFeature);
    }

    @Test
    public void testGeoJSONResponse() throws Exception {
        StringBuffer sb = new StringBuffer("wfs?request=GetFeature&version=2.0");
        sb.append("&TYPENAME=gsml:MappedFeature&outputFormat=");
        sb.append("application/json").append(FLAT_MF_PARAM);
        JSONObject result = (JSONObject)this.getJson(sb.toString());
        JSONArray features = (JSONArray)result.get("features");
        Assert.assertEquals((long)5L, (long)features.size());
        for (int i = 0; i < features.size(); ++i) {
            JSONObject feature = (JSONObject)features.get(i);
            this.checkInspireMappedFeature(feature);
        }
        this.checkAdditionalInfo(result);
    }

    @Test
    public void testGeoJSONQueryWithGET() throws Exception {
        StringBuilder sb = new StringBuilder("wfs?request=GetFeature&version=2.0").append("&TYPENAME=gsml:MappedFeature&outputFormat=").append("application/json").append("&cql_filter=features.properties.gsml:GeologicUnit_description = 'Olivine basalt'").append(FLAT_MF_PARAM);
        JSONObject result = (JSONObject)this.getJson(sb.toString());
        JSONArray features = (JSONArray)result.get("features");
        Assert.assertEquals((long)1L, (long)features.size());
        Assert.assertEquals((Object)((JSONObject)features.get(0)).get("@id").toString(), (Object)"mf4");
        this.checkInspireMappedFeature(features.getJSONObject(0));
        this.checkAdditionalInfo(result);
    }

    @Test
    public void testGeoJSONQueryPointingToExpr() throws Exception {
        StringBuilder sb = new StringBuilder("wfs?request=GetFeature&version=2.0").append("&TYPENAME=gsml:MappedFeature&outputFormat=").append("application/json").append("&cql_filter= features.properties.name = 'FeatureName: MURRADUC BASALT'").append(FLAT_MF_PARAM);
        JSONObject result = (JSONObject)this.getJson(sb.toString());
        JSONArray features = (JSONArray)result.get("features");
        Assert.assertEquals((long)1L, (long)features.size());
        JSONObject feature = features.getJSONObject(0);
        JSONObject properties = feature.getJSONObject("properties");
        Assert.assertEquals((Object)"FeatureName: MURRADUC BASALT", (Object)properties.getString("name"));
        this.checkInspireMappedFeature(feature);
        this.checkAdditionalInfo(result);
    }

    @Test
    public void testGeoJSONQueryWithPOST() throws Exception {
        StringBuilder xml = new StringBuilder("<wfs:GetFeature ").append(" service=\"WFS\" ").append(" outputFormat=\"application/json\" ").append(" version=\"1.0.0\" ").append(" xmlns:gsml=\"urn:cgi:xmlns:CGI:GeoSciML:2.0\" ").append(" xmlns:wfs=\"http://www.opengis.net/wfs\" ").append(" xmlns:ogc=\"http://www.opengis.net/ogc\" ").append(">").append(" <wfs:Query typeName=\"gsml:MappedFeature\">").append(" <ogc:Filter><ogc:PropertyIsEqualTo> ").append("<ogc:PropertyName>features.properties.gsml:GeologicUnit_description</ogc:PropertyName>").append("<ogc:Literal>Olivine basalt</ogc:Literal>").append("</ogc:PropertyIsEqualTo></ogc:Filter></wfs:Query>").append("</wfs:GetFeature>");
        JSONObject result = (JSONObject)this.postJson("wfs?FlatMappedFeatureWFS=true", xml.toString());
        JSONArray features = (JSONArray)result.get("features");
        Assert.assertEquals((long)1L, (long)features.size());
        Assert.assertEquals((Object)((JSONObject)features.get(0)).get("@id").toString(), (Object)"mf4");
        this.checkInspireMappedFeature(features.getJSONObject(0));
        this.checkAdditionalInfo(result);
    }

    @Test
    public void testFilteredArraysIndex() throws Exception {
        StringBuffer sb = new StringBuffer("wfs?request=GetFeature&version=2.0");
        sb.append("&TYPENAME=gsml:MappedFeature&outputFormat=");
        sb.append("application/json");
        sb.append(FLAT_MF_PARAM_FILTERED);
        JSONObject result = (JSONObject)this.getJson(sb.toString());
        JSONArray features = (JSONArray)result.get("features");
        Assert.assertEquals((long)5L, (long)features.size());
        for (int i = 0; i < features.size(); ++i) {
            JSONObject feature = (JSONObject)features.get(i);
            if (!feature.getString("@id").equals("mf4")) continue;
            JSONObject props = feature.getJSONObject("properties");
            String id = props.getString("gsml:GeologicUnit_gsml:composition_gsml:compositionPart_lithology_1_id");
            Assert.assertEquals((Object)"cc.2", (Object)id);
        }
    }
}

