/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.response;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.featurestemplating.configuration.SupportedFormat;
import org.geoserver.featurestemplating.response.TemplateComplexTestSupport;
import org.geoserver.test.AbstractAppSchemaMockData;
import org.geoserver.test.FeatureChainingMockData;
import org.junit.Test;
import org.w3c.dom.Document;

public class GMLComplexFeatureResponseAPITest
extends TemplateComplexTestSupport {
    private static final String MF_GML32_TEMPLATE = "MappedFeatureGML32";
    private static final String MF_GML32_PARAM = "&MappedFeatureGML32=true";

    public void onSetUp(SystemTestData testData) throws IOException {
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo mappedFeature = catalog.getFeatureTypeByName("gsml", "MappedFeature");
        String templateMappedFeature = "MappedFeatureGML32.xml";
        this.setUpTemplate("requestParam('MappedFeatureGML32')='true'", SupportedFormat.GML, templateMappedFeature, MF_GML32_TEMPLATE, ".xml", "gsml", mappedFeature);
    }

    @Test
    public void getMappedFeature() throws IOException {
        Document doc = this.getAsDOM("ogc/features/v1/collections/gsml:MappedFeature/items?f=application%2Fgml%2Bxml%3Bversion%3D3.2&&MappedFeatureGML32=true");
        this.assertXpathCount(5, "//gsml:MappedFeature", doc);
        this.assertXpathCount(5, "//gsml:samplingFrame//@xlink:href", doc);
        this.assertXpathCount(5, "//gsml:MappedFeature/gsml:geometry/gml:Surface", doc);
        this.assertXpathCount(4, "//gsml:MappedFeature/gsml:specification/gsml:GeologicUnit", doc);
        this.assertXpathCount(4, "//gsml:MappedFeature/gsml:specification/gsml:GeologicUnit/gml:description/@xlink:href", doc);
        this.assertXpathCount(4, "//gsml:MappedFeature/gsml:specification/gsml:GeologicUnit/gsml:staticContent", doc);
        this.assertXpathCount(4, "//gsml:MappedFeature/gsml:specification/gsml:GeologicUnit/gsml:staticContent/@xlink:title", doc);
        this.assertXpathCount(2, "//gsml:lithology", doc);
    }

    @Test
    public void getMappedFeatureBackwardsMappingToExpression() throws IOException {
        Document doc = this.getAsDOM("ogc/features/v1/collections/gsml:MappedFeature/items?filter-lang=cql-text&f=application%2Fgml%2Bxml%3Bversion%3D3.2&filter=wfs:FeatureCollection.wfs:member.gsml:MappedFeature.gml:name='mf.GUNTHORPE FORMATION'&&MappedFeatureGML32=true");
        this.assertXpathCount(1, "//gsml:MappedFeature", doc);
        this.assertXpathEvaluatesTo("mf1", "//gsml:MappedFeature/@gml:id", doc);
    }

    @Test
    public void getMappedFeatureBackwardsMappingPointingToExpression2() throws IOException {
        Document doc = this.getAsDOM("ogc/features/v1/collections/gsml:MappedFeature/items?f=application%2Fgml%2Bxml%3Bversion%3D3.2&filter=wfs:FeatureCollection.wfs:member.gsml:MappedFeature.gsml:specification.gsml:GeologicUnit.gsml:composition.gsml:CompositionPart.gsml:role='interbedded component'&&MappedFeatureGML32=true");
        this.assertXpathCount(3, "//gsml:MappedFeature", doc);
        this.assertXpathCount(0, "gsml:MappedFeature[@gml:id=mf1 or @gml:id=mf5]", doc);
    }

    @Test
    public void getMappedFeatureIdFilter() throws Exception {
        Document doc = this.getAsDOM("ogc/features/v1/collections/gsml:MappedFeature/items/mf1?f=application%2Fgml%2Bxml%3Bversion%3D3.2&&MappedFeatureGML32=true");
        this.assertXpathCount(1, "//gsml:MappedFeature", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature[@gml:id='mf1']", doc);
    }

    protected AbstractAppSchemaMockData createTestData() {
        return new FeatureChainingMockData(){

            public Map<String, String> getNamespaces() {
                HashMap<String, String> namespaces = new HashMap<String, String>();
                namespaces.put("gml", "http://www.opengis.net/gml/3.2");
                namespaces.put("wfs", "http://www.opengis.net/wfs/2.0");
                namespaces.put("gsml", "urn:cgi:xmlns:CGI:GeoSciML:2.0");
                namespaces.put("xlink", "http://www.w3.org/1999/xlink");
                return namespaces;
            }
        };
    }
}

