/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.validation;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.geoserver.featurestemplating.validation.JSONLDContextValidation;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class JSONLDContextValidationTest
extends GeoServerSystemTestSupport {
    @Rule
    public ExpectedException exceptionRule = ExpectedException.none();

    @Test
    public void testValidationSuccessFull() throws IOException {
        JSONLDContextValidation validator = new JSONLDContextValidation();
        File file = validator.init();
        FileUtils.copyURLToFile((URL)((Object)((Object)this)).getClass().getResource("json-ld-success-validation.json"), (File)file);
        validator.validate();
        Assert.assertEquals((long)0L, (long)validator.getFailedFields().size());
    }

    @Test
    public void testValidationFails() throws IOException {
        this.exceptionRule.expect(RuntimeException.class);
        this.exceptionRule.expectMessage("Validation failed. Unable to resolve the following fields against the @context: geologicUnitType,dataType,CGI_TermValue,nilReason.");
        JSONLDContextValidation validator = new JSONLDContextValidation();
        File file = validator.init();
        FileUtils.copyURLToFile((URL)((Object)((Object)this)).getClass().getResource("json-ld-failed-validation.json"), (File)file);
        validator.validate();
        Assert.assertEquals((long)0L, (long)validator.getFailedFields().size());
    }
}

