/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.response;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.featurestemplating.configuration.SupportedFormat;
import org.geoserver.featurestemplating.configuration.schema.SchemaFileManager;
import org.geoserver.featurestemplating.configuration.schema.SchemaInfo;
import org.geoserver.featurestemplating.configuration.schema.SchemaInfoDAO;
import org.geoserver.featurestemplating.configuration.schema.SchemaRule;
import org.geoserver.featurestemplating.configuration.schema.SchemaRuleService;
import org.geoserver.test.AbstractAppSchemaMockData;
import org.geoserver.test.AbstractAppSchemaTestSupport;
import org.geoserver.test.FeatureChainingMockData;

public abstract class SchemaComplexTestSupport
extends AbstractAppSchemaTestSupport {
    protected AbstractAppSchemaMockData createTestData() {
        return new FeatureChainingMockData();
    }

    protected void setUpSchemaOverride(String cqlRuleCondition, String profile, SupportedFormat outputFormat, String schemaFileName, String schemaName, String schemaExtension, String workspace, FeatureTypeInfo ft) throws IOException {
        String rawSchema = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream(schemaFileName), (Charset)Charsets.UTF_8);
        SchemaInfo info = new SchemaInfo();
        info.setExtension(schemaExtension);
        info.setSchemaName(schemaName);
        info.setWorkspace(workspace);
        info.setFeatureType(ft.getNativeName());
        SchemaInfoDAO.get().saveOrUpdate(info);
        SchemaFileManager.get().saveSchemaFile(info, rawSchema);
        SchemaRule rule = new SchemaRule();
        rule.setSchemaName(info.getFullName());
        rule.setCqlFilter(cqlRuleCondition);
        rule.setProfileFilter(profile);
        rule.setOutputFormat(outputFormat);
        rule.setSchemaIdentifier(info.getIdentifier());
        SchemaRuleService ruleService = new SchemaRuleService(ft);
        ruleService.saveRule(rule);
    }
}

