/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.expressions;

import javax.servlet.http.HttpServletRequest;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.factory.CommonFactoryFinder;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;

public class ServiceLinkFunctionTest {
    static final FilterFactory FF = CommonFactoryFinder.getFilterFactory();

    @BeforeClass
    public static void setDispatcherRequest() {
        MockHttpServletRequest req = new MockHttpServletRequest();
        req.setScheme("http");
        req.setServerPort(8080);
        req.setContextPath("/geoserver");
        Request request = new Request();
        request.setHttpRequest((HttpServletRequest)req);
        Dispatcher.REQUEST.set(request);
    }

    @AfterClass
    public static void clearDispatcherRequest() {
        Dispatcher.REQUEST.remove();
    }

    @Test
    public void testNoParams() {
        Function f = FF.function("serviceLink", new Expression[]{FF.literal((Object)"oseo/search")});
        String url = (String)f.evaluate(null, String.class);
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/oseo/search", (Object)url);
    }

    @Test
    public void testPathParams() {
        Function f = FF.function("serviceLink", new Expression[]{FF.literal((Object)"ogc/features/collections/%s/items/%s"), FF.literal((Object)"states"), FF.literal((Object)"states.1")});
        String url = (String)f.evaluate(null, String.class);
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/ogc/features/collections/states/items/states.1", (Object)url);
    }

    @Test
    public void testKvpParams() {
        Function f = FF.function("serviceLink", new Expression[]{FF.literal((Object)"ows?service=WFS&version=1.0.0&request=GetFeature&featureId=%s"), FF.literal((Object)"myType.1")});
        String url = (String)f.evaluate(null, String.class);
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/ows?service=WFS&version=1.0.0&request=GetFeature&featureId=myType.1", (Object)url);
    }
}

