/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.configuration;

import java.util.List;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.featurestemplating.configuration.TemplateInfo;
import org.geoserver.featurestemplating.configuration.TemplateInfoDAO;
import org.geoserver.featurestemplating.configuration.TemplateInfoDAOImpl;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.junit.Assert;
import org.junit.Test;

public class TemplateInfoDaoTest
extends GeoServerSystemTestSupport {
    @Test
    public void testSaveFindUpdateDelete() {
        TemplateInfoDAOImpl dao = TemplateInfoDAO.get();
        TemplateInfo info = new TemplateInfo();
        info.setTemplateName("template_name_json");
        info.setExtension("json");
        info.setWorkspace(MockData.CITE_PREFIX);
        dao.saveOrUpdate(info);
        TemplateInfo found = dao.findById(info.getIdentifier());
        Assert.assertEquals((Object)info, (Object)found);
        Assert.assertEquals((long)1L, (long)dao.findAll().size());
        found.setFeatureType(MockData.FIFTEEN.getLocalPart());
        dao.saveOrUpdate(found);
        Assert.assertEquals((Object)MockData.FIFTEEN.getLocalPart(), (Object)dao.findById(info.getIdentifier()).getFeatureType());
        dao.delete(found);
        Assert.assertEquals((long)0L, (long)dao.findAll().size());
    }

    @Test
    public void testFindFeatureTypeRelatedTemplateInfo() {
        TemplateInfoDAOImpl dao = TemplateInfoDAO.get();
        TemplateInfo info = new TemplateInfo();
        info.setTemplateName("template_name_json");
        info.setExtension("json");
        info.setWorkspace(MockData.CITE_PREFIX);
        dao.saveOrUpdate(info);
        info = new TemplateInfo();
        info.setTemplateName("template_name_xml");
        info.setExtension("xml");
        dao.saveOrUpdate(info);
        info = new TemplateInfo();
        info.setTemplateName("template_name_xml");
        info.setExtension("xml");
        info.setWorkspace(MockData.CDF_PREFIX);
        info.setFeatureType(MockData.FIFTEEN.getLocalPart());
        dao.saveOrUpdate(info);
        FeatureTypeInfo fti = this.getCatalog().getFeatureTypeByName(MockData.FIFTEEN.getLocalPart());
        List infos = dao.findByFeatureTypeInfo(fti);
        Assert.assertFalse((boolean)infos.stream().anyMatch(i -> i.getWorkspace() != null && i.getWorkspace().equals(MockData.CITE_PREFIX)));
    }
}

