/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.writers;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Attribute;
import org.apache.commons.lang.StringEscapeUtils;
import org.geoserver.featurestemplating.builders.EncodingHints;
import org.geoserver.featurestemplating.writers.JSONLDOutputHelper;
import org.geoserver.featurestemplating.writers.JSONLDWriter;
import org.geoserver.featurestemplating.writers.XMLTemplateWriter;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.geometry.jts.WKTWriter2;
import org.locationtech.jts.geom.Geometry;

public class XHTMLTemplateWriter
extends XMLTemplateWriter {
    private OutputStream output;

    public XHTMLTemplateWriter(XMLStreamWriter streamWriter, OutputStream outputStream) {
        super(streamWriter);
        this.output = outputStream;
    }

    @Override
    protected void writeGeometry(Geometry writeGeometry) throws XMLStreamException {
        WKTWriter2 wktWriter2 = new WKTWriter2();
        Object wktGeom = wktWriter2.write(writeGeometry);
        if (writeGeometry.getSRID() > 0) {
            wktGeom = "SRID=" + writeGeometry.getSRID() + ";" + (String)wktGeom;
        }
        this.streamWriter.writeCharacters((String)wktGeom);
    }

    @Override
    public void startTemplateOutput(EncodingHints encodingHints) throws IOException {
        try {
            List style;
            this.streamWriter.writeStartElement("html");
            this.streamWriter.writeStartElement("head");
            List script = encodingHints.get("script", List.class);
            if (script != null) {
                this.encodeHeadContent("script", script);
            }
            if ((style = encodingHints.get("style", List.class)) != null) {
                this.encodeHeadContent("style", style);
            }
            this.encodeLinks(encodingHints);
            this.injectJSONLD(encodingHints);
            this.streamWriter.writeEndElement();
            this.streamWriter.writeStartElement("body");
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private void injectJSONLD(EncodingHints encodingHints) throws ExecutionException, IOException, XMLStreamException {
        List<FeatureCollection> injectJSONLD = encodingHints.get("JSON_LD_SCRIPT", List.class, Collections.emptyList());
        if (!injectJSONLD.isEmpty()) {
            List<FeatureCollection> collections = injectJSONLD;
            JSONLDOutputHelper jsonldOutputHelper = new JSONLDOutputHelper();
            EncodingHints jsonLdHints = jsonldOutputHelper.optionsToEncodingHints(collections);
            this.streamWriter.writeStartElement("script");
            this.streamWriter.writeAttribute("type", "application/ld+json");
            this.streamWriter.writeCharacters("");
            this.streamWriter.flush();
            try (JSONLDWriter writer = this.getJSONLDWriter(this.output);){
                jsonldOutputHelper.write(collections, jsonLdHints, writer);
            }
            this.streamWriter.writeEndElement();
        }
    }

    private JSONLDWriter getJSONLDWriter(OutputStream output) throws IOException {
        JsonGenerator generator = new JsonFactory().createGenerator(output, JsonEncoding.UTF8);
        generator.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        return new JSONLDWriter(generator);
    }

    private void encodeHeadContent(String elementName, List contents) throws XMLStreamException {
        if (!contents.isEmpty()) {
            for (Object content : contents) {
                this.streamWriter.writeStartElement(elementName);
                if (content != null) {
                    this.streamWriter.writeCharacters(content.toString());
                }
                this.streamWriter.writeEndElement();
            }
        }
    }

    private void encodeLinks(EncodingHints encodingHints) throws XMLStreamException {
        if (encodingHints != null) {
            Set keys = encodingHints.keySet();
            for (String key : keys) {
                if (!key.startsWith("link")) continue;
                List linkAttrs = encodingHints.get(key, List.class);
                if (!linkAttrs.isEmpty()) {
                    this.streamWriter.writeStartElement("link");
                }
                for (Object o : linkAttrs) {
                    if (!(o instanceof Attribute)) continue;
                    Attribute attribute = (Attribute)o;
                    QName name = attribute.getName();
                    this.streamWriter.writeAttribute(name.getLocalPart(), attribute.getValue());
                }
                if (linkAttrs.isEmpty()) continue;
                this.streamWriter.writeEndElement();
            }
        }
    }

    @Override
    public void endTemplateOutput(EncodingHints encodingHints) throws IOException {
        try {
            this.streamWriter.writeEndElement();
            this.streamWriter.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected String escape(String value) {
        return StringEscapeUtils.escapeHtml((String)value);
    }

    @Override
    public void writeCollectionCounts(BigInteger featureCount) throws IOException {
    }

    @Override
    public void writeCrs() throws IOException {
    }

    @Override
    public void writeCollectionBounds(ReferencedEnvelope bounds) throws IOException {
    }

    @Override
    public void writeTimeStamp() throws IOException {
    }

    @Override
    public void writeNumberReturned() throws IOException {
    }
}

