/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.writers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.featurestemplating.builders.EncodingHints;
import org.geoserver.featurestemplating.builders.VendorOptions;
import org.geoserver.featurestemplating.builders.impl.RootBuilder;
import org.geoserver.featurestemplating.builders.impl.TemplateBuilderContext;
import org.geoserver.featurestemplating.configuration.TemplateIdentifier;
import org.geoserver.featurestemplating.configuration.TemplateLoader;
import org.geoserver.featurestemplating.utils.FeatureTypeInfoUtils;
import org.geoserver.featurestemplating.writers.JSONLDWriter;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.platform.GeoServerExtensions;
import org.geotools.api.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.util.logging.Logging;

public class JSONLDOutputHelper {
    private Catalog catalog = (Catalog)GeoServerExtensions.bean((String)"catalog");
    protected TemplateLoader loader = (TemplateLoader)GeoServerExtensions.bean(TemplateLoader.class);
    private static final Logger LOGGER = Logging.getLogger(JSONLDOutputHelper.class);

    public EncodingHints optionsToEncodingHints(List<FeatureCollection> collectionList) throws ExecutionException {
        EncodingHints encodingHints = new EncodingHints();
        ArrayList<JsonNode> allContexts = new ArrayList<JsonNode>();
        for (FeatureCollection collection : collectionList) {
            FeatureTypeInfo fti = FeatureTypeInfoUtils.getFeatureTypeInfo(this.catalog, collection);
            Request request = new Request((Request)Dispatcher.REQUEST.get());
            request.setOutputFormat(TemplateIdentifier.JSONLD.getOutputFormat());
            RootBuilder rootBuilder = this.loader.getTemplate(fti, request.getOutputFormat(), request);
            if (rootBuilder == null) continue;
            VendorOptions options = rootBuilder.getVendorOptions();
            JsonNode node = options.get("@context", JsonNode.class);
            if (node == null) {
                node = rootBuilder.getEncodingHints().get("@context", JsonNode.class);
            }
            if (node != null) {
                allContexts.add(node);
            }
            this.putEncodingHintIfAbsent(encodingHints, options, "@type", String.class);
            this.putEncodingHintIfAbsent(encodingHints, options, "collection_name", String.class);
        }
        JsonNode finalContext = this.nodesUnion(allContexts);
        encodingHints.put("@context", finalContext);
        return encodingHints;
    }

    protected RootBuilder getTemplate(FeatureTypeInfo fti) throws ExecutionException {
        return this.loader.getTemplate(fti, TemplateIdentifier.JSONLD.getOutputFormat());
    }

    private void putEncodingHintIfAbsent(EncodingHints encodingHints, VendorOptions options, String name, Class<?> targetType) {
        Object value;
        if (!encodingHints.hasHint(name) && (value = options.get(name, targetType)) != null) {
            encodingHints.put(name, value);
        }
    }

    private JsonNode nodesUnion(List<JsonNode> contexts) {
        JsonNode base = null;
        for (JsonNode node : contexts) {
            if (base == null) {
                base = node;
                continue;
            }
            base = this.nodesUnion(base, node);
        }
        return base;
    }

    private JsonNode nodesUnion(JsonNode node1, JsonNode node2) {
        JsonNode result = node1;
        if (!node1.equals((Object)node2)) {
            if (node1.isObject() && node2.isObject()) {
                ObjectNode copy = (ObjectNode)node1.deepCopy();
                copy.setAll((ObjectNode)node2);
                result = copy;
            } else if (node1.isArray() && node2.isArray()) {
                ArrayNode copy = (ArrayNode)node1.deepCopy();
                copy.addAll((ArrayNode)node2);
                result = copy;
            } else if (node2.isArray()) {
                ArrayNode copy = (ArrayNode)node2.deepCopy();
                copy.add(node1);
                result = copy;
            } else if (node1.isArray()) {
                ArrayNode copy = (ArrayNode)node1.deepCopy();
                copy.add(node2);
                result = copy;
            } else {
                ObjectMapper mapper = new ObjectMapper();
                ArrayNode arrayNode = mapper.createArrayNode();
                arrayNode.add(node1);
                arrayNode.add(node2);
                result = arrayNode;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(List<FeatureCollection> collections, EncodingHints hints, JSONLDWriter writer) throws IOException, ExecutionException {
        writer.startTemplateOutput(hints);
        for (FeatureCollection coll : collections) {
            FeatureTypeInfo fti = FeatureTypeInfoUtils.getFeatureTypeInfo(this.catalog, coll);
            Request request = new Request((Request)Dispatcher.REQUEST.get());
            request.setOutputFormat(TemplateIdentifier.JSONLD.getOutputFormat());
            RootBuilder root = this.loader.getTemplate(fti, request.getOutputFormat(), request);
            if (root == null) {
                String message = "Unable to find a JSON-LD template for type " + fti.prefixedName() + " throwing exception.";
                LOGGER.info(message);
                throw new RuntimeException(message);
            }
            try (FeatureIterator iterator = coll.features();){
                while (iterator.hasNext()) {
                    Feature feature = iterator.next();
                    TemplateBuilderContext context = new TemplateBuilderContext(feature);
                    root.evaluate(writer, context);
                }
            }
        }
        writer.endTemplateOutput(hints);
    }
}

