/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.writers;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.geoserver.featurestemplating.builders.EncodingHints;
import org.geoserver.featurestemplating.configuration.TemplateIdentifier;
import org.geoserver.featurestemplating.writers.CommonJSONWriter;
import org.geoserver.util.ISO8601Formatter;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;

public class GeoJSONWriter
extends CommonJSONWriter {
    public GeoJSONWriter(JsonGenerator generator, TemplateIdentifier identifier) {
        super(generator, identifier);
    }

    public GeoJSONWriter(JsonGenerator generator) {
        super(generator, TemplateIdentifier.JSON);
    }

    @Override
    public void endTemplateOutput(EncodingHints encodingHints) throws IOException {
        this.endObject(null, encodingHints);
    }

    public void writeLink(String href, String rel, String mimeType, String title, String method) throws IOException {
        if (href != null) {
            this.writeStartObject();
            if (title != null) {
                this.generator.writeFieldName("title");
                this.writeValue(title);
            }
            if (mimeType != null) {
                this.generator.writeFieldName("type");
                this.writeValue(mimeType);
            }
            if (rel != null) {
                this.generator.writeFieldName("rel");
                this.writeValue(rel);
            }
            if (method != null) {
                this.generator.writeFieldName("method");
                this.writeValue(method);
            }
            this.generator.writeFieldName("href");
            this.writeValue(href);
            this.writeEndObject();
        }
    }

    public void writePagingLinks(String mimeType, String previous, String next) throws IOException {
        this.generator.writeFieldName("links");
        this.writeStartArray();
        this.writeLink(previous, "previous", mimeType, "previous page", null);
        this.writeLink(next, "next", mimeType, "next page", null);
        this.writeEndArray();
    }

    @Override
    public void writeCollectionCounts(BigInteger featureCount) throws IOException {
        if (featureCount != null && featureCount.longValue() > 0L) {
            this.generator.writeFieldName("totalFeatures");
            this.writeValue(featureCount);
            this.generator.writeFieldName("numberMatched");
            this.writeValue(featureCount);
        } else {
            this.generator.writeFieldName("totalFeatures");
            this.writeValue("unknown");
        }
        this.writeNumberReturned();
    }

    @Override
    public void writeNumberReturned() throws IOException {
        this.generator.writeFieldName("numberReturned");
        this.writeValue(this.numberReturned);
    }

    @Override
    public void writeTimeStamp() throws IOException {
        this.generator.writeFieldName("timeStamp");
        this.writeValue(new ISO8601Formatter().format(new Date()));
    }

    @Override
    public void writeCrs() throws IOException {
        this.generator.writeFieldName("crs");
        if (this.crs != null) {
            String identifier = GeoJSONWriter.getCRSIdentifier(this.crs);
            this.writeStartObject();
            this.generator.writeFieldName("type");
            this.writeValue("name");
            this.generator.writeFieldName("properties");
            this.writeStartObject();
            this.generator.writeFieldName("name");
            this.writeValue(identifier);
            this.writeEndObject();
            this.writeEndObject();
        } else {
            this.generator.writeNull();
        }
    }

    @Override
    public void writeCollectionBounds(ReferencedEnvelope env) throws IOException {
        this.generator.writeFieldName("bbox");
        this.writeStartArray();
        if (this.axisOrder == CRS.AxisOrder.NORTH_EAST) {
            this.writeValue(env.getMinY());
            this.writeValue(env.getMinX());
            this.writeValue(env.getMaxY());
            this.writeValue(env.getMaxX());
        } else {
            this.writeValue(env.getMinX());
            this.writeValue(env.getMinY());
            this.writeValue(env.getMaxX());
            this.writeValue(env.getMaxY());
        }
        this.writeEndArray();
    }

    public void writeStaticContent(String key, Object staticContent, String separator) throws IOException {
        if (separator == null || staticContent instanceof String) {
            super.writeStaticContent(key, staticContent, null);
        } else {
            JsonNode jsonNode = (JsonNode)staticContent;
            if (jsonNode.isArray()) {
                this.writeArrayNodeFlat(key, jsonNode, separator);
            } else if (jsonNode.isObject()) {
                this.writeObjectNodeFlat(key, jsonNode, separator);
            } else {
                this.writeValueNode(key, jsonNode);
            }
        }
    }

    private void writeArrayNodeFlat(String nodeName, JsonNode arNode, String separator) throws IOException {
        Iterator arrayIterator = arNode.elements();
        int i = 1;
        while (arrayIterator.hasNext()) {
            JsonNode node = (JsonNode)arrayIterator.next();
            String arrayNodeName = nodeName + "_" + i;
            if (node.isValueNode()) {
                this.writeValueNode(arrayNodeName, node);
            } else if (node.isObject()) {
                this.writeObjectNodeFlat(arrayNodeName, node, separator);
            } else if (node.isArray()) {
                this.writeArrayNodeFlat(arrayNodeName, node, separator);
            }
            ++i;
        }
    }

    private void writeObjectNodeFlat(String superNodeName, JsonNode node, String separator) throws IOException {
        Iterator iterator = node.fields();
        while (iterator.hasNext()) {
            Map.Entry nodEntry = (Map.Entry)iterator.next();
            String entryName = (String)nodEntry.getKey();
            String newEntryName = entryName != null ? superNodeName + separator + entryName : null;
            JsonNode childNode = (JsonNode)nodEntry.getValue();
            if (childNode.isObject()) {
                this.writeObjectNodeFlat(newEntryName, childNode, separator);
                continue;
            }
            if (childNode.isValueNode()) {
                this.writeValueNode(newEntryName, childNode);
                continue;
            }
            this.writeArrayNodeFlat(newEntryName, childNode, separator);
        }
    }
}

