/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.writers;

import java.io.IOException;
import java.math.BigInteger;
import java.util.AbstractMap;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.geoserver.featurestemplating.builders.EncodingHints;
import org.geoserver.featurestemplating.configuration.TemplateIdentifier;
import org.geoserver.featurestemplating.writers.GML2DialectManager;
import org.geoserver.featurestemplating.writers.GML31DialectManager;
import org.geoserver.featurestemplating.writers.GML32DialectManager;
import org.geoserver.featurestemplating.writers.GMLDialectManager;
import org.geoserver.featurestemplating.writers.XMLTemplateWriter;
import org.geoserver.util.ISO8601Formatter;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Geometry;

public class GMLTemplateWriter
extends XMLTemplateWriter {
    private GMLDialectManager versionManager;
    private static final Map.Entry<String, String> XLINK_NS = new AbstractMap.SimpleEntry<String, String>("xlink", "http://www.w3.org/1999/xlink");
    private static final Map.Entry<String, String> XS_NS = new AbstractMap.SimpleEntry<String, String>("xs", "http://www.w3.org/2001/XMLSchema");
    private static final Map.Entry<String, String> XSI_NS = new AbstractMap.SimpleEntry<String, String>("xsi", "http://www.w3.org/2001/XMLSchema-instance");

    public GMLTemplateWriter(XMLStreamWriter streamWriter, String outputFormat) {
        super(streamWriter);
        TemplateIdentifier identifier = TemplateIdentifier.fromOutputFormat(outputFormat);
        switch (identifier) {
            case GML32: {
                this.versionManager = new GML32DialectManager(streamWriter);
                break;
            }
            case GML31: {
                this.versionManager = new GML31DialectManager(streamWriter);
                break;
            }
            case GML2: {
                this.versionManager = new GML2DialectManager(streamWriter);
            }
        }
    }

    @Override
    public void startTemplateOutput(EncodingHints encodingHints) throws IOException {
        try {
            this.streamWriter.writeStartDocument();
            this.streamWriter.writeStartElement("wfs", "FeatureCollection", (String)this.namespaces.get("wfs"));
            Set nsKeys = this.namespaces.keySet();
            for (String k : nsKeys) {
                this.streamWriter.writeNamespace(k, (String)this.namespaces.get(k));
            }
            if (this.schemaLocations != null) {
                this.streamWriter.writeAttribute("xsi:schemaLocation", this.schemaLocations);
            }
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void endTemplateOutput(EncodingHints encodingHints) throws IOException {
        try {
            this.streamWriter.writeEndElement();
            this.streamWriter.writeEndDocument();
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected void writeGeometry(Geometry writeGeometry) throws XMLStreamException {
        this.versionManager.writeGeometry(writeGeometry);
    }

    @Override
    public void writeNumberReturned() throws IOException {
        try {
            this.versionManager.writeNumberReturned(String.valueOf(this.numberReturned));
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeCollectionCounts(BigInteger featureCount) throws IOException {
        String stringValue = featureCount != null && featureCount.longValue() >= 0L ? String.valueOf(featureCount) : "unknown";
        try {
            this.versionManager.writeNumberMatched(stringValue);
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeCrs() throws IOException {
        try {
            this.streamWriter.writeAttribute("srsDimension", String.valueOf(this.crs.getCoordinateSystem().getDimension()));
            String crsIdentifier = GMLTemplateWriter.getCRSIdentifier(this.crs);
            this.streamWriter.writeAttribute("srsName", crsIdentifier);
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeCollectionBounds(ReferencedEnvelope envelope) throws IOException {
        this.versionManager.writeBoundingBox(envelope, this.crs);
    }

    @Override
    public void writeTimeStamp() throws IOException {
        try {
            this.streamWriter.writeAttribute("timeStamp", new ISO8601Formatter().format(new Date()));
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void addNamespaces(Map<String, String> namespaces) {
        super.addNamespaces(namespaces);
        this.namespaces.put(XLINK_NS.getKey(), XLINK_NS.getValue());
        this.namespaces.put(XS_NS.getKey(), XS_NS.getValue());
        this.namespaces.put(XSI_NS.getKey(), XSI_NS.getValue());
        this.namespaces.putAll(this.versionManager.getNamespaces());
    }

    @Override
    public void setCrs(CoordinateReferenceSystem crs) {
        super.setCrs(crs);
        this.versionManager.setCrs(crs);
    }

    @Override
    public void setAxisOrder(CRS.AxisOrder axisOrder) {
        super.setAxisOrder(axisOrder);
        this.versionManager.setAxisOrder(axisOrder);
    }

    public void startFeatureMember() throws IOException {
        try {
            this.versionManager.startFeatureMember();
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    public void endFeatureMember() throws IOException {
        try {
            this.versionManager.endFeatureMember();
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    public void setTypeName(String typeName) {
        this.versionManager.setTypeName(typeName);
    }
}

