/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.writers;

import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.geoserver.featurestemplating.writers.GMLDialectManager;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.ReferencedEnvelope;

class GML32DialectManager
extends GMLDialectManager {
    GML32DialectManager(XMLStreamWriter streamWriter) {
        super(streamWriter, "posList");
    }

    @Override
    void writeNumberReturned(String numberReturned) throws XMLStreamException {
        this.streamWriter.writeAttribute("numberReturned", String.valueOf(numberReturned));
    }

    @Override
    void writeNumberMatched(String numberMatched) throws XMLStreamException {
        this.streamWriter.writeAttribute("numberMatched", String.valueOf(numberMatched));
    }

    @Override
    void writeBoundingBox(ReferencedEnvelope envelope, CoordinateReferenceSystem crs) throws IOException {
        super.writeBoundingBox(envelope, crs, true);
    }

    @Override
    String getWfsNsUri() {
        return "http://www.opengis.net/wfs/2.0";
    }

    @Override
    String getGmlNsUri() {
        return "http://www.opengis.net/gml/3.2";
    }

    @Override
    void startFeatureMember() throws XMLStreamException {
        this.streamWriter.writeStartElement("wfs", "member", this.getWfsNsUri());
    }

    @Override
    void writeGeometryAttributes(int geometryIndex) throws XMLStreamException {
        super.writeGeometryAttributes(geometryIndex);
        if (this.crs != null) {
            this.streamWriter.writeAttribute("srsDimension", String.valueOf(this.crs.getCoordinateSystem().getDimension()));
        }
        StringBuilder id = new StringBuilder("");
        if (this.typeName != null) {
            id.append(this.typeName).append(".");
            id.append(this.currentFeatureNumber).append(".geom");
        }
        if (geometryIndex > 0) {
            id.append(".").append(geometryIndex);
        }
        if (!"".equals(id.toString())) {
            this.streamWriter.writeAttribute("gml", this.getGmlNsUri(), "id", id.toString());
        }
    }
}

