/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.writers;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.geoserver.featurestemplating.builders.EncodingHints;
import org.geoserver.featurestemplating.configuration.TemplateIdentifier;
import org.geoserver.featurestemplating.writers.TemplateOutputWriter;
import org.geoserver.util.ISO8601Formatter;
import org.geotools.api.feature.Attribute;
import org.geotools.api.feature.ComplexAttribute;
import org.geotools.data.geojson.GeoJSONWriter;
import org.geotools.util.Converters;
import org.locationtech.jts.geom.Geometry;

public abstract class CommonJSONWriter
extends TemplateOutputWriter {
    protected JsonGenerator generator;
    private boolean flatOutput;
    protected TemplateIdentifier identifier;

    public CommonJSONWriter(JsonGenerator generator, TemplateIdentifier templateIdentifier) {
        this.generator = generator;
        this.identifier = templateIdentifier;
    }

    @Override
    public void writeStaticContent(String key, Object staticContent, EncodingHints encodingHints) throws IOException {
        if (staticContent instanceof String || staticContent instanceof Number || staticContent instanceof Date) {
            if (key == null) {
                this.writeValue(staticContent);
            } else {
                this.generator.writeStringField(key, (String)staticContent);
            }
        } else {
            JsonNode jsonNode = (JsonNode)staticContent;
            if (jsonNode.isArray()) {
                this.writeArrayNode(key, jsonNode);
            } else if (jsonNode.isObject()) {
                this.writeObjectNode(key, jsonNode);
            } else {
                this.writeValueNode(key, jsonNode);
            }
        }
    }

    public void writeObjectNode(String nodeName, JsonNode node) throws IOException {
        if (nodeName != null && !nodeName.equals("")) {
            this.generator.writeFieldName(nodeName);
        }
        this.writeStartObject();
        Iterator iterator = node.fields();
        while (iterator.hasNext()) {
            Map.Entry nodEntry = (Map.Entry)iterator.next();
            String entryName = (String)nodEntry.getKey();
            JsonNode childNode = (JsonNode)nodEntry.getValue();
            if (childNode.isObject()) {
                this.writeObjectNode(entryName, childNode);
                continue;
            }
            if (childNode.isValueNode()) {
                this.writeValueNode(entryName, childNode);
                continue;
            }
            this.writeArrayNode(entryName, childNode);
        }
        this.writeEndObject();
    }

    public void writeArrayNode(String nodeName, JsonNode arNode) throws IOException {
        if (nodeName != null && !nodeName.equals("")) {
            this.generator.writeFieldName(nodeName);
        }
        this.writeStartArray();
        Iterator arrayIterator = arNode.elements();
        while (arrayIterator.hasNext()) {
            JsonNode node = (JsonNode)arrayIterator.next();
            if (node.isValueNode()) {
                this.writeValueNode(null, node);
                continue;
            }
            if (node.isObject()) {
                this.writeObjectNode(null, node);
                continue;
            }
            if (!node.isArray()) continue;
            this.writeArrayNode(null, node);
        }
        this.writeEndArray();
    }

    public void writeValueNode(String entryName, JsonNode valueNode) throws IOException {
        if (entryName != null && !entryName.equals("")) {
            this.generator.writeFieldName(entryName);
        }
        if (valueNode.isTextual()) {
            this.generator.writeString(valueNode.asText());
        } else if (valueNode.isFloat() || valueNode.isDouble()) {
            this.generator.writeNumber(valueNode.asDouble());
        } else if (valueNode.isLong()) {
            this.generator.writeNumber(valueNode.asLong());
        } else if (valueNode.isNumber()) {
            this.generator.writeNumber(valueNode.asInt());
        } else if (valueNode.isBoolean()) {
            this.generator.writeBoolean(valueNode.asBoolean());
        } else if (valueNode.isNull()) {
            this.generator.writeNull();
        }
    }

    public void writeValue(Object value) throws IOException {
        if (this.isNull(value)) {
            this.generator.writeNull();
        } else if (value instanceof String) {
            this.generator.writeString((String)value);
        } else if (value instanceof Integer) {
            this.generator.writeNumber(((Integer)value).intValue());
        } else if (value instanceof Double) {
            this.generator.writeNumber(((Double)value).doubleValue());
        } else if (value instanceof Float) {
            this.generator.writeNumber(((Float)value).floatValue());
        } else if (value instanceof Long) {
            this.generator.writeNumber(((Long)value).longValue());
        } else if (value instanceof BigInteger) {
            this.generator.writeNumber((BigInteger)value);
        } else if (value instanceof BigDecimal) {
            this.generator.writeNumber((BigDecimal)value);
        } else if (value instanceof Boolean) {
            this.generator.writeBoolean(((Boolean)value).booleanValue());
        } else if (value instanceof Date) {
            this.generator.writeString(new ISO8601Formatter().format(value));
        } else if (value.getClass().isArray()) {
            List list = (List)Converters.convert((Object)value, List.class);
            this.generator.writeStartArray();
            for (Object o : list) {
                this.writeValue(o);
            }
            this.generator.writeEndArray();
        } else if (value instanceof Geometry) {
            this.writeGeometry(value);
        } else {
            this.generator.writeString(value.toString());
        }
    }

    public void writeGeometry(Object value) throws IOException {
        JsonNode node = this.toJsonNode((Geometry)value);
        this.writeObjectNode(null, node);
    }

    protected JsonNode toJsonNode(Geometry geometry) throws JsonProcessingException {
        String jsonGeom = GeoJSONWriter.toGeoJSON((Geometry)geometry);
        ObjectMapper mapper = new ObjectMapper();
        return mapper.readTree(jsonGeom);
    }

    @Override
    public void writeElementName(Object elementName, EncodingHints encodingHints) throws IOException {
        if (elementName != null) {
            this.generator.writeFieldName(elementName.toString());
        }
    }

    @Override
    public void writeElementValue(Object result, EncodingHints encodingHints) throws IOException {
        this.writeElementNameAndValue(null, result, encodingHints);
    }

    @Override
    public void writeElementNameAndValue(String key, Object result, EncodingHints encodingHints) throws IOException {
        if (result instanceof String || result instanceof Number || result instanceof Boolean) {
            this.writeElementName(key, null);
            this.writeValue(result);
        } else if (result instanceof Date) {
            Date timeStamp = (Date)result;
            String formatted = new StdDateFormat().withColonInTimeZone(true).format(timeStamp);
            this.writeElementNameAndValue(key, formatted, encodingHints);
        } else if (result instanceof Geometry) {
            this.writeElementName(key, encodingHints);
            this.writeGeometry(result);
        } else if (result instanceof ComplexAttribute) {
            ComplexAttribute attr = (ComplexAttribute)result;
            this.writeElementNameAndValue(key, attr.getValue(), encodingHints);
        } else if (result instanceof Attribute) {
            Attribute attr = (Attribute)result;
            this.writeElementNameAndValue(key, attr.getValue(), encodingHints);
        } else if (result instanceof JsonNode) {
            this.writeStaticContent(key, result, encodingHints);
        } else if (result instanceof List) {
            this.writeList(key, (List)result, encodingHints, false);
        } else if (result == null) {
            this.writeElementName(key, encodingHints);
            this.generator.writeNull();
        } else if (result.getClass().isArray()) {
            List list = (List)Converters.convert((Object)result, List.class);
            this.writeList(key, list, encodingHints, true);
        } else {
            this.writeElementName(key, encodingHints);
            this.writeValue(result.toString());
        }
    }

    private void writeList(String key, List result, EncodingHints encodingHints, boolean forceArray) throws IOException {
        List list = result;
        if (list.size() == 1 && !forceArray) {
            this.writeElementNameAndValue(key, list.get(0), encodingHints);
        } else if (!this.flatOutput) {
            this.generator.writeFieldName(key);
            this.writeList(encodingHints, list);
        } else {
            for (int i = 0; i < list.size(); ++i) {
                String itKey = null;
                itKey = key + "_" + (i + 1);
                this.writeElementNameAndValue(itKey, list.get(i), encodingHints);
            }
        }
    }

    private void writeList(EncodingHints encodingHints, List list) throws IOException {
        this.writeStartArray();
        for (int i = 0; i < list.size(); ++i) {
            this.writeElementValue(list.get(i), encodingHints);
        }
        this.writeEndArray();
    }

    @Override
    public void startTemplateOutput(EncodingHints encodingHints) throws IOException {
        this.writeStartObject();
        this.generator.writeFieldName("type");
        this.generator.writeString("FeatureCollection");
        this.generator.writeFieldName("features");
        this.writeStartArray();
    }

    @Override
    public void endTemplateOutput(EncodingHints encodingHints) throws IOException {
        if (!EncodingHints.isSingleFeatureRequest()) {
            this.writeEndArray();
        }
        this.writeEndObject();
    }

    public void setFlatOutput(boolean flatOutput) {
        this.flatOutput = flatOutput;
    }

    @Override
    public void startObject(String name, EncodingHints encodingHints) throws IOException {
        if (name != null) {
            this.writeElementName(name, encodingHints);
        }
        this.writeStartObject();
    }

    @Override
    public void endObject(String name, EncodingHints encodingHints) throws IOException {
        this.writeEndObject();
    }

    @Override
    public void startArray(String name, EncodingHints encodingHints) throws IOException {
        this.writeElementName(name, encodingHints);
        this.writeStartArray();
    }

    @Override
    public void endArray(String name, EncodingHints encodingHints) throws IOException {
        this.writeEndArray();
    }

    public void writeStartArray() throws IOException {
        this.generator.writeStartArray();
    }

    public void writeEndArray() throws IOException {
        this.generator.writeEndArray();
    }

    public void writeStartObject() throws IOException {
        this.generator.writeStartObject();
    }

    public void writeEndObject() throws IOException {
        this.generator.writeEndObject();
    }

    @Override
    public void close() throws IOException {
        this.generator.close();
    }

    protected boolean skipObjectWriting(EncodingHints encodingHints) {
        Boolean skipIfSingleFeature = this.getEncodingHintIfPresent(encodingHints, "SKIP_OBJECT_ENCODING", Boolean.class);
        return skipIfSingleFeature != null && skipIfSingleFeature != false && EncodingHints.isSingleFeatureRequest() && (this.identifier.equals((Object)TemplateIdentifier.GEOJSON) || this.identifier.equals((Object)TemplateIdentifier.JSONLD));
    }
}

