/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.validation;

import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.JsonLdOptions;
import com.github.jsonldjava.core.JsonLdProcessor;
import com.github.jsonldjava.utils.JsonUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.ServiceException;

public class JSONLDContextValidation {
    File tmpFile;
    Set<String> failedFields = new HashSet<String>();

    public File init() throws IOException {
        GeoServerResourceLoader directory = (GeoServerResourceLoader)GeoServerExtensions.bean(GeoServerResourceLoader.class);
        this.tmpFile = new File(directory.getBaseDirectory(), "json-ld-validation.tmp");
        this.tmpFile.createNewFile();
        return this.tmpFile;
    }

    public void validate() {
        block11: {
            try {
                if (this.tmpFile == null) break block11;
                try (FileInputStream is = new FileInputStream(this.tmpFile);){
                    Object json = JsonUtils.fromInputStream((InputStream)is);
                    this.validate(json);
                }
            }
            catch (JsonLdError jsonLdError) {
                throw new ServiceException("Error while validating the json-ld output. Message is: " + jsonLdError.getMessage());
            }
            catch (Exception e) {
                throw new ServiceException((Throwable)e);
            }
            finally {
                this.tmpFile.delete();
            }
        }
    }

    public void validate(Object json) {
        Map jsonMap = (Map)json;
        JsonLdOptions options = new JsonLdOptions();
        Object context = jsonMap.get("@context");
        options.setExpandContext(context);
        options.setAllowContainerSetOnType(Boolean.valueOf(true));
        List expanded = JsonLdProcessor.expand((Object)json, (JsonLdOptions)options);
        if (expanded.size() == 0) {
            throw new RuntimeException("Validation failed. Unable to resolve the field features  against the @context");
        }
        Map compacted = JsonLdProcessor.compact((Object)expanded, context, (JsonLdOptions)options);
        this.checkJsonLdByKeys(json, compacted);
        if (this.failedFields.size() > 0) {
            Iterator<String> it = this.failedFields.iterator();
            StringBuilder sb = new StringBuilder();
            while (it.hasNext()) {
                sb.append(it.next());
                if (!it.hasNext()) continue;
                sb.append(",");
            }
            sb.append(". ");
            throw new ServiceException("Validation failed. Unable to resolve the following fields against the @context: " + sb.toString());
        }
    }

    private void checkJsonLdByKeys(Object original, Object compacted) {
        Map originalJsonLd = (Map)original;
        Map compactJsonLd = (Map)compacted;
        this.checkJsonLdLists(originalJsonLd.get("features"), compactJsonLd.get("features"));
    }

    private void checkJsonLdMaps(Object orig, Object compacted) {
        Map mapOrig = (Map)orig;
        Map mapCompact = (Map)compacted;
        Set keys = mapOrig.keySet();
        for (String key : keys) {
            Object origEl = mapOrig.get(key);
            Object compactEl = mapCompact.get(key);
            if (compactEl == null) {
                this.failedFields.add(key);
                continue;
            }
            if (!(origEl instanceof List)) {
                origEl = Arrays.asList(origEl);
            }
            if (!(compactEl instanceof List)) {
                compactEl = Arrays.asList(compactEl);
            }
            this.checkJsonLdLists(origEl, compactEl);
        }
    }

    private void checkJsonLdLists(Object orig, Object compacted) {
        List featuresOrig = (List)orig;
        List featuresCompact = (List)compacted;
        for (int i = 0; i < featuresOrig.size(); ++i) {
            Object fOrig = featuresOrig.get(i);
            Object fCompact = featuresCompact.get(i);
            if (fOrig instanceof Map) {
                this.checkJsonLdMaps(fOrig, fCompact);
                continue;
            }
            if (!(fOrig instanceof List)) continue;
            this.checkJsonLdLists(orig, compacted);
        }
    }

    public Set<String> getFailedFields() {
        return this.failedFields;
    }
}

