/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.request;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import org.geoserver.featurestemplating.builders.AbstractTemplateBuilder;
import org.geoserver.featurestemplating.builders.SourceBuilder;
import org.geoserver.featurestemplating.builders.TemplateBuilder;
import org.geoserver.featurestemplating.builders.impl.CompositeBuilder;
import org.geoserver.featurestemplating.builders.impl.DynamicIncludeFlatBuilder;
import org.geoserver.featurestemplating.builders.impl.DynamicValueBuilder;
import org.geoserver.featurestemplating.builders.impl.IteratingBuilder;
import org.geoserver.featurestemplating.builders.impl.RootBuilder;
import org.geoserver.featurestemplating.builders.impl.StaticBuilder;
import org.geoserver.featurestemplating.expressions.aggregate.StreamFunction;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.filter.AttributeExpressionImpl;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;

public class TemplatePathVisitor
extends DuplicatingFilterVisitor {
    protected int currentEl;
    protected Stack<String> currentSource = new Stack();
    private int contextPos = 0;
    boolean isSimple;
    private List<Filter> filters = new ArrayList<Filter>();

    public TemplatePathVisitor(FeatureType type) {
        this(type instanceof SimpleFeatureType);
    }

    TemplatePathVisitor(boolean isSimple) {
        this.isSimple = isSimple;
    }

    public Object visit(PropertyName expression, Object extraData) {
        TemplateBuilder builder;
        Expression newExpression;
        String propertyName = expression.getPropertyName();
        if (extraData instanceof TemplateBuilder && (newExpression = this.mapPropertyThroughBuilder(propertyName, builder = (TemplateBuilder)extraData)) != null) {
            return newExpression;
        }
        return this.getFactory(extraData).property(expression.getPropertyName(), expression.getNamespaceContext());
    }

    protected Expression mapPropertyThroughBuilder(String propertyName, TemplateBuilder builder) {
        String[] elements = propertyName.indexOf(".") != -1 ? propertyName.split("\\.") : propertyName.split("/");
        try {
            Expression newExpression;
            this.currentSource = new Stack();
            this.currentEl = 0;
            Expression expression = this.findFunction(builder, Arrays.asList(elements));
            if (expression != null && (newExpression = this.findXpathArg(expression)) != null) {
                return newExpression;
            }
        }
        catch (Throwable ex) {
            throw new RuntimeException("Unable to evaluate template path against the template. Cause: " + ex.getMessage());
        }
        return null;
    }

    private Expression findXpathArg(Expression expression) {
        PropertyNameCompleterVisitor completerVisitor = new PropertyNameCompleterVisitor();
        return (Expression)expression.accept((ExpressionVisitor)completerVisitor, null);
    }

    private Filter findXpathArg(Filter expression) {
        PropertyNameCompleterVisitor completerVisitor = new PropertyNameCompleterVisitor();
        return (Filter)expression.accept((FilterVisitor)completerVisitor, null);
    }

    public Expression findFunction(TemplateBuilder builder, List<String> pathElements) {
        TemplateBuilder jb;
        int lastElI = pathElements.size() - 1;
        String lastEl = pathElements.get(lastElI);
        char[] charArr = lastEl.toCharArray();
        int index = this.extractArrayIndexIfPresent(charArr);
        if (index != 0) {
            lastEl = String.valueOf(charArr);
            pathElements.set(lastElI, lastEl.substring(0, charArr.length - 1));
        }
        if ((jb = this.findBuilder(builder, pathElements)) != null) {
            if (jb instanceof IteratingBuilder && index != 0) {
                IteratingBuilder itb = (IteratingBuilder)jb;
                jb = this.getChildFromIterating(itb, index - 1);
            }
            if (jb instanceof DynamicValueBuilder) {
                DynamicValueBuilder dvb = (DynamicValueBuilder)jb;
                this.addFilter(dvb.getFilter());
                this.contextPos = dvb.getContextPos();
                if (dvb.getXpath() != null) {
                    return (PropertyName)super.visit((PropertyName)dvb.getXpath(), null);
                }
                return super.visit(dvb.getCql(), null);
            }
            if (jb instanceof StaticBuilder) {
                Literal retExpr;
                StaticBuilder staticBuilder = (StaticBuilder)jb;
                this.addFilter(staticBuilder.getFilter());
                if (staticBuilder.getStaticValue() != null) {
                    JsonNode staticNode = staticBuilder.getStaticValue();
                    while (this.currentEl < pathElements.size()) {
                        JsonNode child = staticNode.get(pathElements.get(this.currentEl - 1));
                        staticNode = child != null ? child : staticNode;
                        ++this.currentEl;
                    }
                    retExpr = this.ff.literal((Object)staticNode.asText());
                } else {
                    retExpr = this.ff.literal((Object)staticBuilder.getStrValue());
                }
                return retExpr;
            }
        }
        return null;
    }

    private int extractArrayIndexIfPresent(char[] charArr) {
        int lastIdx = charArr.length - 1;
        char lastElem = charArr[lastIdx];
        if (Character.isDigit(lastElem)) {
            return Character.getNumericValue(lastElem);
        }
        return 0;
    }

    private TemplateBuilder findBuilder(TemplateBuilder parent, List<String> pathElements) {
        List<TemplateBuilder> children = parent.getChildren();
        int length = pathElements.size();
        if (children != null) {
            for (TemplateBuilder tb : children) {
                boolean isLastEl;
                String key = ((AbstractTemplateBuilder)tb).getKey(null);
                if (tb instanceof DynamicIncludeFlatBuilder) {
                    tb = ((DynamicIncludeFlatBuilder)tb).getIncludingNodeBuilder(null);
                }
                if (!this.matchBuilder(tb, key, pathElements, parent)) continue;
                boolean bl = isLastEl = this.currentEl == length;
                if (isLastEl || tb instanceof StaticBuilder) {
                    return tb;
                }
                if (!(tb instanceof SourceBuilder)) continue;
                this.pickSourceAndFilter((SourceBuilder)tb);
                TemplateBuilder result = this.findBuilder(tb, pathElements);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    private TemplateBuilder getChildFromIterating(IteratingBuilder itb, int position) {
        List<TemplateBuilder> children = itb.getChildren();
        if (position < children.size()) {
            return children.get(position);
        }
        return null;
    }

    private boolean keyMatched(TemplateBuilder jb, String key, List<String> pathElements) {
        boolean keyMatchedOtherBuilder;
        boolean allowNullKey = jb instanceof CompositeBuilder && key == null;
        boolean bl = keyMatchedOtherBuilder = key != null && key.equals(pathElements.get(this.currentEl));
        if (keyMatchedOtherBuilder) {
            ++this.currentEl;
        }
        return allowNullKey || keyMatchedOtherBuilder;
    }

    private void pickSourceAndFilter(SourceBuilder sb) {
        String source = sb.getStrSource();
        if (source != null) {
            if (source.indexOf(".") != -1) {
                source = source.replace(".", "/");
            }
            this.currentSource.add(source);
        }
        this.addFilter(sb.getFilter());
    }

    private void addFilter(Filter filter) {
        if (filter != null) {
            filter = this.findXpathArg(filter);
            this.filters.add(filter);
        }
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    private boolean matchBuilder(TemplateBuilder current, String key, List<String> pathElements, TemplateBuilder parent) {
        boolean result = this.keyMatched(current, key, pathElements);
        if (!result) {
            if (parent instanceof RootBuilder) {
                result = true;
            } else if (parent instanceof SourceBuilder && !((SourceBuilder)parent).hasOwnOutput()) {
                result = true;
            }
        }
        return result;
    }

    private class PropertyNameCompleterVisitor
    extends DuplicatingFilterVisitor {
        private PropertyNameCompleterVisitor() {
        }

        public Object visit(PropertyName filter, Object extraData) {
            if ((filter = (PropertyName)super.visit(filter, extraData)) instanceof AttributeExpressionImpl) {
                AttributeExpressionImpl pn = (AttributeExpressionImpl)filter;
                String property = this.canCompleteXpath(extraData) ? this.completeXPath(pn.getPropertyName()) : pn.getPropertyName();
                pn.setPropertyName(property);
                filter = pn;
            }
            return filter;
        }

        private String completeXPath(String xpath) {
            if (!TemplatePathVisitor.this.currentSource.isEmpty() && !TemplatePathVisitor.this.isSimple) {
                Stack<String> sourceParts = new Stack<String>();
                sourceParts.addAll(TemplatePathVisitor.this.currentSource);
                xpath = this.completeXpath(sourceParts, xpath);
            }
            return xpath;
        }

        private boolean canCompleteXpath(Object extradata) {
            return extradata == null || extradata instanceof Boolean && (Boolean)extradata != false;
        }

        private String completeXpath(Stack<String> source, String xpath) {
            String result = null;
            int ctxPos = TemplatePathVisitor.this.contextPos;
            while (!source.isEmpty()) {
                String sourcePart = source.pop();
                if (ctxPos <= 0) {
                    result = result == null ? sourcePart.concat("/") : sourcePart.concat("/").concat(result);
                }
                --ctxPos;
            }
            result = result == null ? xpath : result.concat(xpath);
            return result;
        }

        public Object visit(Function expression, Object extraData) {
            if (expression instanceof StreamFunction) {
                StreamFunction streamFunction = (StreamFunction)expression;
                List expressions = streamFunction.getParameters();
                int size = expressions.size();
                int pnCounter = 0;
                for (int i = 0; i < size; ++i) {
                    Expression e = (Expression)expressions.get(i);
                    if (e instanceof PropertyName) {
                        e = (Expression)this.visit((PropertyName)e, (Object)(pnCounter == 0 ? 1 : 0));
                        ++pnCounter;
                    } else {
                        e = this.visit(e, extraData);
                    }
                    expressions.set(i, e);
                }
                return expression;
            }
            return super.visit(expression, extraData);
        }
    }
}

