/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.readers;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.geoserver.featurestemplating.builders.SourceBuilder;
import org.geoserver.featurestemplating.builders.TemplateBuilder;
import org.geoserver.featurestemplating.builders.TemplateBuilderMaker;
import org.geoserver.featurestemplating.builders.impl.RootBuilder;
import org.geoserver.featurestemplating.readers.RecursiveTemplateResourceParser;
import org.geoserver.featurestemplating.readers.TemplateReader;
import org.geoserver.platform.resource.Resource;
import org.xml.sax.helpers.NamespaceSupport;

public abstract class XMLRecursiveTemplateReader
extends RecursiveTemplateResourceParser
implements TemplateReader,
AutoCloseable {
    protected TemplateBuilderMaker maker;
    protected Stack<StartElement> elementsStack;
    protected NamespaceSupport namespaceSupport;
    private InputStream inputSource;
    protected XMLEventReader reader;
    private static final String COLLECTION_ATTR = "gft:isCollection";
    private static final String FILTER_ATTR = "gft:filter";
    private static final String SOURCE_ATTR = "gft:source";
    private static final String TEMPLATE_ELEMENT = "gft:Template";
    protected static final String VENDOR_OPTIONS_EL = "gft:Options";
    private static final String INCLUDE_FLAT = "gft:includeFlat";
    private static final String INCLUDE = "$include";

    public XMLRecursiveTemplateReader(Resource resource, NamespaceSupport namespaceSupport) throws IOException {
        super(resource);
        this.resource = resource;
        this.elementsStack = new Stack();
        this.maker = new TemplateBuilderMaker();
        this.namespaceSupport = namespaceSupport;
        try {
            this.reader = this.getEventReader(resource);
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    public XMLRecursiveTemplateReader(Resource resource, XMLRecursiveTemplateReader parent, NamespaceSupport namespaceSupport) throws IOException {
        super(resource, parent);
        this.elementsStack = new Stack();
        this.maker = new TemplateBuilderMaker();
        this.namespaceSupport = namespaceSupport;
        try {
            this.reader = this.getEventReader(resource);
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    @Override
    public RootBuilder getRootBuilder() {
        RootBuilder rootBuilder = new RootBuilder();
        try {
            this.iterateReader(rootBuilder);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.close();
        }
        rootBuilder.setWatchers(this.getWatchers());
        return rootBuilder;
    }

    public void iterateReader(TemplateBuilder builder) throws IOException {
        try {
            while (this.reader.hasNext()) {
                XMLEvent event = this.reader.nextEvent();
                if (event.isStartElement()) {
                    this.handleStartElement(event.asStartElement(), builder);
                    continue;
                }
                if (event.isCharacters()) {
                    Characters characters = event.asCharacters();
                    if (!this.canParseTextContent(characters)) continue;
                    this.templateBuilderFromCharacterElement(event.asCharacters(), builder);
                    continue;
                }
                if (!event.isEndElement()) continue;
                EndElement endElement = event.asEndElement();
                boolean stopIteration = this.elementsStack.isEmpty();
                while (!this.elementsStack.isEmpty()) {
                    this.templateBuilderFromElement(this.elementsStack.pop(), builder, true);
                }
                if (endElement.getName().toString().equals(INCLUDE_FLAT) || !stopIteration) continue;
                break;
            }
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    private void templateBuilderFromCharacterElement(Characters characters, TemplateBuilder currentParent) throws IOException {
        String data = characters.getData();
        StartElement element = this.elementsStack.pop();
        if (element.getName().toString().equals(INCLUDE_FLAT)) {
            this.builderFromIncludedTemplate(this.resource, data, currentParent);
        } else if (data.startsWith("$include{") && data.endsWith("}")) {
            String path = data.substring(INCLUDE.length() + 1, data.length() - 1);
            TemplateBuilder parentForIncluded = this.templateBuilderFromElement(element, currentParent, false);
            this.builderFromIncludedTemplate(this.resource, path, parentForIncluded);
        } else {
            TemplateBuilder leafBuilder = this.getAttributeValueIfPresent(element, COLLECTION_ATTR) != null ? this.createLeaf(data, null) : this.createLeaf(data, element);
            currentParent.addChild(leafBuilder);
            this.addAttributeAsChildrenBuilder(element.getAttributes(), leafBuilder);
            this.iterateReader(currentParent);
        }
    }

    protected void handleStartElement(StartElement startElement, TemplateBuilder currentParent) throws IOException {
        if (startElement.getName().toString().equals(INCLUDE_FLAT)) {
            currentParent = this.getBuilderFromLastElInStack(currentParent);
            this.elementsStack.add(startElement);
            String data = this.getAttributeValueIfPresent(startElement, SOURCE_ATTR);
            if (data != null) {
                this.builderFromIncludedTemplate(this.resource, data, currentParent);
            } else {
                this.iterateReader(currentParent);
            }
        } else if (!this.elementsStack.isEmpty()) {
            currentParent = this.getBuilderFromLastElInStack(currentParent);
            this.elementsStack.add(startElement);
            this.iterateReader(currentParent);
        } else if (startElement.getName().toString().equals(VENDOR_OPTIONS_EL)) {
            this.iterateVendorOptionsElement(currentParent);
        } else if (!startElement.getName().toString().equals(TEMPLATE_ELEMENT)) {
            this.elementsStack.add(startElement);
        }
    }

    private TemplateBuilder getBuilderFromLastElInStack(TemplateBuilder currentParent) {
        StartElement previous;
        StartElement startElement = previous = !this.elementsStack.isEmpty() ? this.elementsStack.pop() : null;
        if (previous != null) {
            currentParent = this.templateBuilderFromElement(previous, currentParent, false);
        }
        return currentParent;
    }

    private TemplateBuilder templateBuilderFromElement(StartElement startElement, TemplateBuilder currentParent, boolean emptyNode) {
        if (startElement != null) {
            String isCollection = this.getAttributeValueIfPresent(startElement, COLLECTION_ATTR);
            String stringName = startElement.getName().toString();
            boolean collection = isCollection != null && Boolean.valueOf(isCollection) != false;
            boolean hasOwnOutput = this.hasOwnOutput(stringName);
            this.maker.collection(collection).name(stringName).namespaces(this.namespaceSupport).filter(this.getAttributeValueIfPresent(startElement, FILTER_ATTR)).source(this.getAttributeValueIfPresent(startElement, SOURCE_ATTR)).hasOwnOutput(hasOwnOutput).topLevelFeature(this.isRootOrManaged(currentParent));
            if (emptyNode) {
                this.maker.textContent("");
            }
            if (collection) {
                this.maker.encodingOption("INTERATE_KEY", "true");
            }
            TemplateBuilder parentBuilder = this.maker.build();
            Iterator<Attribute> attributeIterator = startElement.getAttributes();
            this.addAttributeAsChildrenBuilder(attributeIterator, parentBuilder);
            currentParent.addChild(parentBuilder);
            currentParent = parentBuilder;
        }
        return currentParent;
    }

    private TemplateBuilder createLeaf(String data, StartElement startElement) {
        this.maker.namespaces(this.namespaceSupport);
        if (startElement != null) {
            this.maker.name(this.strName(startElement.getName()));
            String filter = this.getAttributeValueIfPresent(startElement, FILTER_ATTR);
            if (filter == null) {
                this.maker.contentAndFilter(data);
            } else {
                this.maker.filter(filter).textContent(data);
            }
        }
        TemplateBuilder builder = this.maker.build();
        return builder;
    }

    private void addAttributeAsChildrenBuilder(Iterator<Attribute> attributes, TemplateBuilder parentBuilder) {
        while (attributes.hasNext()) {
            Attribute attribute = attributes.next();
            if (!this.canEncodeAttribute(attribute.getName())) continue;
            this.maker.namespaces(this.namespaceSupport).name(this.strName(attribute.getName())).contentAndFilter(attribute.getValue()).encodingOption("ENCODE_AS_ATTRIBUTE", true);
            parentBuilder.addChild(this.maker.build());
        }
    }

    private String getAttributeValueIfPresent(StartElement startElement, String attributeName) {
        String[] attributeArr;
        Attribute attribute = startElement.getAttributeByName(new QName(attributeName));
        if (attribute == null && (attributeArr = attributeName.split(":")).length > 1) {
            attribute = startElement.getAttributeByName(new QName("", attributeArr[1], attributeArr[0]));
        }
        if (attribute == null) {
            return null;
        }
        return attribute.getValue();
    }

    String localPart(QName name) {
        String[] nameAr = name.getLocalPart().split(":");
        String strName = nameAr.length > 1 ? nameAr[1] : name.getLocalPart();
        return strName;
    }

    String strName(QName name) {
        Object strName;
        String[] nameAr = name.getLocalPart().split(":");
        if (nameAr.length > 1) {
            strName = nameAr[0] + ":" + nameAr[1];
        } else {
            strName = name.getLocalPart();
            String prefix = name.getPrefix();
            if (prefix != null && !prefix.trim().equals("")) {
                strName = name.getPrefix() + ":" + (String)strName;
            }
        }
        return strName;
    }

    private boolean canEncodeAttribute(QName name) {
        boolean hasPrefix = name.getPrefix() != null && !name.getPrefix().equals("");
        Object strName = name.getLocalPart();
        if (hasPrefix) {
            strName = name.getPrefix() + ":" + (String)strName;
        }
        return !((String)strName).equals(FILTER_ATTR) && !((String)strName).equals(SOURCE_ATTR) && !((String)strName).equals(COLLECTION_ATTR);
    }

    private void builderFromIncludedTemplate(Resource resource, String data, TemplateBuilder currentParent) throws IOException {
        Resource included = this.getResource(resource.parent(), data);
        try (XMLRecursiveTemplateReader recursiveParser = this.getNewInstanceForRecursiveReading(included, this, this.namespaceSupport);){
            recursiveParser.iterateReader(currentParent);
        }
    }

    protected abstract XMLRecursiveTemplateReader getNewInstanceForRecursiveReading(Resource var1, XMLRecursiveTemplateReader var2, NamespaceSupport var3) throws IOException;

    @Override
    public void close() {
        try {
            this.inputSource.close();
            this.reader.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private XMLEventReader getEventReader(Resource resource) throws XMLStreamException {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        xmlInputFactory.setProperty("javax.xml.stream.isNamespaceAware", false);
        xmlInputFactory.setProperty("javax.xml.stream.isValidating", false);
        this.inputSource = resource.in();
        return xmlInputFactory.createXMLEventReader(this.inputSource);
    }

    private void iterateVendorOptionsElement(TemplateBuilder builder) throws IOException {
        if (!(builder instanceof RootBuilder)) {
            throw new UnsupportedOperationException("Options can be defined only at the beginning of the template");
        }
        RootBuilder rootBuilder = (RootBuilder)builder;
        try {
            while (this.reader.hasNext()) {
                XMLEvent event = this.reader.nextEvent();
                if (event.isStartElement()) {
                    this.addVendorOption(event.asStartElement(), rootBuilder);
                    continue;
                }
                if (event.isCharacters()) {
                    Characters characters = event.asCharacters();
                    if (!this.canParseTextContent(characters)) continue;
                    this.addVendorOption(characters, rootBuilder);
                    continue;
                }
                if (!event.isEndElement() || !event.asEndElement().getName().toString().equals(VENDOR_OPTIONS_EL)) continue;
                break;
            }
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    protected abstract void addVendorOption(StartElement var1, RootBuilder var2);

    protected abstract void addVendorOption(Characters var1, RootBuilder var2);

    protected abstract boolean hasOwnOutput(String var1);

    private boolean isRootOrManaged(TemplateBuilder parent) {
        return parent instanceof RootBuilder || !((SourceBuilder)parent).hasOwnOutput();
    }

    private boolean canParseTextContent(Characters characters) {
        return !characters.isIgnorableWhiteSpace() && !characters.isWhiteSpace() && !characters.isEntityReference();
    }
}

