/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.readers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.StartElement;
import org.geoserver.featurestemplating.builders.impl.RootBuilder;
import org.geoserver.featurestemplating.readers.XMLRecursiveTemplateReader;
import org.geoserver.platform.resource.Resource;
import org.xml.sax.helpers.NamespaceSupport;

public class XHTMLTemplateReader
extends XMLRecursiveTemplateReader {
    protected Stack<String> optionsNamesStack = new Stack();

    public XHTMLTemplateReader(Resource resource, NamespaceSupport namespaceSupport) throws IOException {
        super(resource, namespaceSupport);
    }

    public XHTMLTemplateReader(Resource resource, XMLRecursiveTemplateReader parent, NamespaceSupport namespaceSupport) throws IOException {
        super(resource, parent, namespaceSupport);
    }

    @Override
    protected XMLRecursiveTemplateReader getNewInstanceForRecursiveReading(Resource included, XMLRecursiveTemplateReader parent, NamespaceSupport namespaceSupport) throws IOException {
        return new XHTMLTemplateReader(included, this, namespaceSupport);
    }

    @Override
    protected void addVendorOption(StartElement element, RootBuilder builder) {
        String elementName = element.getName().toString();
        if (elementName.equalsIgnoreCase("script") || elementName.equalsIgnoreCase("style")) {
            Attribute attribute = element.getAttributeByName(new QName("type"));
            if (attribute != null && attribute.getValue().equals("application/ld+json")) {
                builder.addVendorOption("JSON_LD_SCRIPT", true);
            } else {
                this.optionsNamesStack.add(elementName);
            }
        } else if (elementName.equalsIgnoreCase("link")) {
            Iterator<Attribute> attributeIterator = element.getAttributes();
            ArrayList<Attribute> attributes = new ArrayList<Attribute>();
            while (attributeIterator.hasNext()) {
                Attribute attr = attributeIterator.next();
                attributes.add(attr);
            }
            if (!attributes.isEmpty()) {
                builder.addVendorOption("link" + element.hashCode(), attributes);
            }
        }
    }

    @Override
    protected void addVendorOption(Characters character, RootBuilder builder) {
        if (!this.optionsNamesStack.isEmpty()) {
            String name = this.optionsNamesStack.pop();
            String optionName = null;
            if (name.equalsIgnoreCase("style")) {
                optionName = "style";
            } else if (name.equalsIgnoreCase("script")) {
                optionName = "script";
            }
            if (optionName != null) {
                String content = character.getData();
                builder.addVendorOption(optionName, content);
            }
        }
    }

    @Override
    protected boolean hasOwnOutput(String elementName) {
        return true;
    }
}

