/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.readers;

import java.io.IOException;
import org.geoserver.featurestemplating.readers.GMLTemplateReader;
import org.geoserver.featurestemplating.readers.JSONTemplateReader;
import org.geoserver.featurestemplating.readers.RecursiveJSONParser;
import org.geoserver.featurestemplating.readers.TemplateReader;
import org.geoserver.featurestemplating.readers.TemplateReaderConfiguration;
import org.geoserver.featurestemplating.readers.XHTMLTemplateReader;
import org.geoserver.platform.resource.Resource;

public class TemplateReaderProvider {
    public static TemplateReader findReader(String resourceExtension, Resource resource, TemplateReaderConfiguration configuration) throws IOException {
        TemplateReader reader;
        if (resourceExtension.equalsIgnoreCase(SupportedExtension.JSON.name())) {
            RecursiveJSONParser parser = new RecursiveJSONParser(resource, configuration.getRootCollectionName());
            reader = new JSONTemplateReader(parser.parse(), configuration, parser.getWatchers());
        } else if (resourceExtension.equalsIgnoreCase(SupportedExtension.XML.name())) {
            reader = new GMLTemplateReader(resource, configuration.getNamespaces());
        } else if (resourceExtension.equalsIgnoreCase(SupportedExtension.XHTML.name())) {
            reader = new XHTMLTemplateReader(resource, configuration.getNamespaces());
        } else {
            throw new UnsupportedOperationException("Not a supported extension " + resourceExtension);
        }
        return reader;
    }

    static enum SupportedExtension {
        JSON,
        XML,
        XHTML;

    }
}

