/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.readers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.geoserver.featurestemplating.builders.AbstractTemplateBuilder;
import org.geoserver.featurestemplating.builders.SourceBuilder;
import org.geoserver.featurestemplating.builders.TemplateBuilder;
import org.geoserver.featurestemplating.builders.TemplateBuilderMaker;
import org.geoserver.featurestemplating.builders.impl.RootBuilder;
import org.geoserver.featurestemplating.expressions.TemplateCQLManager;
import org.geoserver.featurestemplating.readers.TemplateReader;
import org.geoserver.featurestemplating.readers.TemplateReaderConfiguration;
import org.geoserver.platform.FileWatcher;
import org.geotools.api.filter.expression.Expression;
import org.geotools.filter.LiteralExpressionImpl;

public class JSONTemplateReader
implements TemplateReader {
    public static final String SOURCEKEY = "$source";
    public static final String CONTEXTKEY = "@context";
    public static final String FILTERKEY = "$filter";
    public static final String EXPRSTART = "${";
    public static final String VENDOROPTION = "$options";
    private JsonNode template;
    private TemplateReaderConfiguration configuration;
    private List<FileWatcher<Object>> watchers;

    public JSONTemplateReader(JsonNode template, TemplateReaderConfiguration configuration, List<FileWatcher<Object>> watchers) {
        this.template = template;
        this.configuration = configuration;
        this.watchers = watchers;
    }

    @Override
    public RootBuilder getRootBuilder() {
        TemplateBuilderMaker builderMaker = this.configuration.getBuilderMaker();
        if (this.template.has(CONTEXTKEY)) {
            builderMaker.encodingOption(CONTEXTKEY, this.template.get(CONTEXTKEY));
        }
        builderMaker.rootBuilder(true);
        RootBuilder root = (RootBuilder)builderMaker.build();
        builderMaker.namespaces(this.configuration.getNamespaces());
        this.getBuilderFromJson(null, this.template, root, builderMaker);
        root.setWatchers(this.watchers);
        return root;
    }

    public void getBuilderFromJson(String nodeName, JsonNode node, TemplateBuilder currentBuilder, TemplateBuilderMaker maker) {
        if (node.isObject()) {
            this.getBuilderFromJsonObject(node, currentBuilder, maker);
        } else if (node.isArray()) {
            this.getBuilderFromJsonArray(nodeName, node, currentBuilder, maker);
        } else {
            this.getBuilderFromJsonAttribute(nodeName, node, currentBuilder, maker);
        }
    }

    private void getBuilderFromJsonObject(JsonNode node, TemplateBuilder currentBuilder, TemplateBuilderMaker maker) {
        if (this.isArrayControlNode(node)) {
            if (node.has(SOURCEKEY)) {
                String source = node.get(SOURCEKEY).asText();
                ((SourceBuilder)currentBuilder).setSource(source);
            }
            if (node.has(FILTERKEY)) {
                this.setFilterToBuilder(currentBuilder, node);
            }
        } else {
            Iterator iterator = node.fields();
            while (iterator.hasNext()) {
                boolean jumpField;
                Map.Entry nodEntry = (Map.Entry)iterator.next();
                String entryName = (String)nodEntry.getKey();
                JsonNode valueNode = (JsonNode)nodEntry.getValue();
                String strValueNode = valueNode.toString();
                boolean bl = jumpField = entryName.equalsIgnoreCase("type") && valueNode.asText().equals("FeatureCollection") || entryName.equalsIgnoreCase("features");
                if (entryName.equals(SOURCEKEY)) {
                    String source = valueNode.asText();
                    if (!((currentBuilder = this.createCompositeIfNeeded(currentBuilder, maker)) instanceof SourceBuilder)) continue;
                    ((SourceBuilder)currentBuilder).setSource(source);
                    continue;
                }
                if (entryName.equals(FILTERKEY)) {
                    currentBuilder = this.createCompositeIfNeeded(currentBuilder, maker);
                    this.setFilterToBuilder(currentBuilder, node);
                    continue;
                }
                if (entryName.equals(CONTEXTKEY)) {
                    RootBuilder rootBuilder = (RootBuilder)currentBuilder;
                    if (rootBuilder.getEncodingHints().get(CONTEXTKEY) != null) continue;
                    rootBuilder.getEncodingHints().put(CONTEXTKEY, valueNode);
                    continue;
                }
                if (entryName.equals(VENDOROPTION)) {
                    this.setVendorOptions(valueNode, (RootBuilder)currentBuilder, maker);
                    continue;
                }
                if (!(strValueNode.contains(EXPRSTART) || strValueNode.contains(FILTERKEY) || jumpField)) {
                    currentBuilder = this.createCompositeIfNeeded(currentBuilder, maker);
                    maker.name(entryName).jsonNode(valueNode);
                    currentBuilder.addChild(maker.build());
                    continue;
                }
                if (entryName.startsWith("$includeFlat")) {
                    currentBuilder = this.createCompositeIfNeeded(currentBuilder, maker);
                    ObjectNode objectNode = (ObjectNode)node;
                    ObjectNode container = (ObjectNode)objectNode.remove("$includeFlat");
                    JsonNode includingNode = container.remove("$includingNode");
                    JsonNode exprNode = container.remove("$includeExpression");
                    currentBuilder.addChild(maker.jsonNode(valueNode).dynamicIncludeFlatBuilder(true).baseNode(includingNode).textContent(exprNode.asText()).build());
                    continue;
                }
                if (valueNode.isObject()) {
                    if (entryName.startsWith("$dynamicMerge_")) {
                        if (!valueNode.fields().hasNext()) continue;
                        currentBuilder = this.createCompositeIfNeeded(currentBuilder, maker);
                        Map.Entry fieldNode = (Map.Entry)valueNode.fields().next();
                        String key = (String)fieldNode.getKey();
                        JsonNode innerNode = (JsonNode)fieldNode.getValue();
                        JsonNode overlay = innerNode.get("overlay");
                        JsonNode baseMergeNode = innerNode.get("base");
                        currentBuilder.addChild(maker.overlayNode(overlay).name(key).baseNode(baseMergeNode).build());
                        continue;
                    }
                    maker.name(entryName);
                    maker.topLevelFeature(this.isRootOrHasNotOwnOutput(currentBuilder));
                    TemplateBuilder compositeBuilder = maker.build();
                    currentBuilder.addChild(compositeBuilder);
                    this.getBuilderFromJsonObject(valueNode, compositeBuilder, maker);
                    continue;
                }
                if (valueNode.isArray()) {
                    this.getBuilderFromJsonArray(entryName, valueNode, currentBuilder, maker);
                    continue;
                }
                if (jumpField) continue;
                currentBuilder = this.createCompositeIfNeeded(currentBuilder, maker);
                this.getBuilderFromJsonAttribute(entryName, valueNode, currentBuilder, maker);
            }
        }
    }

    private void getBuilderFromJsonArray(String nodeName, JsonNode node, TemplateBuilder currentBuilder, TemplateBuilderMaker maker) {
        if (!node.toString().contains(EXPRSTART) && !node.toString().contains(FILTERKEY)) {
            maker.name(nodeName).jsonNode(node);
            currentBuilder.addChild(maker.build());
        } else {
            ArrayList<JsonNode> expressionNodes = new ArrayList<JsonNode>();
            ArrayNode arrayNode = this.cleanFromExpressionNodes((ArrayNode)node, expressionNodes);
            if (!expressionNodes.isEmpty()) {
                this.addArrayIncludeFlat(currentBuilder, maker, arrayNode, nodeName, expressionNodes);
            } else {
                this.buildIteratingBuilder(nodeName, currentBuilder, (ArrayNode)node, maker);
            }
        }
    }

    private void buildIteratingBuilder(String nodeName, TemplateBuilder currentBuilder, ArrayNode node, TemplateBuilderMaker maker) {
        TemplateBuilder iteratingBuilder = maker.name(nodeName).collection(true).topLevelFeature(this.isRootOrHasNotOwnOutput(currentBuilder)).build();
        currentBuilder.addChild(iteratingBuilder);
        Iterator arrayIterator = node.elements();
        while (arrayIterator.hasNext()) {
            JsonNode childNode = (JsonNode)arrayIterator.next();
            if (childNode.isObject()) {
                String childJSON = childNode.toString();
                if (this.isArrayControlNode(childNode)) {
                    this.getBuilderFromJsonObject(childNode, iteratingBuilder, maker);
                    continue;
                }
                if (childJSON.contains(EXPRSTART) || childJSON.contains(FILTERKEY)) {
                    TemplateBuilder compositeBuilder = maker.topLevelFeature(this.isRootOrHasNotOwnOutput(currentBuilder)).build();
                    iteratingBuilder.addChild(compositeBuilder);
                    this.getBuilderFromJsonObject(childNode, compositeBuilder, maker);
                    continue;
                }
                maker.jsonNode(childNode);
                iteratingBuilder.addChild(maker.build());
                continue;
            }
            if (childNode.isArray()) {
                this.getBuilderFromJsonArray(null, childNode, iteratingBuilder, maker);
                continue;
            }
            this.getBuilderFromJsonAttribute(null, childNode, iteratingBuilder, maker);
        }
    }

    private void addArrayIncludeFlat(TemplateBuilder currentBuilder, TemplateBuilderMaker maker, ArrayNode node, String nodeName, List<JsonNode> expressionNodes) {
        TemplateBuilder arrayIncludeFlat = maker.dynamicIncludeFlatBuilder(true).baseNode((JsonNode)node).name(nodeName).textContent("${.}").collection(true).build();
        currentBuilder.addChild(arrayIncludeFlat);
        for (JsonNode jsonNode : expressionNodes) {
            String text;
            if (!jsonNode.isValueNode() || !(text = jsonNode.asText()).startsWith("$includeFlat{") || !text.endsWith("}")) continue;
            text = text.substring("$includeFlat".length() + 1, text.length() - 1);
            arrayIncludeFlat.addChild(maker.textContent(text).build());
        }
    }

    private ArrayNode cleanFromExpressionNodes(ArrayNode arrNode, List<JsonNode> nodes) {
        Iterator elements = arrNode.elements();
        ArrayNode arrayNode = null;
        while (elements.hasNext()) {
            JsonNode next = (JsonNode)elements.next();
            if (next.isValueNode() && next.asText().startsWith("$includeFlat")) {
                nodes.add(next);
                continue;
            }
            if (arrayNode == null) {
                arrayNode = JsonNodeFactory.instance.arrayNode();
            }
            arrayNode.add(next);
        }
        return arrayNode;
    }

    private boolean isArrayControlNode(JsonNode node) {
        return node.size() == 1 && (node.has(SOURCEKEY) || node.has(FILTERKEY)) || node.size() == 2 && node.has(SOURCEKEY) && node.has(FILTERKEY);
    }

    private void getBuilderFromJsonAttribute(String nodeName, JsonNode node, TemplateBuilder currentBuilder, TemplateBuilderMaker maker) {
        String strNode = node.asText();
        if (!node.asText().contains("FeatureCollection")) {
            maker.name(nodeName).contentAndFilter(strNode);
            TemplateBuilder builder = maker.build();
            currentBuilder.addChild(builder);
        }
    }

    private void setFilterToBuilder(TemplateBuilder builder, JsonNode node) {
        String filter = node.get(FILTERKEY).asText();
        ((AbstractTemplateBuilder)builder).setFilter(filter);
    }

    private void setVendorOptions(JsonNode node, RootBuilder builder, TemplateBuilderMaker maker) {
        if (!node.isObject()) {
            throw new RuntimeException("VendorOptions should be defined as a JSON object");
        }
        this.addOptionIfPresent(builder, "flat_output", node);
        this.addOptionIfPresent(builder, "separator", node);
        this.addOptionIfPresent(builder, "encode_as_string", node);
        this.addOptionIfPresent(builder, "collection_name", node);
        this.addOptionIfPresent(builder, "@type", node);
        if (node.has(CONTEXTKEY)) {
            builder.addVendorOption(CONTEXTKEY, node.get(CONTEXTKEY));
        }
        Expression flatOutput = (Expression)builder.getVendorOptions().get("flat_output", Expression.class, new LiteralExpressionImpl((Object)false));
        boolean bFlatOutput = (Boolean)flatOutput.evaluate(null, Boolean.class);
        Expression expression = (Expression)builder.getVendorOptions().get("separator", Expression.class, new LiteralExpressionImpl((Object)"_"));
        maker.flatOutput(bFlatOutput).separator((String)expression.evaluate(null, String.class));
    }

    private void addOptionIfPresent(RootBuilder builder, String optionName, JsonNode node) {
        if (node.has(optionName)) {
            TemplateCQLManager cqlManager = new TemplateCQLManager(node.get(optionName).asText(), null);
            builder.addVendorOption(optionName, cqlManager.getExpressionFromString());
        }
    }

    private TemplateBuilder createCompositeIfNeeded(TemplateBuilder currentParent, TemplateBuilderMaker maker) {
        TemplateBuilder builder;
        if (currentParent instanceof RootBuilder) {
            maker.topLevelFeature(true);
            builder = maker.build();
            currentParent.addChild(builder);
        } else {
            builder = currentParent;
        }
        return builder;
    }

    private boolean isRootOrHasNotOwnOutput(TemplateBuilder parent) {
        return parent instanceof RootBuilder || parent instanceof SourceBuilder && !((SourceBuilder)parent).hasOwnOutput();
    }
}

