/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.readers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.function.Predicate;
import org.apache.commons.collections4.IteratorUtils;

public class JSONMerger {
    public static final String DYNAMIC_MERGE_KEY = "$dynamicMerge_";
    public static final String DYNAMIC_MERGE_OVERLAY = "overlay";
    public static final String DYNAMIC_MERGE_BASE = "base";
    private String rootCollectionName = "features";

    public JSONMerger() {
    }

    public JSONMerger(String rootCollectionName) {
        this.rootCollectionName = rootCollectionName;
    }

    public ObjectNode mergeTrees(JsonNode base, JsonNode overlay) {
        if (base.getNodeType() != JsonNodeType.OBJECT || overlay.getNodeType() != JsonNodeType.OBJECT) {
            throw new IllegalArgumentException("Trying to merge but either source or target are not objects:\n" + base.toPrettyString() + "\n" + overlay.toPrettyString());
        }
        return this.mergeTrees((ObjectNode)base, (ObjectNode)overlay);
    }

    private ObjectNode mergeTrees(ObjectNode base, ObjectNode overlay) {
        JsonNode ov;
        LinkedHashSet baseNames = new LinkedHashSet(IteratorUtils.toList((Iterator)base.fieldNames()));
        ObjectNode merged = JsonNodeFactory.instance.objectNode();
        for (String name : baseNames) {
            ObjectNode mergedChild;
            JsonNode bv = base.get(name);
            ov = overlay.get(name);
            if (ov == null) {
                merged.set(name, bv);
                continue;
            }
            if (ov instanceof ObjectNode && bv instanceof ObjectNode) {
                mergedChild = this.mergeTrees((ObjectNode)bv, (ObjectNode)ov);
                merged.set(name, (JsonNode)mergedChild);
                continue;
            }
            if (this.isRootCollectionArray(name, bv, ov)) {
                merged.set(name, bv);
                mergedChild = this.mergeTrees(bv.get(0), ov.get(0));
                ((ArrayNode)merged.get(name)).set(0, (JsonNode)mergedChild);
                continue;
            }
            if (ov.getNodeType() == JsonNodeType.NULL) continue;
            if (this.isDynamicMerge(ov, bv)) {
                this.dynamicMergeDirective(merged, name, bv, ov);
                continue;
            }
            merged.set(name, ov);
        }
        LinkedHashSet overlayNames = new LinkedHashSet(IteratorUtils.toList((Iterator)overlay.fieldNames()));
        overlayNames.removeAll(baseNames);
        for (String name : overlayNames) {
            ov = overlay.get(name);
            merged.set(name, ov);
        }
        return merged;
    }

    private boolean isDynamicMerge(JsonNode ov, JsonNode bv) {
        Predicate<JsonNode> isDynamic = node -> node.isTextual() && (node.asText().startsWith("${") || node.asText().startsWith("$${"));
        Predicate<JsonNode> isObject = node -> node.getNodeType() == JsonNodeType.OBJECT;
        return isDynamic.test(ov) && isObject.test(bv) || isDynamic.test(bv) && isObject.test(ov);
    }

    private void dynamicMergeDirective(ObjectNode merged, String name, JsonNode bv, JsonNode ov) {
        ObjectNode emptyNode = JsonNodeFactory.instance.objectNode();
        ObjectNode emptyNode2 = JsonNodeFactory.instance.objectNode();
        String key = DYNAMIC_MERGE_KEY.concat(name);
        merged.set(key, (JsonNode)emptyNode);
        merged.with(key).set(name, (JsonNode)emptyNode2);
        merged.with(key).with(name).set(DYNAMIC_MERGE_OVERLAY, ov);
        merged.with(key).with(name).set(DYNAMIC_MERGE_BASE, bv);
    }

    private boolean isRootCollectionArray(String name, JsonNode bv, JsonNode ov) {
        return this.rootCollectionName.equals(name) && bv instanceof ArrayNode && ov instanceof ArrayNode && bv.size() == 1 && ov.size() == 1 && bv.get(0) instanceof ObjectNode && ov.get(0) instanceof ObjectNode;
    }
}

